/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

public abstract class DebuggerEventSource {
    public static final int LANGUAGE_UNKNOWN = 0;
    public static final int LANGUAGE_JAVA = 1;
    public static final int LANGUAGE_PLSQL = 2;
    public static final int LANGUAGE_XSLT = 4;
    public static final int LANGUAGE_ANT = 8;
    public static final int DEBUGGER_STATE_STARTING = 100;
    public static final int DEBUGGER_STATE_STOPPING_BREAKPOINT = 200;
    public static final int DEBUGGER_STATE_STOPPING_FINISHEDSTEPPING = 201;
    public static final int DEBUGGER_STATE_STOPPING_PAUSED = 202;
    public static final int DEBUGGER_STATE_RESUMING_RESUME = 300;
    public static final int DEBUGGER_STATE_RESUMING_STEPOVER = 301;
    public static final int DEBUGGER_STATE_RESUMING_STEPINTO = 302;
    public static final int DEBUGGER_STATE_RESUMING_STEPOUT = 303;
    public static final int DEBUGGER_STATE_RESUMING_STEPTOENDOFMETHOD = 304;
    public static final int DEBUGGER_STATE_RESUMING_CONTINUESTEP = 305;
    public static final int DEBUGGER_STATE_RESUMING_RUNTOCURSOR = 306;
    public static final int DEBUGGER_STATE_FINISHED_PROGRAMEXIT = 400;
    public static final int DEBUGGER_STATE_FINISHED_CONNECTIONLOST = 401;
    public static final int DEBUGGER_STATE_FINISHED_TERMINATE = 402;
    public static final int DEBUGGER_STATE_FINISHED_DETACH = 403;

    public abstract int getLanguages();

    public abstract int getState();

    public abstract StackFrame[] getStackFrames();

    public static final class StackFrame {
        public final String className;
        public final String prettyClassName;
        public final String methodName;
        public final String prettyMethodName;
        public final String methodSignature;
        public final String prettyMethodSignature;
        public final int methodAccess;
        public final long thisID;
        public final String thisClassName;
        public final String prettyThisClassName;
        public final String filename;
        public final int lineNumber;
        public int language;

        public StackFrame(String string, String string2, String string3, String string4, int n) {
            this(string, string2, string3, 0, 0L, string4, n);
        }

        public StackFrame(String string, String string2, String string3, int n, long l, String string4, int n2) {
            this(string, string2, string3, n, l, null, string4, n2);
        }

        public StackFrame(String string, String string2, String string3, int n, long l, String string4, String string5, int n2) {
            this(string, string, string2, string2, string3, string3, n, l, string4, string4, string5, n2, 0);
        }

        public StackFrame(String string, String string2, String string3, String string4, String string5, String string6, int n, long l, String string7, String string8, String string9, int n2, int n3) {
            this.className = string;
            this.prettyClassName = string2;
            this.methodName = string3;
            this.prettyMethodName = string4;
            this.methodSignature = string5;
            this.prettyMethodSignature = string6;
            this.methodAccess = n;
            this.thisID = l;
            this.thisClassName = string7;
            this.prettyThisClassName = string8;
            this.filename = string9;
            this.lineNumber = n2;
            this.language = n3;
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode() + this.methodSignature.hashCode() + this.filename.hashCode() + this.lineNumber;
        }

        public boolean equals(Object object) {
            if (object.getClass() == StackFrame.class) {
                return this.equals((StackFrame)object);
            }
            return false;
        }

        public boolean equals(StackFrame stackFrame) {
            return this.className.equals(stackFrame.className) && this.methodName.equals(stackFrame.methodName) && this.methodSignature.equals(stackFrame.methodSignature) && this.thisID == stackFrame.thisID;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("StackTrace[");
            stringBuffer.append(this.className);
            stringBuffer.append('.');
            stringBuffer.append(this.methodName);
            stringBuffer.append(this.methodSignature);
            stringBuffer.append(':');
            stringBuffer.append(this.lineNumber);
            stringBuffer.append(" @");
            stringBuffer.append(this.thisID);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

