/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import oracle.ide.log.LogPage;
import oracle.ide.log.StyledMessage;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;

final class LogOutputThread
extends Thread {
    private final RunProcess runProcess;
    private final LogPage logPage;
    private final AttributeSet attributeSet;
    private final InputStreamReader reader;
    private List duplicates;
    private final char[] array;
    private int len;
    private long[] timeLastRead;

    void $init$() {
        this.array = new char[1000];
        this.timeLastRead = new long[1];
    }

    LogOutputThread(String string, RunProcess runProcess, LogPage logPage, AttributeSet attributeSet, InputStream inputStream, List list) {
        super("LogOutput - " + string);
        this.$init$();
        this.runProcess = runProcess;
        this.logPage = logPage;
        this.attributeSet = attributeSet;
        this.reader = new InputStreamReader(inputStream);
        this.makeDuplicates(list);
    }

    public void run() {
        this.setTimeLastRead();
        StringBuffer stringBuffer = null;
        while (true) {
            try {
                try {
                    this.len = this.reader.read(this.array);
                }
                catch (IOException iOException) {
                    this.len = -1;
                }
                this.setTimeLastRead();
                if (this.len == -1) {
                    if (stringBuffer == null) break;
                    this.log(stringBuffer.toString());
                    stringBuffer = null;
                    break;
                }
                this.writeDuplicates();
                if (this.logPage == null) continue;
                StringBuffer stringBuffer2 = stringBuffer != null ? stringBuffer : new StringBuffer();
                stringBuffer = null;
                stringBuffer2.append(this.array, 0, this.len);
                char c = this.array[this.len - 1];
                if (c != '\r' && c != '\n') {
                    int n;
                    int n2 = stringBuffer2.lastIndexOf("\r");
                    int n3 = Math.max(n2, n = stringBuffer2.lastIndexOf("\n")) + 1;
                    if (n3 == 0) {
                        stringBuffer = stringBuffer2;
                        stringBuffer2 = null;
                    } else {
                        stringBuffer = new StringBuffer(stringBuffer2.substring(n3));
                        stringBuffer2.delete(n3, stringBuffer2.length());
                    }
                }
                if (stringBuffer2 != null) {
                    this.log(stringBuffer2.toString());
                    stringBuffer2 = null;
                }
                if (stringBuffer == null || this.reader.ready()) continue;
                while (!this.reader.ready()) {
                    if (System.currentTimeMillis() - this.getTimeLastRead() > 500L) break;
                    LogOutputThread.trySleep(10);
                }
                if (this.reader.ready()) continue;
                this.log(stringBuffer.toString());
                stringBuffer = null;
            }
            catch (Exception exception) {}
        }
        this.closeDuplicates();
    }

    private void log(String string) {
        StyledMessage styledMessage = new StyledMessage(this.attributeSet, string);
        if (this.logPage instanceof RunLogPage) {
            ((RunLogPage)this.logPage).logWithoutShow(styledMessage);
        } else {
            this.logPage.log(styledMessage);
        }
        if (!this.runProcess.doUILater()) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            int n = 100;
            while (eventQueue.peekEvent() != null && n < 1000) {
                LogOutputThread.trySleep(n);
                n *= 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeLastRead() {
        long[] lArray = this.timeLastRead;
        synchronized (this.timeLastRead) {
            this.timeLastRead[0] = System.currentTimeMillis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeLastRead() {
        long[] lArray = this.timeLastRead;
        synchronized (this.timeLastRead) {
            long l = this.timeLastRead[0];
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return l;
        }
    }

    static synchronized void waitForOutput(LogOutputThread logOutputThread) {
        while (logOutputThread.isAlive()) {
            if (System.currentTimeMillis() - logOutputThread.getTimeLastRead() > 1000L) break;
            LogOutputThread.trySleep(100);
        }
    }

    private void makeDuplicates(List list) {
        if (list != null) {
            this.duplicates = new ArrayList();
            int n = list.size() - 1;
            while (n >= 0) {
                try {
                    PipedInputStream pipedInputStream = (PipedInputStream)list.get(n);
                    this.duplicates.add(new OutputStreamWriter(new PipedOutputStream(pipedInputStream)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --n;
            }
        }
    }

    private void writeDuplicates() {
        if (this.duplicates != null) {
            int n = this.duplicates.size() - 1;
            while (n >= 0) {
                try {
                    OutputStreamWriter outputStreamWriter = (OutputStreamWriter)this.duplicates.get(n);
                    outputStreamWriter.write(this.array, 0, this.len);
                    outputStreamWriter.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --n;
            }
        }
    }

    private void closeDuplicates() {
        if (this.duplicates != null) {
            int n = this.duplicates.size() - 1;
            while (n >= 0) {
                try {
                    OutputStreamWriter outputStreamWriter = (OutputStreamWriter)this.duplicates.get(n);
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --n;
            }
        }
    }

    private static void trySleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

