/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.Helpable;
import oracle.ide.layout.ViewId;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.MessagePage;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunProcess;
import oracle.ide.view.View;

public final class RunLogPage
extends MessagePage
implements Helpable {
    private static final String RUN_LOG_PAGE = "RunLogPage";
    private static final char EOL = '\n';
    private static final int TERMINATE_CMD_ID = Ide.findOrCreateCmdID("TERMINATE_CMD_ID");
    private static final int STACK_TRACES_CMD_ID = Ide.findOrCreateCmdID("STACK_TRACES_CMD_ID");
    private static Controller controller;
    private List stackFrames;
    private JPanel panel;
    private JPanel northPanel;
    private Component northComponent;
    private JPanel southPanel;
    private JTextField textField;
    private OutputStreamWriter writer;
    private String name;
    private Workspace workspace;
    private Project project;
    private String tooltip;
    private String titleName;
    private HelpInfo helpInfo;
    private volatile boolean runProcessStarted;
    private volatile RunProcess runProcessAlive;
    private boolean needNewLine;
    private static List allPages;
    private static int systemInColor;
    private static SimpleAttributeSet systemInAttributeSet;

    static {
        allPages = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RunLogPage makePage(RunProcess runProcess, boolean bl) {
        List list = allPages;
        synchronized (list) {
            RunLogPage runLogPage = null;
            for (RunLogPage runLogPage2 : allPages) {
                if (!runProcess.reuseLogPage(runLogPage2)) continue;
                runLogPage = runLogPage2;
                break;
            }
            if (runLogPage != null) {
                runLogPage.setStuff(runProcess);
            } else if (bl) {
                runLogPage = new RunLogPage(runProcess, runProcess.getShortLabel(), runProcess.getIcon());
                allPages.add(runLogPage);
            }
            RunLogPage runLogPage3 = runLogPage;
            return runLogPage3;
        }
    }

    private RunLogPage(RunProcess runProcess, String string, Icon icon) {
        super(new ViewId(RUN_LOG_PAGE, string), icon, false, true);
        this.name = string;
        this.setStuff(runProcess);
        this.stackFrames = new ArrayList();
        LogManager.getLogManager().addPage(this);
        if (controller == null) {
            controller = RunLogPage.makeController();
            IdeAction ideAction = IdeAction.get(TERMINATE_CMD_ID, null, RunMgrArb.getString(10), null, RunMgrArb.getInteger(11), null, null, true);
            ideAction.addController(controller);
            IdeAction ideAction2 = IdeAction.get(STACK_TRACES_CMD_ID, null, RunMgrArb.getString(12), null, RunMgrArb.getInteger(13), null, null, true);
            ideAction2.addController(controller);
            LogManager.getLogManager().getContextMenu().addContextMenuListener(RunLogPage.makeContextMenuListener());
        }
    }

    private static Controller makeController() {
        return new 4();
    }

    private static ContextMenuListener makeContextMenuListener() {
        return new 3();
    }

    private void setStuff(RunProcess runProcess) {
        this.workspace = runProcess.getWorkspace();
        this.project = runProcess.getProject();
        this.tooltip = runProcess.getToolTipText();
        this.titleName = runProcess.getShortLabelWithPrefix();
        this.helpInfo = runProcess.getHelpInfo();
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        if (environOptions.isSaveLogToFile()) {
            URL uRL = environOptions.getLogFilePreffix();
            String string = URLFileSystem.getPlatformPathName(uRL).trim() + File.separator;
            int n = this.titleName.lastIndexOf(46);
            String string2 = n != -1 ? this.titleName.substring(0, n).trim() : this.titleName.trim();
            this.setLogFileName(string + string2.replace(':', '_').replace(' ', '_'));
        }
    }

    public Component getGUI() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add(super.getGUI(), "Center");
            this.northPanel = new JPanel(new BorderLayout());
            this.northPanel.setVisible(false);
            this.panel.add((Component)this.northPanel, "North");
            this.southPanel = new JPanel(new BorderLayout());
            this.southPanel.setVisible(false);
            JLabel jLabel = new JLabel(RunMgrArb.getString(8));
            this.southPanel.add((Component)jLabel, "West");
            this.textField = new JTextField();
            this.textField.addActionListener(new 2());
            this.southPanel.add((Component)this.textField, "Center");
            this.panel.add((Component)this.southPanel, "South");
        }
        return this.panel;
    }

    private static synchronized SimpleAttributeSet getSystemInAttributeSet() {
        if (systemInAttributeSet == null) {
            systemInAttributeSet = new SimpleAttributeSet();
        }
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        if (systemInColor == 0 || systemInColor != environOptions.getLogSystemInColor()) {
            systemInColor = environOptions.getLogSystemInColor();
            StyleConstants.setForeground(systemInAttributeSet, new Color(systemInColor));
        }
        return systemInAttributeSet;
    }

    public Context getContext(EventObject eventObject) {
        Workspaces workspaces;
        List list;
        Context context = Context.newIdeContext(this, eventObject);
        if (this.workspace != Ide.getDefaultWorkspace() && this.project != Ide.getDefaultProject() && (list = (workspaces = Ide.getWorkspaces()).getListOfChildren()) != null && list.contains(this.workspace)) {
            context.setWorkspace(this.workspace);
            if (this.workspace.containsChild(this.project)) {
                context.setProject(this.project);
            }
        }
        return context;
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        super.updateVisibleActions(updateMessage);
        if (this.northComponent instanceof Toolbar) {
            Toolbar toolbar = (Toolbar)this.northComponent;
            RunLogPage.updateToolbarActions(toolbar);
        }
    }

    public String getName() {
        return this.name;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Project getProject() {
        return this.project;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public String getToolTip() {
        if (this.runProcessStarted && this.runProcessAlive == null) {
            return RunMgrArb.format(9, this.tooltip);
        }
        return this.tooltip;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public HelpInfo getHelpInfo() {
        if (this.helpInfo != null) {
            return this.helpInfo;
        }
        return super.getHelpInfo();
    }

    public boolean isProcessAlive() {
        return this.runProcessAlive != null;
    }

    public RunProcess getRunProcess() {
        return this.runProcessAlive;
    }

    public void log(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            this.needNewLine = string.length() > 0 && !string.endsWith("\n");
        } else if (object instanceof StringBuffer) {
            String string = object.toString();
            this.needNewLine = string.length() > 0 && !string.endsWith("\n");
        }
        super.log(object, true);
    }

    public void logWithoutShow(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            this.needNewLine = string.endsWith("\n") ^ true;
        }
        super.logMsg(object);
    }

    protected void appendToTextComponent(String string, int n) {
        super.appendToTextComponent(string, n);
        this.lookForStackFrames(string.length());
    }

    protected void deleteFromStartOfTextComponent(int n, int n2) {
        this.removeStackFrames(n2);
        super.deleteFromStartOfTextComponent(n, n2);
    }

    protected void clearTextComponent() {
        super.clearTextComponent();
        this.clearStackFrames();
    }

    private void lookForStackFrames(int n) {
        block9: {
            Debugger debugger = Debugger.getDebugger();
            if (debugger != null) {
                try {
                    if (n <= 0) break block9;
                    String string = this.getText();
                    int n2 = string.length();
                    int n3 = this.getBeginningOfLine(string, n2 - n);
                    while (n3 < n2) {
                        int n4 = string.indexOf(10, n3);
                        if (n4 == -1) {
                            n4 = n2;
                        }
                        try {
                            String string2 = string.substring(n3, n4);
                            if (string2.length() > 0 && debugger.isStackTraceLine(string2)) {
                                String string3 = string2;
                                int n5 = this.skipWhitespace(string, n2, n3);
                                if (string.startsWith("at ", n5)) {
                                    n5 += 3;
                                }
                                int n6 = string.indexOf(40, n5) - n5;
                                String string4 = string.substring(n5, n4);
                                StackFrame stackFrame = new StackFrame(string4, string3, n5, n6, string);
                                this.stackFrames.add(stackFrame);
                                super.addHref(stackFrame._href);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        n3 = n4 + 1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void removeStackFrames(int n) {
        int n2 = this.stackFrames.size() - 1;
        while (n2 >= 0) {
            StackFrame stackFrame = (StackFrame)this.stackFrames.get(n2);
            if (stackFrame._href.getStartOffset() < n) {
                this.stackFrames.remove(n2);
            }
            --n2;
        }
    }

    private void clearStackFrames() {
        this.stackFrames.clear();
    }

    private int getBeginningOfLine(String string, int n) {
        int n2;
        if (n > 0) {
            --n;
        }
        n2 = (n2 = string.lastIndexOf(10, n)) == -1 ? 0 : ++n2;
        return n2;
    }

    private int skipWhitespace(String string, int n, int n2) {
        while (n2 < n && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }

    private boolean canTerminate() {
        RunProcess runProcess = this.getRunProcess();
        return runProcess != null && runProcess.canTerminate();
    }

    private void terminate() {
        RunProcess runProcess = this.getRunProcess();
        if (runProcess != null && runProcess.canTerminate()) {
            runProcess.terminate();
        }
    }

    private boolean canShowStackTracesDialog() {
        return this.stackFrames.isEmpty() ^ true;
    }

    private void showStackTracesDialog() {
        StackFrame stackFrame;
        StackTracesPanel stackTracesPanel = new StackTracesPanel(this.stackFrames);
        String string = RunMgrArb.getString(14);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog(stackTracesPanel, StackTracesPanel.mav$getFirstComponent(stackTracesPanel), string);
        StackTracesPanel.mav$setJEWTDialog(stackTracesPanel, jEWTDialog);
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonText(RunMgrArb.getString(15));
        jEWTDialog.setOKButtonEnabled(StackTracesPanel.mav$canOk(stackTracesPanel));
        HelpSystem.getHelpSystem().registerTopic(stackTracesPanel, "f1_deb_stacktracesdlg_html");
        if (WizardLauncher.runDialog((JDialog)jEWTDialog) && (stackFrame = StackTracesPanel.mav$getSelectedStackFrame(stackTracesPanel)) != null) {
            stackFrame.showStackFrameSourceCode();
        }
    }

    public void showPage() {
        this.requestShow();
    }

    public void setNorthComponent(Component component) {
        if (component != null) {
            this.northPanel.add(component, "Center");
            this.northPanel.setVisible(true);
        } else {
            this.northPanel.removeAll();
            this.northPanel.setVisible(false);
        }
        this.northComponent = component;
    }

    void logMessageFromRunner(Object object) {
        if (object instanceof String && this.needNewLine) {
            object = "\n" + object;
        }
        this.logWithoutShow(object);
    }

    void allowInput(RunProcess runProcess, OutputStream outputStream) {
        runProcess.doUI(new 1(this, outputStream));
    }

    void started(RunProcess runProcess) {
        this.runProcessStarted = true;
        this.runProcessAlive = runProcess;
        this.updateToolTipText();
    }

    void finished(RunProcess runProcess) {
        if (this.runProcessAlive == runProcess) {
            this.runProcessAlive = null;
            this.updateToolTipText();
        }
    }

    static int ra$TERMINATE_CMD_ID() {
        return TERMINATE_CMD_ID;
    }

    static boolean mav$canTerminate(RunLogPage runLogPage) {
        return runLogPage.canTerminate();
    }

    static int ra$STACK_TRACES_CMD_ID() {
        return STACK_TRACES_CMD_ID;
    }

    static boolean mav$canShowStackTracesDialog(RunLogPage runLogPage) {
        return runLogPage.canShowStackTracesDialog();
    }

    static void mav$terminate(RunLogPage runLogPage) {
        runLogPage.terminate();
    }

    static void mav$showStackTracesDialog(RunLogPage runLogPage) {
        runLogPage.showStackTracesDialog();
    }

    static JTextField ra$textField(RunLogPage runLogPage) {
        return runLogPage.textField;
    }

    static OutputStreamWriter ra$writer(RunLogPage runLogPage) {
        return runLogPage.writer;
    }

    static SimpleAttributeSet maS$getSystemInAttributeSet() {
        return RunLogPage.getSystemInAttributeSet();
    }

    static Workspace ra$workspace(RunLogPage runLogPage) {
        return runLogPage.workspace;
    }

    static Project ra$project(RunLogPage runLogPage) {
        return runLogPage.project;
    }

    static int mav$getBeginningOfLine(RunLogPage runLogPage, String string, int n) {
        return runLogPage.getBeginningOfLine(string, n);
    }

    static void wa$writer(RunLogPage runLogPage, OutputStreamWriter outputStreamWriter) {
        runLogPage.writer = outputStreamWriter;
    }

    static JPanel ra$southPanel(RunLogPage runLogPage) {
        return runLogPage.southPanel;
    }

    public static final class 4
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == RunLogPage.ra$TERMINATE_CMD_ID()) {
                RunLogPage runLogPage = (RunLogPage)ideAction.getValue("UserData");
                if (runLogPage != null) {
                    RunLogPage.mav$terminate(runLogPage);
                }
                ideAction.putValue("UserData", null);
                return true;
            }
            if (n == RunLogPage.ra$STACK_TRACES_CMD_ID()) {
                RunLogPage runLogPage = (RunLogPage)ideAction.getValue("UserData");
                if (runLogPage != null) {
                    RunLogPage.mav$showStackTracesDialog(runLogPage);
                }
                ideAction.putValue("UserData", null);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == RunLogPage.ra$TERMINATE_CMD_ID()) {
                RunLogPage runLogPage = (RunLogPage)ideAction.getValue("UserData");
                if (runLogPage != null) {
                    ideAction.setEnabled(RunLogPage.mav$canTerminate(runLogPage));
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == RunLogPage.ra$STACK_TRACES_CMD_ID()) {
                RunLogPage runLogPage = (RunLogPage)ideAction.getValue("UserData");
                if (runLogPage != null) {
                    ideAction.setEnabled(RunLogPage.mav$canShowStackTracesDialog(runLogPage));
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            return false;
        }
    }

    public static final class 3
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            View view;
            Context context;
            if (contextMenu != null && (context = contextMenu.getContext()) != null && (view = context.getView()) instanceof RunLogPage) {
                RunLogPage runLogPage = (RunLogPage)view;
                IdeAction ideAction = IdeAction.find(RunLogPage.ra$TERMINATE_CMD_ID());
                ideAction.putValue("UserData", runLogPage);
                ideAction.updateAction(context);
                JMenuItem jMenuItem = contextMenu.createMenuItem(ideAction);
                contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
                IdeAction ideAction2 = IdeAction.find(RunLogPage.ra$STACK_TRACES_CMD_ID());
                ideAction2.putValue("UserData", runLogPage);
                ideAction2.updateAction(context);
                JMenuItem jMenuItem2 = contextMenu.createMenuItem(ideAction2);
                contextMenu.add((Component)jMenuItem2, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (RunLogPage.ra$textField(RunLogPage.this) != null && RunLogPage.ra$writer(RunLogPage.this) != null) {
                String string = RunLogPage.ra$textField(RunLogPage.this).getText() + "\n";
                RunLogPage.ra$textField(RunLogPage.this).setText("");
                try {
                    StyledMessage styledMessage = new StyledMessage(RunLogPage.maS$getSystemInAttributeSet(), string);
                    RunLogPage.this.log(styledMessage);
                    RunLogPage.ra$writer(RunLogPage.this).write(string);
                    RunLogPage.ra$writer(RunLogPage.this).flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class StackFrame {
        String _stackTraceLine;
        Href _href;
        String _text;
        String _exception;
        int _exceptionID;

        StackFrame(String string, String string2, int n, int n2, String string3) {
            block8: {
                this._stackTraceLine = string2;
                String string4 = new String(string.substring(0, n2));
                this._href = new 1(string4, null);
                this._href.setStartOffset(n);
                this._text = string;
                try {
                    int n3 = RunLogPage.mav$getBeginningOfLine(RunLogPage.this, string3, n);
                    while (n3 > 0 && string3.startsWith("\tat ", n3)) {
                        n3 = RunLogPage.mav$getBeginningOfLine(RunLogPage.this, string3, n3 - 1);
                    }
                    int n4 = string3.indexOf(10, n3);
                    if (n4 == -1) {
                        n4 = string3.length();
                    }
                    this._exception = string3.substring(n3, n4);
                    this._exceptionID = n3;
                    if (!this._exception.trim().equals("]")) break block8;
                    while (n3 > 0) {
                        if (string3.startsWith("[SOAPException", n3 = RunLogPage.mav$getBeginningOfLine(RunLogPage.this, string3, n3 - 1))) {
                            this._exception = string3.substring(n3, n4);
                        } else if (!string3.startsWith("\tat ", n3)) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this._text;
        }

        public void showStackFrameSourceCode() {
            Debugger.getDebugger().showSourceFileForStackTraceLine(RunLogPage.ra$workspace(RunLogPage.this), RunLogPage.ra$project(RunLogPage.this), this._stackTraceLine);
        }

        public final class 1
        extends Href {
            public void go() {
                StackFrame.this.showStackFrameSourceCode();
            }

            public 1(String string, URL uRL) {
                super(string, uRL);
            }
        }
    }

    private static final class StackTracesPanel
    extends JPanel
    implements TreeSelectionListener {
        private JEWTDialog dlg;
        private JTree tree;

        StackTracesPanel(List list) {
            super(new GridBagLayout());
            TreeModel treeModel = this.buildTree(list);
            this.tree = new JTree(treeModel);
            JScrollPane jScrollPane = new JScrollPane(this.tree);
            this.tree.setScrollsOnExpand(false);
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setCellRenderer(new 2());
            this.tree.addTreeSelectionListener(this);
            this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            int n = treeModel.getChildCount(treeModel.getRoot()) - 1;
            this.tree.expandRow(n);
            int n2 = n + 1;
            this.tree.setSelectionRow(n2);
            this.tree.addComponentListener(new 1(this, n, n2));
        }

        private TreeModel buildTree(List list) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            int n = -1;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                StackFrame stackFrame = (StackFrame)list.get(n3);
                if (stackFrame._exceptionID != n) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(stackFrame._exception);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(stackFrame));
                    n = stackFrame._exceptionID;
                } else {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(stackFrame));
                }
                ++n3;
            }
            return new DefaultTreeModel(defaultMutableTreeNode);
        }

        private void setJEWTDialog(JEWTDialog jEWTDialog) {
            this.dlg = jEWTDialog;
        }

        private boolean canOk() {
            return this.getSelectedStackFrame() != null;
        }

        private StackFrame getSelectedStackFrame() {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object;
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof StackFrame) {
                return (StackFrame)object;
            }
            return null;
        }

        private Component getFirstComponent() {
            return this.tree;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        static Component mav$getFirstComponent(StackTracesPanel stackTracesPanel) {
            return stackTracesPanel.getFirstComponent();
        }

        static void mav$setJEWTDialog(StackTracesPanel stackTracesPanel, JEWTDialog jEWTDialog) {
            stackTracesPanel.setJEWTDialog(jEWTDialog);
        }

        static boolean mav$canOk(StackTracesPanel stackTracesPanel) {
            return stackTracesPanel.canOk();
        }

        static StackFrame mav$getSelectedStackFrame(StackTracesPanel stackTracesPanel) {
            return stackTracesPanel.getSelectedStackFrame();
        }

        static JTree ra$tree(StackTracesPanel stackTracesPanel) {
            return stackTracesPanel.tree;
        }

        public final class 2
        extends DefaultTreeCellRenderer {
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                this.setIcon(null);
                return this;
            }
        }

        public final class 1
        extends ComponentAdapter {
            boolean done;
            private final /* synthetic */ int v$lastExceptionRow;
            private final /* synthetic */ int v$topFrameRow;
            final /* synthetic */ StackTracesPanel this$0;

            void $init$() {
                this.done = false;
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (!this.done) {
                    this.done = true;
                    StackTracesPanel.ra$tree(this.this$0).scrollRowToVisible(0);
                    StackTracesPanel.ra$tree(this.this$0).scrollRowToVisible(this.v$lastExceptionRow);
                    StackTracesPanel.ra$tree(this.this$0).scrollRowToVisible(this.v$topFrameRow);
                    StackTracesPanel.ra$tree(this.this$0).removeComponentListener(this);
                }
            }

            public 1(StackTracesPanel stackTracesPanel, int n, int n2) {
                this.v$topFrameRow = n2;
                this.v$lastExceptionRow = n;
                this.this$0 = stackTracesPanel;
                this.$init$();
            }
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ OutputStream v$stdin;
        final /* synthetic */ RunLogPage this$0;

        public void run() {
            if (this.v$stdin != null) {
                RunLogPage.wa$writer(this.this$0, new OutputStreamWriter(this.v$stdin));
                RunLogPage.ra$southPanel(this.this$0).setVisible(true);
            } else {
                RunLogPage.wa$writer(this.this$0, null);
                RunLogPage.ra$southPanel(this.this$0).setVisible(false);
            }
        }

        public 1(RunLogPage runLogPage, OutputStream outputStream) {
            this.v$stdin = outputStream;
            this.this$0 = runLogPage;
        }
    }
}

