/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.layout.IdeLayout;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.MiscellaneousFolder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.LogOutputThread;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.RunnableItem;
import oracle.ide.runner.Runner;
import oracle.ide.runner.Starter;
import oracle.ide.runner.StarterCookieList;
import oracle.ide.runner.StarterFactory;
import oracle.ide.runner.StarterFactoryChoiceDialog;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;

public abstract class RunProcess
implements Helpable,
Element {
    protected long timeCreated;
    protected Context context;
    protected boolean logStartDirectory;
    protected boolean logCommandString;
    protected boolean logOutput;
    private List duplicateOutput;
    protected boolean allowInput;
    protected boolean logError;
    private List duplicateError;
    protected boolean logExit;
    protected boolean showStartStatus;
    protected boolean addToProcessesFolder;
    protected boolean addToTerminateMenu;
    protected boolean useLogPage;
    protected LogPage logPageOverride;
    protected RunProcessListener runProcessListener;
    protected boolean userCanceled;
    protected List errors;
    protected boolean determineTargetAndStarterAlready;
    protected String labelOverride;
    protected Node target;
    protected Starter starter;
    private LogOutputThread logSystemOutThread;
    private LogOutputThread logSystemErrThread;
    private boolean processNodeAdded;
    private boolean terminateMenuAdded;
    private boolean finished;
    private Attributes attributes;
    private static int systemOutColor;
    private static SimpleAttributeSet systemOutAttributeSet;
    private static int systemErrColor;
    private static SimpleAttributeSet systemErrAttributeSet;
    private LogPage logPage;

    void $init$() {
        this.determineTargetAndStarterAlready = false;
        this.attributes = new ElementAttributes(ElementAttributes.NONE);
    }

    public RunProcess(Context context) {
        this.$init$();
        this.timeCreated = System.currentTimeMillis();
        this.context = context;
        this.logStartDirectory = true;
        this.logCommandString = true;
        this.logOutput = true;
        this.allowInput = false;
        this.logError = true;
        this.logExit = false;
        this.showStartStatus = true;
        this.addToProcessesFolder = true;
        this.addToTerminateMenu = true;
        this.useLogPage = true;
        this.logPageOverride = null;
        this.errors = new ArrayList();
    }

    protected Object copyTo(Object object) {
        if (object == null) {
            throw new IllegalStateException();
        }
        RunProcess runProcess = (RunProcess)object;
        runProcess.context = this.context;
        runProcess.useLogPage = this.useLogPage;
        runProcess.logPageOverride = this.logPageOverride;
        runProcess.allowInput = this.allowInput;
        runProcess.logStartDirectory = this.logStartDirectory;
        runProcess.logCommandString = this.logCommandString;
        runProcess.showStartStatus = this.showStartStatus;
        runProcess.addToProcessesFolder = this.addToProcessesFolder;
        runProcess.addToTerminateMenu = this.addToTerminateMenu;
        runProcess.runProcessListener = this.runProcessListener;
        return runProcess;
    }

    public final void setLogOutput(boolean bl) {
        this.logOutput = bl;
    }

    public final void setLogError(boolean bl) {
        this.logError = bl;
    }

    public PipedInputStream duplicateOutputStream() {
        PipedInputStream pipedInputStream = new PipedInputStream();
        if (this.duplicateOutput == null) {
            this.duplicateOutput = new ArrayList();
        }
        this.duplicateOutput.add(pipedInputStream);
        return pipedInputStream;
    }

    public PipedInputStream duplicateErrorStream() {
        PipedInputStream pipedInputStream = new PipedInputStream();
        if (this.duplicateError == null) {
            this.duplicateError = new ArrayList();
        }
        this.duplicateError.add(pipedInputStream);
        return pipedInputStream;
    }

    protected Class getStarterFactorySubClass() {
        return StarterFactory.class;
    }

    protected void determineTargetAndStarter() {
        if (this.determineTargetAndStarterAlready || this.target != null) {
            return;
        }
        this.determineTargetAndStarter(this.getStarterFactorySubClass());
        this.determineTargetAndStarterAlready = true;
    }

    public static Node getContextNodeForRun(Context context) {
        int n;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && (n = elementArray.length) > 0 && elementArray[0] instanceof Node) {
            if (n == 1) {
                return (Node)elementArray[0];
            }
            Node node = null;
            Runner runner = Runner.getRunner();
            int n2 = 0;
            while (n2 < n) {
                Element element = elementArray[n2];
                if (element instanceof Node && runner.couldNodeBeRunnable((Node)element)) {
                    if (node == null) {
                        node = (Node)element;
                    } else {
                        return null;
                    }
                }
                ++n2;
            }
            return node;
        }
        return context.getNode();
    }

    protected void determineTargetAndStarter(Class clazz) {
        boolean bl = true;
        Node node = RunProcess.getContextNodeForRun(this.context);
        if (!(!(node instanceof Node) || node instanceof IdeSystem || node instanceof Workspace || node instanceof Project || node instanceof MiscellaneousFolder)) {
            Node node2 = node;
            if (Runner.getRunner().couldNodeBeRunnable(node2, clazz)) {
                int n = this.errors.size();
                Starter starter = this.getStarterForTarget(node2, clazz);
                if (starter != null) {
                    this.target = node2;
                    this.starter = starter;
                    return;
                }
                boolean bl2 = bl = this.errors.size() == n;
            }
            if (bl) {
                String string = RunMgrArb.format(1, node.getShortLabel());
                this.errors.add(string);
            }
        } else if (bl && this.context.getProject() == null) {
            String string = RunMgrArb.getString(0);
            this.errors.add(string);
        }
    }

    protected Starter getStarterForTarget(Node node, Class clazz) {
        if (this.userCanceled) {
            return null;
        }
        if (node != null) {
            URL uRL = node.getURL();
            if (!uRL.getProtocol().equalsIgnoreCase("file") || URLFileSystem.exists(uRL)) {
                Class<?> clazz2 = node.getClass();
                AbstractStarterFactory[] abstractStarterFactoryArray = Runner.getRunner().getStarterFactoriesForTarget(clazz2, clazz);
                int n = abstractStarterFactoryArray.length;
                ArrayList<AbstractStarterFactory> arrayList = new ArrayList<AbstractStarterFactory>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                int n2 = 0;
                while (n2 < n) {
                    AbstractStarterFactory abstractStarterFactory = abstractStarterFactoryArray[n2];
                    Object object = abstractStarterFactory.canStart(this, this.context, node, this.errors);
                    if (object != null) {
                        if (object instanceof StarterCookieList) {
                            StarterCookieList starterCookieList = (StarterCookieList)object;
                            int n3 = starterCookieList.size();
                            int n4 = 0;
                            while (n4 < n3) {
                                Object e = starterCookieList.get(n4);
                                arrayList.add(abstractStarterFactory);
                                arrayList2.add(e);
                                ++n4;
                            }
                        } else {
                            arrayList.add(abstractStarterFactory);
                            arrayList2.add(object);
                        }
                    }
                    ++n2;
                }
                if (!arrayList.isEmpty()) {
                    Object e;
                    AbstractStarterFactory abstractStarterFactory;
                    Starter starter;
                    int n5 = 0;
                    int n6 = arrayList.size();
                    if (n6 > 1) {
                        Displayable[] displayableArray = new Displayable[n6];
                        int n7 = 0;
                        while (n7 < n6) {
                            AbstractStarterFactory abstractStarterFactory2 = (AbstractStarterFactory)arrayList.get(n7);
                            Object e2 = arrayList2.get(n7);
                            displayableArray[n7] = abstractStarterFactory2.getDisplayable(this, this.context, node, e2);
                            ++n7;
                        }
                        n5 = StarterFactoryChoiceDialog.showStarterFactoryChoiceDialog(node, displayableArray);
                        if (n5 == -1) {
                            this.userCanceled = true;
                            return null;
                        }
                    }
                    if (this.checkStarter(starter = (abstractStarterFactory = (AbstractStarterFactory)arrayList.get(n5)).createStarter(this, this.context, node, e = arrayList2.get(n5)), this.errors)) {
                        return starter;
                    }
                }
            } else {
                String string = RunMgrArb.format(4, node.getShortLabel());
                this.errors.add(string);
            }
        }
        return null;
    }

    public RunnableItem[] getRunnableItems() {
        Class clazz = this.getStarterFactorySubClass();
        Node node = RunProcess.getContextNodeForRun(this.context);
        if (!(!(node instanceof Node) || node instanceof IdeSystem || node instanceof Workspace || node instanceof Project || node instanceof MiscellaneousFolder)) {
            Node node2 = node;
            if (Runner.getRunner().couldNodeBeRunnable(node2, clazz)) {
                int n = this.errors.size();
                return this.getRunnableItemsForTarget(node2, clazz);
            }
        }
        return null;
    }

    protected RunnableItem[] getRunnableItemsForTarget(Node node, Class clazz) {
        URL uRL;
        if (node != null && (!(uRL = node.getURL()).getProtocol().equalsIgnoreCase("file") || URLFileSystem.exists(uRL))) {
            Class<?> clazz2 = node.getClass();
            AbstractStarterFactory[] abstractStarterFactoryArray = Runner.getRunner().getStarterFactoriesForTarget(clazz2, clazz);
            int n = abstractStarterFactoryArray.length;
            ArrayList<AbstractStarterFactory> arrayList = new ArrayList<AbstractStarterFactory>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n2 = 0;
            while (n2 < n) {
                AbstractStarterFactory abstractStarterFactory = abstractStarterFactoryArray[n2];
                Object object = abstractStarterFactory.canStart(this, this.context, node, this.errors);
                if (object != null) {
                    if (object instanceof StarterCookieList) {
                        StarterCookieList starterCookieList = (StarterCookieList)object;
                        int n3 = starterCookieList.size();
                        int n4 = 0;
                        while (n4 < n3) {
                            Object e = starterCookieList.get(n4);
                            arrayList.add(abstractStarterFactory);
                            arrayList2.add(e);
                            ++n4;
                        }
                    } else {
                        arrayList.add(abstractStarterFactory);
                        arrayList2.add(object);
                    }
                }
                ++n2;
            }
            if (!arrayList.isEmpty()) {
                int n5 = arrayList.size();
                RunnableItem[] runnableItemArray = new RunnableItem[n5];
                int n6 = 0;
                while (n6 < n5) {
                    AbstractStarterFactory abstractStarterFactory = (AbstractStarterFactory)arrayList.get(n6);
                    Object e = arrayList2.get(n6);
                    runnableItemArray[n6] = new RunnableItem(this, this.context, node, abstractStarterFactory, e);
                    ++n6;
                }
                return runnableItemArray;
            }
        }
        return null;
    }

    public String canGetStarterForTarget(Node node, Class clazz, List list) {
        if (node != null) {
            Class<?> clazz2 = node.getClass();
            int n = list.size();
            AbstractStarterFactory[] abstractStarterFactoryArray = Runner.getRunner().getStarterFactoriesForTarget(clazz2, clazz);
            int n2 = abstractStarterFactoryArray.length;
            int n3 = 0;
            while (n3 < n2) {
                AbstractStarterFactory abstractStarterFactory = abstractStarterFactoryArray[n3];
                Object object = abstractStarterFactory.canStart(this, this.context, node, list);
                if (object != null) {
                    return abstractStarterFactory.getName();
                }
                ++n3;
            }
            if (list.size() == n) {
                String string = RunMgrArb.format(1, node.getShortLabel());
                list.add(string);
            }
        }
        return null;
    }

    protected boolean checkStarter(Starter starter, List list) {
        return starter.canStart(list);
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public Context getContext() {
        return this.context;
    }

    public Workspace getWorkspace() {
        return this.context.getWorkspace();
    }

    public Project getProject() {
        return RunProcess.getProject(this.context);
    }

    public static Project getProject(Context context) {
        Project project = context.getProject();
        if (project == null) {
            project = Ide.getDefaultProject();
        }
        return project;
    }

    public boolean canRun(String string, Object object, Node node, List list) {
        return false;
    }

    public Object getValue(String string, Object object, String string2) {
        return null;
    }

    public final Node getTarget() {
        return this.getTarget(true);
    }

    public final Node getTarget(boolean bl) {
        if (bl) {
            this.determineTargetAndStarter();
        }
        return this.target;
    }

    public final Starter getStarter() {
        return this.getStarter(true);
    }

    public final Starter getStarter(boolean bl) {
        if (bl) {
            this.determineTargetAndStarter();
        }
        return this.starter;
    }

    public boolean canStart() {
        this.determineTargetAndStarter();
        return this.starter != null;
    }

    public void start(Node node, AbstractStarterFactory abstractStarterFactory, Object object) {
        this.determineTargetAndStarterAlready = true;
        this.target = node;
        this.starter = abstractStarterFactory.createStarter(this, this.context, node, object);
        if (this.checkStarter(this.starter, this.errors)) {
            this.start();
        } else {
            this.logStartErrors();
        }
    }

    public void start() {
        this.determineTargetAndStarter();
        if (this.mustPrepareToStart()) {
            2 var1_1 = new 2();
            var1_1.start();
        } else {
            this.startTarget();
        }
    }

    protected boolean mustPrepareToStart() {
        this.determineTargetAndStarter();
        if (this.starter != null) {
            return this.starter.mustPrepareToStart();
        }
        return false;
    }

    protected boolean prepareToStart() {
        this.determineTargetAndStarter();
        if (this.starter != null) {
            return this.starter.prepareToStart();
        }
        return true;
    }

    protected boolean startTarget() {
        this.determineTargetAndStarter();
        if (this.starter != null) {
            this.errors.clear();
            if (this.starter.start()) {
                this.started();
                return true;
            }
        }
        if (this.userCanceled) {
            this.errors.clear();
        } else {
            this.logStartErrors();
        }
        this.notifyRunProcessListener(Integer.MIN_VALUE);
        return false;
    }

    protected void logStartErrors() {
        LogPage logPage;
        if (!this.errors.isEmpty() && (logPage = this.getLogPage()) != null) {
            for (String string : this.errors) {
                logPage.log(string + "\n");
            }
            this.errors.clear();
        }
    }

    public void started() {
        if (this.addToProcessesFolder || this.addToTerminateMenu || this.getUseLogPage() && (this.logPageOverride == null || this.logPageOverride instanceof RunLogPage)) {
            this.doUI(new 1());
        }
    }

    public void redirectOutput(InputStream inputStream, InputStream inputStream2) {
        LogPage logPage = this.getLogPage();
        String string = this.getShortLabel();
        String string2 = string + " System.out";
        this.logSystemOutThread = new LogOutputThread(string2, this, this.logOutput ? logPage : null, RunProcess.getSystemOutAttributeSet(), inputStream, this.duplicateOutput);
        this.logSystemOutThread.start();
        string2 = string + " System.err";
        this.logSystemErrThread = new LogOutputThread(string2, this, this.logError ? logPage : null, RunProcess.getSystemErrAttributeSet(), inputStream2, this.duplicateError);
        this.logSystemErrThread.start();
    }

    public static synchronized SimpleAttributeSet getSystemOutAttributeSet() {
        if (systemOutAttributeSet == null) {
            systemOutAttributeSet = new SimpleAttributeSet();
        }
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        if (systemOutColor == 0 || systemOutColor != environOptions.getLogSystemOutColor()) {
            systemOutColor = environOptions.getLogSystemOutColor();
            StyleConstants.setForeground(systemOutAttributeSet, new Color(systemOutColor));
        }
        return systemOutAttributeSet;
    }

    public static synchronized SimpleAttributeSet getSystemErrAttributeSet() {
        if (systemErrAttributeSet == null) {
            systemErrAttributeSet = new SimpleAttributeSet();
        }
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        if (systemErrColor == 0 || systemErrColor != environOptions.getLogSystemErrColor()) {
            systemErrColor = environOptions.getLogSystemErrColor();
            StyleConstants.setForeground(systemErrAttributeSet, new Color(systemErrColor));
        }
        return systemErrAttributeSet;
    }

    public void redirectInput(OutputStream outputStream) {
        LogPage logPage;
        if (this.allowInput && (logPage = this.getLogPage()) != null && logPage instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)logPage;
            runLogPage.allowInput(this, outputStream);
        }
    }

    public void waitForRedirectOutput() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (this.logSystemOutThread != null) {
            LogOutputThread.waitForOutput(this.logSystemOutThread);
        }
        if (this.logSystemErrThread != null) {
            LogOutputThread.waitForOutput(this.logSystemErrThread);
        }
    }

    void finishRedirectOutput() {
        this.waitForRedirectOutput();
        if (this.logSystemOutThread != null) {
            try {
                this.logSystemOutThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.logSystemErrThread != null) {
            try {
                this.logSystemErrThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String[] getStartEnvironmentParams() {
        return null;
    }

    public File getStartDirectory() {
        return null;
    }

    public void logStartDirectory() {
        LogPage logPage;
        File file;
        if (this.logStartDirectory && (file = this.starter.getStartDirectory()) != null && (logPage = this.getLogPage()) != null) {
            logPage.log(file + ">\n");
        }
    }

    public String[] getStartCommand() {
        return null;
    }

    public void logCommandString(String[] stringArray) {
        LogPage logPage = this.getLogPage();
        if (logPage != null) {
            if (this.logCommandString) {
                String string = this.fixCommandStringForLog(stringArray);
                logPage.log(string + "\n");
            } else {
                logPage.log("");
            }
        }
    }

    protected String fixCommandStringForLog(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            if (!(!stringArray[n].equals("") && stringArray[n].indexOf(32) < 0 && stringArray[n].indexOf(9) < 0 || stringArray[n].startsWith("\"") && stringArray[n].endsWith("\""))) {
                stringBuffer.append('\"');
                stringBuffer.append(stringArray[n]);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(stringArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean showStartStatus() {
        return this.showStartStatus;
    }

    protected boolean getUseLogPage() {
        return this.useLogPage;
    }

    public LogPage getLogPage() {
        return this.getLogPage(true);
    }

    public LogPage getLogPage(boolean bl) {
        if (!this.getUseLogPage()) {
            return null;
        }
        if (this.logPage == null) {
            this.logPage = this.makeLogPage(bl);
        }
        return this.logPage;
    }

    protected LogPage makeLogPage(boolean bl) {
        if (this.logPageOverride != null) {
            return this.logPageOverride;
        }
        return RunLogPage.makePage(this, bl);
    }

    protected boolean reuseLogPage(RunLogPage runLogPage) {
        Boolean bl;
        if (!this.getUseLogPage()) {
            return false;
        }
        if (this.starter != null && (bl = this.starter.reuseLogPage(runLogPage)) != null) {
            return bl;
        }
        return !runLogPage.isProcessAlive() && ModelUtil.areEqual((Object)this.getShortLabel(), (Object)runLogPage.getName()) && this.getWorkspace() == runLogPage.getWorkspace() && this.getProject() == runLogPage.getProject() && this.getIcon() == runLogPage.getTabIcon() && ModelUtil.areEqual((Object)this.getToolTipText(), (Object)runLogPage.getToolTipText()) && ModelUtil.areEqual((Object)this.getShortLabelWithPrefix(), (Object)runLogPage.getTitleName()) && (this.getHelpInfo() == null || ModelUtil.areEqual((Object)this.getHelpInfo(), (Object)runLogPage.getHelpInfo()));
    }

    public void log(Object object) {
        LogPage logPage = this.getLogPage();
        if (logPage == null) {
            return;
        }
        if (logPage instanceof RunLogPage) {
            ((RunLogPage)logPage).logMessageFromRunner(object);
        } else {
            logPage.log(object);
        }
    }

    public boolean doUILater() {
        return false;
    }

    protected void doUI(Runnable runnable) {
        if (this.doUILater()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            IdeUtil.runNow(runnable);
        }
    }

    public boolean suppressDirectoryDefault() {
        return false;
    }

    public abstract String getProcessLabelPrefix();

    public IdeLayout getProcessLayout() {
        return null;
    }

    public void selected() {
    }

    public void doubleClicked() {
    }

    public void unselected() {
    }

    public boolean canTerminate() {
        if (this.starter != null) {
            if (this.starter.canTerminateGracefully()) {
                return true;
            }
            return this.starter.canTerminate();
        }
        return false;
    }

    public void terminate() {
        if (this.starter != null) {
            if (this.starter.canTerminateGracefully()) {
                this.starter.terminateGracefully();
            } else if (this.starter.canTerminate()) {
                this.starter.terminate();
            }
        }
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public synchronized void finished() {
        if (!this.finished) {
            this.finished = true;
            if (this.processNodeAdded) {
                Runner.getRunner().getProcessesFolder().remove(this);
            }
            if (this.terminateMenuAdded) {
                Runner.getRunner().removeTerminateMenu(this);
            }
            this.redirectInput(null);
            LogPage logPage = this.getLogPage();
            if (logPage != null && logPage instanceof RunLogPage) {
                RunLogPage runLogPage = (RunLogPage)logPage;
                runLogPage.finished(this);
            }
            if (this.starter != null) {
                Integer n = this.starter.getExitCode();
                if (this.logExit) {
                    if (n != null) {
                        this.log(RunMgrArb.format(6, n.toString()));
                    } else {
                        this.log(RunMgrArb.getString(7));
                    }
                }
                int n2 = n != null ? n : -1;
                this.notifyRunProcessListener(n2);
            }
        }
    }

    private void notifyRunProcessListener(int n) {
        if (this.runProcessListener != null) {
            this.runProcessListener.processFinished(n);
        }
    }

    private String prepareLabel(boolean bl, boolean bl2) {
        this.determineTargetAndStarter();
        String string = bl || this.getIcon() == null ? this.getProcessLabelPrefix() : "";
        if (this.labelOverride != null) {
            string = string + this.labelOverride;
        } else {
            Project project = this.getProject();
            if (project != null && project != Ide.getDefaultProject()) {
                string = string + (bl2 ? project.getLongLabel() : project.getShortLabel());
            } else {
                if ((string = string.trim()).endsWith(":") || string.endsWith("-")) {
                    string = string.substring(0, string.length() - 1);
                }
                string = string.trim();
            }
        }
        return string;
    }

    public void setLabelOverride(String string) {
        this.labelOverride = string;
    }

    public String getShortLabelWithPrefix() {
        return this.prepareLabel(true, false);
    }

    public String getShortLabel() {
        return this.prepareLabel(false, false);
    }

    public String getLongLabel() {
        return this.prepareLabel(true, true);
    }

    public Object getData() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public HelpInfo getHelpInfo() {
        return null;
    }

    public String toString() {
        return this.getShortLabel();
    }

    static void wa$processNodeAdded(RunProcess runProcess, boolean bl) {
        runProcess.processNodeAdded = bl;
    }

    static void wa$terminateMenuAdded(RunProcess runProcess, boolean bl) {
        runProcess.terminateMenuAdded = bl;
    }

    public final class 2
    extends Thread {
        public void run() {
            if (RunProcess.this.prepareToStart()) {
                SwingUtilities.invokeLater(new 1());
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                RunProcess.this.startTarget();
            }
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            LogPage logPage;
            if (RunProcess.this.addToProcessesFolder) {
                Runner.getRunner().getProcessesFolder().add(RunProcess.this);
                RunProcess.wa$processNodeAdded(RunProcess.this, true);
            }
            if (RunProcess.this.addToTerminateMenu && RunProcess.this.canTerminate()) {
                Runner.getRunner().addTerminateMenu(RunProcess.this);
                RunProcess.wa$terminateMenuAdded(RunProcess.this, true);
            }
            if (RunProcess.this.getUseLogPage() && (logPage = RunProcess.this.getLogPage()) instanceof RunLogPage) {
                RunLogPage runLogPage = (RunLogPage)logPage;
                runLogPage.started(RunProcess.this);
            }
        }
    }
}

