/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;

public class RunnableItem {
    private static String CMD_PREFIX = "RunnableItem";
    private static int countRunnableCommands = 0;
    private RunProcess runProcess;
    private Context context;
    private Node node;
    private AbstractStarterFactory abstractStarterFactory;
    private Object cookie;
    private Displayable displayable;
    private IdeAction action;

    RunnableItem(RunProcess runProcess, Context context, Node node, AbstractStarterFactory abstractStarterFactory, Object object) {
        this.runProcess = runProcess;
        this.context = context;
        this.node = node;
        this.abstractStarterFactory = abstractStarterFactory;
        this.cookie = object;
    }

    public IdeAction getAction() {
        if (this.action == null) {
            int n = Ide.findOrCreateCmdID(CMD_PREFIX + ++countRunnableCommands);
            if (this.displayable == null) {
                this.displayable = this.abstractStarterFactory.getDisplayable(this.runProcess, this.context, this.node, this.cookie);
            }
            String string = this.displayable.getShortLabel();
            Icon icon = this.displayable.getIcon();
            this.action = IdeAction.get(n, null, string, null, null, icon, this, true);
            this.action.putValue("Name", string);
            this.action.putValue("SmallIcon", icon);
            this.action.putValue("UserData", this);
        }
        return this.action;
    }

    public void start() {
        this.runProcess.start(this.node, this.abstractStarterFactory, this.cookie);
    }

    public void clear() {
        this.runProcess = null;
        this.context = null;
        this.node = null;
        this.abstractStarterFactory = null;
        this.cookie = null;
        this.displayable = null;
        if (this.action != null) {
            this.action.putValue("UserData", null);
            this.action = null;
        }
    }

    public static void reset() {
        countRunnableCommands = 0;
    }
}

