/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.ExecUtil;

public class Starter {
    protected RunProcess runProcess;
    protected Process process;
    protected Exception startException;
    private volatile ShutdownHookThread shutdownHookThread;
    private Thread waitForProcess;
    private volatile Integer exitCode;
    private volatile boolean terminated;

    protected Starter(RunProcess runProcess) {
        this.runProcess = runProcess;
    }

    public String[] getStartEnvironmentParams() {
        return this.runProcess.getStartEnvironmentParams();
    }

    public File getStartDirectory() {
        return this.runProcess.getStartDirectory();
    }

    public String[] getStartCommand() {
        return this.runProcess.getStartCommand();
    }

    public Boolean reuseLogPage(RunLogPage runLogPage) {
        return null;
    }

    public boolean canStart(List list) {
        Project project = this.runProcess.getProject();
        if (project == null || project == Ide.getDefaultProject()) {
            String string = RunMgrArb.getString(2);
            list.add(string);
            return false;
        }
        File file = this.getStartDirectory();
        if (!(file == null || file.isDirectory() && file.exists())) {
            String string = RunMgrArb.format(3, file.toString());
            list.add(string);
            return false;
        }
        return true;
    }

    public boolean mustPrepareToStart() {
        return false;
    }

    public boolean prepareToStart() {
        return true;
    }

    private File getStartDirectoryOrProjectDirectory() {
        File file = this.getStartDirectory();
        if (file == null && !this.runProcess.suppressDirectoryDefault()) {
            try {
                URL uRL;
                URL uRL2;
                Project project = this.runProcess.getProject();
                if (project != null && (uRL2 = project.getURL()) != null && uRL2.getProtocol().equals("file") && (uRL = URLFileSystem.getParent(uRL2)) != null) {
                    file = new File(uRL.getPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    public boolean start() {
        this.startException = null;
        String[] stringArray = this.getStartCommand();
        if (stringArray != null && stringArray.length > 0) {
            stringArray = ExecUtil.cleanUpCommand(stringArray);
            this.runProcess.logStartDirectory();
            this.runProcess.logCommandString(stringArray);
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = ExecUtil.adjustArgument(stringArray[n]);
                ++n;
            }
            stringArray = ExecUtil.cleanUpCommand(stringArray);
            if (this.runProcess.showStartStatus()) {
                String string = RunMgrArb.format(5, this.runProcess.getShortLabel());
                Ide.getStatusBar().setText(string);
            }
            Runtime runtime = Runtime.getRuntime();
            try {
                try {
                    this.process = runtime.exec(stringArray, this.getStartEnvironmentParams(), this.getStartDirectoryOrProjectDirectory());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    this.process = runtime.exec(stringArray);
                }
            }
            catch (Exception exception) {
                this.startException = exception;
            }
            if (this.process != null) {
                this.shutdownHookThread = new ShutdownHookThread();
                runtime.addShutdownHook(this.shutdownHookThread);
                this.runProcess.redirectOutput(this.process.getInputStream(), this.process.getErrorStream());
                this.runProcess.redirectInput(this.process.getOutputStream());
                this.waitForProcess = new 1("WaitForProcess");
                this.waitForProcess.start();
            }
        }
        return this.process != null;
    }

    public int waitForProcess() {
        if (this.waitForProcess != null) {
            try {
                this.waitForProcess.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.exitCode != null) {
            return this.exitCode;
        }
        return -1;
    }

    public Integer getExitCode() {
        if (!this.terminated) {
            return this.exitCode;
        }
        return null;
    }

    public Process getProcess() {
        return this.process;
    }

    public Exception getStartException() {
        return this.startException;
    }

    public boolean canTerminateGracefully() {
        return false;
    }

    public void terminateGracefully() {
    }

    public boolean canTerminate() {
        return this.process != null;
    }

    public void terminate() {
        if (this.process != null) {
            this.terminated = true;
            this.process.destroy();
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    this.waitForProcess.join();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void finished() {
    }

    static void wa$exitCode(Starter starter, Integer n) {
        starter.exitCode = n;
    }

    static ShutdownHookThread ra$shutdownHookThread(Starter starter) {
        return starter.shutdownHookThread;
    }

    static void wa$shutdownHookThread(Starter starter, ShutdownHookThread shutdownHookThread) {
        starter.shutdownHookThread = shutdownHookThread;
    }

    static Integer ra$exitCode(Starter starter) {
        return starter.exitCode;
    }

    public final class oracle.ide.runner.Starter$1
    extends Thread {
        public void run() {
            try {
                Starter.wa$exitCode(Starter.this, new Integer(Starter.this.process.waitFor()));
                if (Starter.ra$shutdownHookThread(Starter.this) != null) {
                    ShutdownHookThread.mav$clear(Starter.ra$shutdownHookThread(Starter.this));
                }
                Starter.this.runProcess.finishRedirectOutput();
                SwingUtilities.invokeLater(new 1());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public oracle.ide.runner.Starter$1(String string) {
            super(string);
        }

        public final class 1
        implements Runnable {
            public void run() {
                Starter.this.runProcess.finished();
                Starter.this.finished();
            }
        }
    }

    private class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
            super("RunnerShutdownHook");
        }

        public void run() {
            Process process;
            Starter.wa$shutdownHookThread(Starter.this, null);
            if (Starter.ra$exitCode(Starter.this) == null && (process = Starter.this.process) != null) {
                process.destroy();
            }
        }

        private void clear() {
            try {
                Runtime.getRuntime().removeShutdownHook(Starter.ra$shutdownHookThread(Starter.this));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.start();
        }

        static void mav$clear(ShutdownHookThread shutdownHookThread) {
            shutdownHookThread.clear();
        }
    }
}

