/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.util.ResourceUtils;

final class StarterFactoryChoiceDialog
extends JPanel {
    private JEWTDialog dlg;
    private JList list;
    private Object targetKey;
    private static Map previouslyChosen = new HashMap();

    static int showStarterFactoryChoiceDialog(Node node, Displayable[] displayableArray) {
        StarterFactoryChoiceDialog starterFactoryChoiceDialog = new StarterFactoryChoiceDialog(node, displayableArray);
        String string = RunMgrArb.getString(16);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog(starterFactoryChoiceDialog, starterFactoryChoiceDialog.list, string);
        starterFactoryChoiceDialog.setJEWTDialog(jEWTDialog);
        HelpSystem.getHelpSystem().registerTopic(starterFactoryChoiceDialog, "f1_run_starttarget_html");
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            return starterFactoryChoiceDialog.ok();
        }
        return -1;
    }

    private StarterFactoryChoiceDialog(Node node, Displayable[] displayableArray) {
        super(new GridBagLayout());
        Object v;
        this.targetKey = node.getURL();
        JLabel jLabel = new JLabel();
        String string = RunMgrArb.format(17, node.getShortLabel());
        int n = 50;
        int n2 = string.length() / n + 1;
        JTextArea jTextArea = new JTextArea(string, n2, n);
        jTextArea.setBackground(jLabel.getBackground());
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        this.list = new JList<Displayable>(displayableArray);
        int n3 = displayableArray.length + 1;
        if (this.list.getVisibleRowCount() > n3) {
            this.list.setVisibleRowCount(n3);
        }
        this.list.setSelectionMode(0);
        int n4 = 0;
        if (!previouslyChosen.isEmpty() && (v = previouslyChosen.get(this.targetKey)) != null) {
            int n5 = displayableArray.length;
            int n6 = 0;
            while (n6 < n5) {
                if (v.equals(displayableArray[n6].toString())) {
                    n4 = n6;
                    break;
                }
                ++n6;
            }
        }
        this.list.setSelectedIndex(n4);
        this.list.setCellRenderer(new 3());
        ResourceUtils.resLabel(jLabel, this.list, RunMgrArb.getString(18));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        int n7 = 0;
        this.add((Component)jTextArea, new GridBagConstraints(0, n7++, 0, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)jLabel, new GridBagConstraints(0, n7++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, n7, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.list.addListSelectionListener(new 2());
        this.list.addMouseListener(new 1());
    }

    private void setJEWTDialog(JEWTDialog jEWTDialog) {
        this.dlg = jEWTDialog;
        jEWTDialog.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        return this.list.getSelectedIndex() != -1;
    }

    private int ok() {
        previouslyChosen.put(this.targetKey, this.list.getSelectedValue().toString());
        return this.list.getSelectedIndex();
    }

    static JEWTDialog ra$dlg(StarterFactoryChoiceDialog starterFactoryChoiceDialog) {
        return starterFactoryChoiceDialog.dlg;
    }

    static boolean mav$canOk(StarterFactoryChoiceDialog starterFactoryChoiceDialog) {
        return starterFactoryChoiceDialog.canOk();
    }

    final class 3
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Displayable) {
                Displayable displayable = (Displayable)object;
                this.setIcon(displayable.getIcon());
                this.setToolTipText(displayable.getToolTipText());
            }
            return this;
        }
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            StarterFactoryChoiceDialog.ra$dlg(StarterFactoryChoiceDialog.this).setOKButtonEnabled(StarterFactoryChoiceDialog.mav$canOk(StarterFactoryChoiceDialog.this));
        }
    }

    final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2) {
                StarterFactoryChoiceDialog.ra$dlg(StarterFactoryChoiceDialog.this).hide();
            }
        }
    }
}

