/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import oracle.ide.test.TestCase;
import oracle.ide.test.TestHarnessException;
import oracle.ide.test.TestSession;
import oracle.ide.test.TestUtil;

public final class TestHarness {
    public static String VER = "1.0";
    private String suiteName;
    private String propsName;
    private Properties suite;
    private Properties props;
    private PrintStream log;
    public static final String LOG_PATH = "LOG_PATH";
    public static final String REF_OUTPUT_PATH = "REF_OUTPUT_PATH";
    public static final String REPORT_PATH = "REPORT_PATH";

    void $init$() {
        this.suiteName = null;
        this.propsName = null;
        this.suite = new Properties();
        this.props = new Properties();
        this.log = System.out;
    }

    public TestHarness(String string, String string2) {
        this.$init$();
        this.suiteName = string2;
        this.propsName = string;
        this.load();
    }

    private static void usage() {
        System.out.println("TestHarness.  version " + VER);
        System.out.println("");
        System.out.println("Usage");
        System.out.println("");
        System.out.println("     TestHarness <properties file> <test suite file>");
        System.out.println("");
        System.out.println("");
    }

    public void run() throws TestHarnessException {
        this.createRepDir();
        Enumeration<Object> enumeration = this.suite.keys();
        long l = System.currentTimeMillis();
        while (enumeration.hasMoreElements()) {
            l = System.currentTimeMillis();
            String string = (String)enumeration.nextElement();
            TestSession testSession = this.createSession(string);
            try {
                try {
                    TestCase testCase = (TestCase)Class.forName(string).newInstance();
                    try {
                        try {
                            testCase.run(testSession);
                        }
                        catch (Throwable throwable) {
                            this.fail(testSession, throwable);
                            if (!(throwable instanceof ThreadDeath)) continue;
                            throw (ThreadDeath)throwable;
                        }
                    }
                    finally {
                        testSession.close();
                        String string2 = this.props.get(LOG_PATH).toString();
                        String string3 = TestUtil.getLogFileName(string2, string);
                        String string4 = this.props.get(REF_OUTPUT_PATH).toString();
                        String string5 = TestUtil.getReferenceFileName(string4, string);
                        String string6 = this.props.get(REPORT_PATH).toString();
                        boolean bl = TestUtil.diffFiles(string3, string5, false);
                        this.writeResults(TestUtil.getReportFileName(string6, string, bl));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.fail(testSession, classNotFoundException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.fail(testSession, illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    this.fail(testSession, instantiationException);
                }
            }
            finally {
                long l2 = System.currentTimeMillis() - l;
                this.log.println("    Executing testcase [" + string + "].  Time = " + l2 + " ms. ");
            }
        }
    }

    private void writeResults(String string) {
        try {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createRepDir() {
        try {
            File file = new File(this.props.get(REPORT_PATH).toString());
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    fileArray[n].delete();
                    ++n;
                }
            }
            file.delete();
            file.mkdirs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void load() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.propsName);
            this.props.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.suiteName);
            this.suite.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        block3: {
            if (stringArray.length != 2) {
                TestHarness.usage();
                System.exit(1);
                return;
            }
            try {
                TestHarness testHarness = new TestHarness(stringArray[0], stringArray[1]);
                testHarness.run();
            }
            catch (TestHarnessException testHarnessException) {
                System.out.println("Caught Test Harness Exception");
                testHarnessException.printStackTrace();
                Exception exception = testHarnessException.getLastException();
                if (exception == null) break block3;
                exception.printStackTrace();
            }
        }
    }

    private void fail(TestSession testSession, Throwable throwable) {
        try {
            throwable.printStackTrace(testSession.getOutputWriter());
            testSession.close();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    private TestSession createSession(String string) {
        TestSession testSession = new TestSession(this.props, string);
        return testSession;
    }
}

