/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.todo;

import java.net.URL;
import java.util.Date;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.net.URLFileSystem;
import oracle.ide.todo.ToDoItem;
import oracle.ide.util.ModelUtil;

public abstract class AbstractToDoItem
extends ChangeEventSource
implements ToDoItem {
    private String _text;
    private int _priorityId;
    private int _line;
    private int _column;
    protected URL _url;
    private boolean _done;
    private Date _date;
    private Object _userData;

    public AbstractToDoItem() {
    }

    public AbstractToDoItem(String string, int n, int n2, int n3, URL uRL, boolean bl, Date date) {
        this._text = string;
        this._priorityId = n;
        this._line = n2;
        this._column = n3;
        this._url = uRL;
        this._done = bl;
        this._date = date;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
    }

    public String getTooltip() {
        return this._text;
    }

    public int getPriorityId() {
        return this._priorityId;
    }

    public void setPriorityId(int n) {
        this._priorityId = n;
    }

    public int getLine() {
        return this._line;
    }

    public void setLine(int n) {
        this._line = n;
    }

    public int getColumn() {
        return this._column;
    }

    public void setColumn(int n) {
        this._column = n;
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL uRL) {
        this._url = uRL;
    }

    public boolean isDone() {
        return this._done;
    }

    public void setDone(boolean bl) {
        this._done = bl;
    }

    public Date getDate() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public Object getUserData() {
        return this._userData;
    }

    public void setUserData(Object object) {
        this._userData = object;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean shouldPersist() {
        return true;
    }

    public String toString() {
        return " Text: " + (this._text != null ? this._text : "<notext>") + " PriorityId: " + this._priorityId + " Line: " + this._line + " Column: " + this._column + " URL: " + (this._url != null ? this._url.toString() : "<noURL>") + " Done: " + this._done + " Date: " + (this._date != null ? this._date.toString() : "<noDate>");
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractToDoItem) {
            AbstractToDoItem abstractToDoItem = (AbstractToDoItem)object;
            if (!(abstractToDoItem.getText() == null && this._text == null || ModelUtil.areEqual((Object)abstractToDoItem.getText(), (Object)this._text))) {
                return false;
            }
            if (abstractToDoItem.getPriorityId() != this._priorityId) {
                return false;
            }
            if (!(abstractToDoItem.getDate() == null && this._date == null || ModelUtil.areEqual((Object)abstractToDoItem.getDate(), (Object)this._date))) {
                return false;
            }
            if (abstractToDoItem.isDone() != this._done) {
                return false;
            }
            if (!(abstractToDoItem.getURL() == null && this._url == null || URLFileSystem.equals(abstractToDoItem.getURL(), this._url))) {
                return false;
            }
            if (abstractToDoItem.getLine() != this._line) {
                return false;
            }
            if (abstractToDoItem.getColumn() != this._column) {
                return false;
            }
            return abstractToDoItem.getUserData() == null && this._userData == null || !ModelUtil.areEqual((Object)abstractToDoItem.getUserData(), (Object)this._userData);
        }
        return false;
    }

    public boolean canGoTo() {
        return this._url != null;
    }

    public abstract void goTo();

    public abstract void dispose();

    public abstract void stateChanged();
}

