/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.ide.util.ModelUtil;

public class AddinPolicyUtils {
    private static Object[] m_ExceptionList = new Object[0];
    private static String POLICY_VIOLATION = "Addin Policy Violation!";
    private static final String CREATING_IMAGE_ICON_POLICY_CHECK_ID = "CREATING_IMAGE_ICON_POLICY_CHECK";
    private static final String CREATING_THREAD_POLICY_CHECK_ID = "CREATING_THREAD_POLICY_CHECK";
    private static final Object ERROR_REPORTED = new Object();
    private static HashMap m_CommandIDNStackTracePairToJMenuItem = new HashMap();
    private static final boolean OVERRIDE_FLAG = Boolean.getBoolean("oracle.ide.util.AddinPolicyUtils.OVERRIDE_FLAG");
    private static boolean m_WarnWhenCreatingImageIcons = false;
    private static boolean m_WarnWhenCreatingThreads = false;
    private static boolean m_WarnWhenLeakingJMenuItems = true;

    public static void initializingAddins(boolean bl) {
        if (!bl) {
            // empty if block
        }
        AddinPolicyUtils.setWarnWhenCreatingImageIcons(bl);
        AddinPolicyUtils.setWarnWhenCreatingThreads(bl);
    }

    public static void creatingImageIconPolicyCheck() {
        if (OVERRIDE_FLAG || m_WarnWhenCreatingImageIcons) {
            // empty if block
        }
    }

    public static void creatingThreadPolicyCheck() {
        String string;
        if (OVERRIDE_FLAG || !m_WarnWhenCreatingThreads || (string = AddinPolicyUtils.getStackTrace(new Exception())).indexOf("java.awt.EventQueue.initDispatchThread") != -1 || string.indexOf("sun.awt.AWTAutoShutdown.activateBlockerThread") != -1 || string.indexOf("java.util.logging.LogManager.<clinit>") != -1 || string.indexOf("java.lang.UNIXProcess.<init>") == -1) {
            // empty if block
        }
    }

    public static void creatingAbstractButtonLeakPolicyCheck(AbstractButton abstractButton) {
        if (!OVERRIDE_FLAG) {
            // empty if block
        }
    }

    public static void creatingLocalActionLeakPolicyCheck(Action action) {
        if (!OVERRIDE_FLAG) {
            // empty if block
        }
    }

    public static void creatingJMenuItemLeakPolicyCheck(JMenuItem jMenuItem, int n) {
        if (!OVERRIDE_FLAG && m_WarnWhenLeakingJMenuItems) {
            CommandIDNStackTracePair commandIDNStackTracePair = new CommandIDNStackTracePair(n);
            Object object = m_CommandIDNStackTracePairToJMenuItem.get(commandIDNStackTracePair);
            if (object != null) {
                if (object == ERROR_REPORTED) {
                    return;
                }
                object = ((WeakReference)object).get();
            }
            if (object != null && ((AbstractButton)object).getAction() != null) {
                m_CommandIDNStackTracePairToJMenuItem.put(commandIDNStackTracePair, ERROR_REPORTED);
                String string = AddinPolicyUtils.getAddInClassName(commandIDNStackTracePair.m_StackTrace);
                if (ModelUtil.areEqual((Object)string, (Object)"oracle.bm.addinUtil.ModelAddin")) {
                    return;
                }
                System.err.println(POLICY_VIOLATION);
                System.err.print(commandIDNStackTracePair.m_StackTrace);
                return;
            }
            m_CommandIDNStackTracePairToJMenuItem.put(commandIDNStackTracePair, new WeakReference<JMenuItem>(jMenuItem));
        }
    }

    public static boolean setWarnWhenCreatingThreads(boolean bl) {
        boolean bl2 = m_WarnWhenCreatingThreads;
        m_WarnWhenCreatingThreads = bl;
        return bl2;
    }

    public static boolean setWarnWhenCreatingImageIcons(boolean bl) {
        boolean bl2 = m_WarnWhenCreatingImageIcons;
        m_WarnWhenCreatingImageIcons = bl;
        return bl2;
    }

    public static boolean setWarnWhenLeakingJMenuItems(boolean bl) {
        boolean bl2 = m_WarnWhenLeakingJMenuItems;
        m_WarnWhenLeakingJMenuItems = bl;
        return bl2;
    }

    public static void runRunnable(Runnable runnable) {
        runnable.run();
    }

    public static void applicationExiting() {
    }

    public static void checkCallStackForPolicyViolation(String string, String string2) {
        String string3;
        if (!OVERRIDE_FLAG && (string3 = AddinPolicyUtils.getStackTrace(new Exception())).indexOf(string) != -1) {
            System.err.println(POLICY_VIOLATION);
            System.err.println(string2 + " called directly or indirectly from " + string);
            System.err.print(string3);
        }
    }

    public static void ensureGarbageCollectable(Object object) {
    }

    public static void ensureGarbageCollectable(Object object, int n) {
        Thread thread = new Thread((Runnable)new MemoryLeakChecker(n, object, null), "Leak detector for " + object);
        thread.setDaemon(true);
        thread.start();
    }

    private AddinPolicyUtils() {
    }

    private static String getStackTrace(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        throwable.printStackTrace(new PrintWriter(charArrayWriter));
        String string = charArrayWriter.toString();
        charArrayWriter.close();
        return string;
    }

    private static String getAddInClassName(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string3 = stringTokenizer.nextToken();
            int n2 = string3.indexOf(".initialize");
            if (n2 == -1) continue;
            if (!stringTokenizer.hasMoreTokens() || stringTokenizer.nextToken().indexOf("oracle.ide.AddinManager.initializeAddin") == -1 || (n = string3.indexOf("at ")) == -1) break;
            string2 = string3.substring(n + 3, n2);
            break;
        }
        return string2;
    }

    private static void printInitializationViolationMessage(String string, String string2) {
        String string3 = AddinPolicyUtils.getStackTrace(new Exception(string));
        if (m_ExceptionList.length > 0) {
            String string4 = AddinPolicyUtils.getAddInClassName(string3);
            if (string4 == null) {
                System.err.println("AddinPolicyUtils BUG: COULD NOT IDENTIFY ADDIN NAME.");
            } else {
                int n = 0;
                while (n < m_ExceptionList.length) {
                    if (string4.equals(m_ExceptionList[n]) && string2 == m_ExceptionList[n + 1]) {
                        return;
                    }
                    n += 2;
                }
            }
        }
        System.err.println(POLICY_VIOLATION);
        System.err.print(string3);
    }

    static String maS$getStackTrace(Throwable throwable) {
        return AddinPolicyUtils.getStackTrace(throwable);
    }

    private static class MemoryLeakChecker
    implements Runnable {
        private final int _numSeconds;
        private final WeakReference _ref;
        private final String _objToString;

        public void run() {
            int n = 1;
            while (n < this._numSeconds) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object t = this._ref.get();
                if (t == null) {
                    return;
                }
                t = null;
                System.gc();
                ++n;
            }
        }

        private MemoryLeakChecker(int n, Object object) {
            this._numSeconds = n;
            this._objToString = object.toString();
            this._ref = new WeakReference<Object>(object);
        }

        MemoryLeakChecker(int n, Object object, 1 var3_3) {
            this(n, object);
        }

        public final class 1 {
        }
    }

    private static class CommandIDNStackTracePair {
        public final int m_CommandID;
        public final String m_StackTrace;

        public CommandIDNStackTracePair(int n) {
            this.m_CommandID = n;
            this.m_StackTrace = AddinPolicyUtils.maS$getStackTrace(new Exception("A memory leak is occurring since a temporary AbstractButton (JMenuItem or JButton usually) was created and the action was not set to null."));
        }

        public boolean equals(Object object) {
            if (object instanceof CommandIDNStackTracePair) {
                CommandIDNStackTracePair commandIDNStackTracePair = (CommandIDNStackTracePair)object;
                return this.m_CommandID == commandIDNStackTracePair.m_CommandID && this.m_StackTrace.equals(commandIDNStackTracePair.m_StackTrace);
            }
            return false;
        }

        public int hashCode() {
            return this.m_StackTrace.hashCode() + this.m_CommandID;
        }
    }
}

