/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Font;
import java.awt.Image;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.util.GraphicsUtils;

public abstract class ArrayResourceBundle
extends ResourceBundle {
    private static final Logger LOG = Logger.getLogger(ArrayResourceBundle.class.getName());
    private int[] _autoSyncMap;
    private static final String nullString = "(null)";
    private static final HashMap iconCache = new HashMap(500);

    public final String[] getStringArray(int n) {
        return (String[])this.getObject(n);
    }

    public final Object getObject(int n) {
        return this.getObjectImpl(n);
    }

    public final String getStringImpl(int n) {
        return this.getObjectImpl(n).toString();
    }

    public final char getCharImpl(int n) {
        Character c = (Character)this.getObjectImpl(n);
        return c.charValue();
    }

    public final Font getFontImpl(int n) {
        return (Font)this.getObjectImpl(n);
    }

    public final KeyStroke getAcceleratorImpl(int n) {
        String string = this.getStringImpl(n);
        if (string != null && string.length() > 0) {
            return KeyStroke.getKeyStroke(string);
        }
        return null;
    }

    public final Integer getIntegerImpl(int n) {
        String string = this.getStringImpl(n);
        if (string.length() == 1 && Character.isLetter(string.charAt(0))) {
            return new Integer(string.charAt(0));
        }
        return Integer.valueOf(string);
    }

    public final char getMnemonicImpl(int n) {
        int n2;
        String string = this.getStringImpl(n);
        int n3 = n2 = string != null ? string.length() : 0;
        if (n2 == 1) {
            return string.charAt(0);
        }
        return (char)StringUtils.getMnemonicKeyCode((String)string);
    }

    public final Icon getIconImpl(int n) {
        return this.getImageIconImpl(n, true);
    }

    public final Icon getUncachedIconImpl(int n) {
        return this.getImageIconImpl(n, false);
    }

    public final Image getImageImpl(int n) {
        ImageIcon imageIcon = this.getImageIconImpl(n, true);
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    public final Image getUncachedImageImpl(int n) {
        ImageIcon imageIcon = this.getImageIconImpl(n, false);
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    public final Object getObjectImpl(int n) {
        return this.getObjectImpl(n, false);
    }

    private final Object getObjectImpl(int n, boolean bl) {
        Object[] objectArray = this.getContents();
        int n2 = this.getMappedIndex(n);
        if (!bl && n2 < objectArray.length && n2 >= 0) {
            return objectArray[n2];
        }
        if (this.parent == null) {
            if (bl) {
                return this.getObjectImpl(n, false);
            }
            throw new MissingResourceException("Can't find resource", this.getClass().getName(), String.valueOf(n));
        }
        if (this.parent instanceof ArrayResourceBundle) {
            return ((ArrayResourceBundle)this.parent).getObjectImpl(n);
        }
        return this.parent.getObject(String.valueOf(n));
    }

    public final String formatImpl(int n, Object[] objectArray) {
        int n2;
        int n3 = n2 = objectArray == null ? 0 : objectArray.length;
        if (n2 == 0) {
            return this.getStringImpl(n);
        }
        int n4 = 0;
        while (n4 < n2) {
            if (objectArray[n4] == null) {
                objectArray[n4] = nullString;
            }
            ++n4;
        }
        String string = this.formatImplNoCheck(n, objectArray);
        int n5 = 0;
        while (n5 < n2) {
            if (objectArray[n5] == nullString) {
                objectArray[n5] = null;
            }
            ++n5;
        }
        return string;
    }

    public final String formatImpl(int n, Object object) {
        return this.formatImpl(n, new Object[]{object});
    }

    public final String formatImpl(int n, Object object, Object object2) {
        return this.formatImpl(n, new Object[]{object, object2});
    }

    public final String formatImpl(int n, Object object, Object object2, Object object3) {
        return this.formatImpl(n, new Object[]{object, object2, object3});
    }

    private String formatImplNoCheck(int n, Object[] objectArray) {
        String string = this.getStringImpl(n);
        return MessageFormat.format(string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ImageIcon getImageIconImpl(int n, boolean bl) {
        String string = (String)this.getObjectImpl(n, true);
        if (string == null || string.length() == 0) {
            return null;
        }
        Class<?> clazz = this.getClass();
        String string2 = clazz.getName();
        IconKey iconKey = new IconKey(string2, n);
        HashMap hashMap = iconCache;
        synchronized (hashMap) {
            Object v = iconCache.get(iconKey);
            if (v != null) {
                ImageIcon imageIcon = (ImageIcon)v;
                return imageIcon;
            }
        }
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = null;
        if (uRL != null && (imageIcon = GraphicsUtils.createImageIcon(uRL)) != null && bl) {
            HashMap hashMap2 = iconCache;
            synchronized (hashMap2) {
                iconCache.put(iconKey, imageIcon);
            }
        }
        return imageIcon;
    }

    protected abstract Object[] getContents();

    public final Enumeration getKeys() {
        Object[] objectArray = this.getContents();
        List<Object> list = Arrays.asList(objectArray);
        return Collections.enumeration(list);
    }

    protected final Object handleGetObject(String string) {
        return this.getObject(Integer.parseInt(string));
    }

    private int getMappedIndex(int n) {
        if (this.parent == null || !(this.parent instanceof ArrayResourceBundle)) {
            return n;
        }
        if (this._autoSyncMap == null) {
            this.buildAutoSyncMap();
        }
        try {
            int n2 = this._autoSyncMap[n];
            if (n2 == -1) {
                LOG.warning("NLSSYNC: ARB key '" + ArrayResourceBundle.getFieldNameForIndex(this.parent.getClass(), n) + "' exists in " + this.parent.getClass() + " but not in " + this.getClass().getName());
            }
            int n3 = n2;
            return n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            LOG.warning("NLSSYNC: Key " + ArrayResourceBundle.getFieldNameForIndex(this.getClass(), n) + " does not exist in " + this.getClass().getName());
            int n4 = -1;
            return n4;
        }
    }

    private void buildAutoSyncMap() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (field.getType() == Integer.TYPE) {
                try {
                    int n2 = field.getInt(null);
                    hashMap.put(field.getName(), new Integer(n2));
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            ++n;
        }
        Field[] fieldArray2 = this.parent.getClass().getDeclaredFields();
        this._autoSyncMap = new int[fieldArray2.length];
        Arrays.fill(this._autoSyncMap, -1);
        int n3 = 0;
        while (n3 < fieldArray2.length) {
            Field field = fieldArray2[n3];
            if (field.getType() == Integer.TYPE) {
                try {
                    int n4 = field.getInt(null);
                    Integer n5 = (Integer)hashMap.get(field.getName());
                    if (n5 != null) {
                        this._autoSyncMap[n4] = n5;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            ++n3;
        }
    }

    private static String getFieldNameForIndex(Class clazz, int n) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Field field = fieldArray[n2];
            if (field.getType() == Integer.TYPE) {
                try {
                    int n3 = field.getInt(null);
                    if (n3 == n) {
                        String string = field.getName();
                        return string;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return String.valueOf(n);
    }

    private static final class IconKey {
        private String name;
        private int key;

        IconKey(String string, int n) {
            this.name = string;
            this.key = n;
        }

        public int hashCode() {
            return this.name.hashCode() + this.key;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IconKey) {
                IconKey iconKey = (IconKey)object;
                if (iconKey.name.equals(this.name) && iconKey.key == this.key) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.name + ":" + this.key;
        }
    }
}

