/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ArraySortedSet
extends AbstractSet
implements Cloneable,
SortedSet {
    private Object[] _contents;
    private int _size;
    private Comparator _comparator;
    private int _modCount;
    private static final int ALLOW_EXIST = 0;
    private static final int REQUIRE_EXIST = 1;
    private static final int REQUIRE_NOT_EXIST = 2;

    public ArraySortedSet() {
        this(10);
    }

    public ArraySortedSet(int n) {
        this(n, null);
    }

    public ArraySortedSet(Comparator comparator) {
        this(10, comparator);
    }

    public ArraySortedSet(int n, Comparator comparator) {
        this.$init$();
        n = Math.max(n, 0);
        this._comparator = comparator;
        this._contents = new Object[n];
    }

    public ArraySortedSet(Object[] objectArray, Comparator comparator) {
        this(objectArray.length, comparator);
        this.addAll(objectArray);
    }

    public ArraySortedSet(Collection collection, Comparator comparator) {
        this(collection.size(), comparator);
        this.addAll(collection);
    }

    void $init$() {
        this._contents = null;
        this._size = 0;
        this._comparator = null;
        this._modCount = 0;
    }

    public void addAll(Object[] objectArray) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.add(objectArray[n2]);
            ++n2;
        }
    }

    public void trimToSize() {
        if (this._size != this._contents.length) {
            Object[] objectArray = new Object[this._size];
            System.arraycopy(this._contents, 0, objectArray, 0, this._size);
            this._contents = objectArray;
        }
    }

    public Object lookup(Object object) {
        int n = this.find(object, 1);
        return n == -1 ? null : this._contents[n];
    }

    public Object clone() {
        int n = this._contents.length;
        ArraySortedSet arraySortedSet = new ArraySortedSet(n, this._comparator);
        System.arraycopy(this._contents, 0, arraySortedSet._contents, 0, this._size);
        arraySortedSet._size = this._size;
        return arraySortedSet;
    }

    public Comparator comparator() {
        return this._comparator;
    }

    public SortedSet subSet(Object object, Object object2) {
        return new Subset(object, object2, null);
    }

    public SortedSet headSet(Object object) {
        return new Subset(null, object, null);
    }

    public SortedSet tailSet(Object object) {
        return new Subset(object, null, null);
    }

    public Object first() {
        if (this._size > 0) {
            return this._contents[0];
        }
        throw new NoSuchElementException();
    }

    public Object last() {
        if (this._size > 0) {
            return this._contents[this._size - 1];
        }
        throw new NoSuchElementException();
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public Iterator iterator() {
        return new ArrayItr(null);
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        System.arraycopy(this._contents, 0, objectArray, 0, this._size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this._size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this._size);
        }
        System.arraycopy(this._contents, 0, objectArray, 0, this._size);
        if (objectArray.length > this._size) {
            objectArray[this._size] = null;
        }
        return objectArray;
    }

    public boolean add(Object object) {
        int n = this.find(object, 2);
        if (n != -1) {
            this.insertIndex(object, n);
            return true;
        }
        return false;
    }

    public boolean remove(Object object) {
        int n = this.find(object, 1);
        if (n != -1) {
            this.removeIndex(n);
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        int n = this.find(object, 1);
        return n != -1;
    }

    public void clear() {
        ++this._modCount;
        this._contents = new Object[this._contents.length];
        this._size = 0;
    }

    protected Object intern(Object object) {
        int n = this.find(object, 1);
        if (n == -1) {
            this.add(object);
            return object;
        }
        return this._contents[n];
    }

    private int find(Object object, int n) {
        int n2 = 0;
        int n3 = this._size;
        while (true) {
            int n4 = n3 - n2;
            switch (n4) {
                case 0: {
                    return n == 1 ? -1 : n2;
                }
                case 1: {
                    Object object2 = this._contents[n2];
                    int n5 = this.compare(object, object2);
                    boolean bl = n5 == 0;
                    int n6 = n5 <= 0 ? n2 : n3;
                    switch (n) {
                        case 1: {
                            return bl ? n2 : -1;
                        }
                        case 0: {
                            return n6;
                        }
                        case 2: {
                            return !bl ? n6 : -1;
                        }
                    }
                    throw new IllegalStateException("Invalid flag: " + n);
                }
            }
            int n7 = n2 + n3 >> 1;
            Object object3 = this._contents[n7];
            int n8 = this.compare(object, object3);
            if (n8 == 0) {
                return n == 2 ? -1 : n7;
            }
            if (n8 < 0) {
                n3 = n7;
                continue;
            }
            n2 = n7 + 1;
        }
    }

    private int compare(Object object, Object object2) {
        if (this._comparator != null) {
            return this._comparator.compare(object, object2);
        }
        return ((Comparable)object).compareTo(object2);
    }

    private static int compare(Comparator comparator, Object object, Object object2) {
        if (comparator != null) {
            return comparator.compare(object, object2);
        }
        return ((Comparable)object).compareTo(object2);
    }

    private void ensureCapacity(int n) {
        int n2 = this._contents.length;
        if (n2 < n) {
            int n3 = Math.max(n2 * 5 / 4, n);
            Object[] objectArray = new Object[n3];
            System.arraycopy(this._contents, 0, objectArray, 0, this._size);
            this._contents = objectArray;
        }
    }

    private void insertIndex(Object object, int n) {
        if (n <= this._size) {
            ++this._modCount;
            this.ensureCapacity(this._size + 1);
            int n2 = this._size - n;
            if (n2 > 0) {
                System.arraycopy(this._contents, n, this._contents, n + 1, n2);
            }
            this._contents[n] = object;
            ++this._size;
        } else {
            throw new IllegalStateException("Invalid index: " + n);
        }
    }

    private void removeIndex(int n) {
        if (n < this._size) {
            ++this._modCount;
            int n2 = this._size - 1;
            int n3 = n2 - n;
            if (n3 > 0) {
                System.arraycopy(this._contents, n + 1, this._contents, n, n3);
            }
            this._contents[n2] = null;
            --this._size;
        } else {
            throw new IllegalStateException("Invalid index: " + n);
        }
    }

    private void removeRange(int n, int n2) {
        int n3 = n2 - n;
        if (n < 0 || n2 < n || this._size < n2) {
            throw new IllegalStateException("Invalid range");
        }
        ++this._modCount;
        int n4 = this._size - n2;
        if (n4 > 0) {
            System.arraycopy(this._contents, n2, this._contents, n, n4);
        }
        int n5 = n + n4;
        while (n5 < this._size) {
            this._contents[n5] = null;
            ++n5;
        }
        this._size -= n3;
    }

    static int ra$_modCount(ArraySortedSet arraySortedSet) {
        return arraySortedSet._modCount;
    }

    static void mav$removeIndex(ArraySortedSet arraySortedSet, int n) {
        arraySortedSet.removeIndex(n);
    }

    static Object[] ra$_contents(ArraySortedSet arraySortedSet) {
        return arraySortedSet._contents;
    }

    static int ra$_size(ArraySortedSet arraySortedSet) {
        return arraySortedSet._size;
    }

    static int mav$find(ArraySortedSet arraySortedSet, Object object, int n) {
        return arraySortedSet.find(object, n);
    }

    static void mav$removeRange(ArraySortedSet arraySortedSet, int n, int n2) {
        arraySortedSet.removeRange(n, n2);
    }

    static int mav$compare(ArraySortedSet arraySortedSet, Object object, Object object2) {
        return arraySortedSet.compare(object, object2);
    }

    private final class ArrayItr
    implements Iterator {
        private int endIndex;
        private int nextIndex;
        private int lastIndex;
        private int modCount;

        private ArrayItr() {
            this.$init$();
            this.modCount = ArraySortedSet.ra$_modCount(ArraySortedSet.this);
            this.nextIndex = 0;
            this.endIndex = ArraySortedSet.ra$_size(ArraySortedSet.this);
        }

        private ArrayItr(int n, int n2) {
            this.$init$();
            this.modCount = ArraySortedSet.ra$_modCount(ArraySortedSet.this);
            this.nextIndex = n;
            this.endIndex = n2;
        }

        public boolean hasNext() {
            return this.nextIndex < this.endIndex;
        }

        public Object next() {
            Object object;
            try {
                object = ArraySortedSet.ra$_contents(ArraySortedSet.this)[this.nextIndex];
                this.checkModification();
                this.lastIndex = this.nextIndex++;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkModification();
                throw new NoSuchElementException();
            }
            return object;
        }

        public void remove() {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            this.checkModification();
            try {
                ArraySortedSet.mav$removeIndex(ArraySortedSet.this, this.lastIndex);
                this.lastIndex = -1;
                --this.nextIndex;
                --this.endIndex;
                this.modCount = ArraySortedSet.ra$_modCount(ArraySortedSet.this);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkModification() {
            if (this.modCount != ArraySortedSet.ra$_modCount(ArraySortedSet.this)) {
                throw new ConcurrentModificationException();
            }
        }

        void $init$() {
            this.lastIndex = -1;
        }

        ArrayItr(1 var2_2) {
            this();
        }

        ArrayItr(int n, int n2, 1 var4_4) {
            this(n, n2);
        }

        public final class 1 {
        }
    }

    private final class Subset
    extends AbstractSet
    implements SortedSet {
        private Object headObj;
        private Object tailObj;

        private Subset(Object object, Object object2) {
            this.headObj = object;
            this.tailObj = object2;
        }

        public Comparator comparator() {
            return ArraySortedSet.this.comparator();
        }

        private boolean inRange(Object object) {
            if (this.headObj != null && ArraySortedSet.mav$compare(ArraySortedSet.this, this.headObj, object) > 0) {
                return false;
            }
            return this.tailObj == null || ArraySortedSet.mav$compare(ArraySortedSet.this, object, this.tailObj) <= 0;
        }

        public boolean add(Object object) {
            if (!this.inRange(object)) {
                throw new IllegalArgumentException("outside of subset");
            }
            return ArraySortedSet.this.add(object);
        }

        public boolean remove(Object object) {
            if (!this.inRange(object)) {
                return false;
            }
            return ArraySortedSet.this.remove(object);
        }

        public void clear() {
            int n = this.getStart();
            int n2 = this.getEnd();
            ArraySortedSet.mav$removeRange(ArraySortedSet.this, n, n2);
        }

        public SortedSet subSet(Object object, Object object2) {
            Object object3 = this.inRange(object) ? object : this.headObj;
            Object object4 = this.inRange(object2) ? object2 : this.tailObj;
            return new Subset(object3, object4);
        }

        public SortedSet headSet(Object object) {
            Object object2 = this.inRange(object) ? object : this.tailObj;
            return new Subset(this.headObj, object2);
        }

        public SortedSet tailSet(Object object) {
            Object object2 = this.inRange(object) ? object : this.headObj;
            return new Subset(object2, this.tailObj);
        }

        public Object first() {
            int n;
            int n2 = this.getStart();
            if (n2 == (n = this.getEnd())) {
                throw new NoSuchElementException();
            }
            return ArraySortedSet.ra$_contents(ArraySortedSet.this)[n2];
        }

        public Object last() {
            int n;
            int n2 = this.getStart();
            if (n2 == (n = this.getEnd())) {
                throw new NoSuchElementException();
            }
            return ArraySortedSet.ra$_contents(ArraySortedSet.this)[n - 1];
        }

        public int size() {
            return this.getEnd() - this.getStart();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean contains(Object object) {
            if (this.inRange(object)) {
                return ArraySortedSet.this.contains(object);
            }
            return false;
        }

        public Iterator iterator() {
            int n = this.getStart();
            int n2 = this.getEnd();
            return new ArrayItr(n, n2, null);
        }

        private int getStart() {
            int n = this.headObj == null ? 0 : ArraySortedSet.mav$find(ArraySortedSet.this, this.headObj, 0);
            return n;
        }

        private int getEnd() {
            int n = this.tailObj == null ? ArraySortedSet.ra$_size(ArraySortedSet.this) : ArraySortedSet.mav$find(ArraySortedSet.this, this.tailObj, 0);
            return n;
        }

        public Object[] toArray() {
            int n = this.getStart();
            int n2 = this.getEnd();
            int n3 = n2 - n;
            Object[] objectArray = new Object[n3];
            System.arraycopy(ArraySortedSet.ra$_contents(ArraySortedSet.this), n, objectArray, 0, n3);
            return objectArray;
        }

        public Object[] toArray(Object[] objectArray) {
            int n = this.getStart();
            int n2 = this.getEnd();
            int n3 = n2 - n;
            if (objectArray.length < n3) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n3);
            }
            System.arraycopy(ArraySortedSet.ra$_contents(ArraySortedSet.this), n, objectArray, 0, n3);
            if (objectArray.length > n3) {
                objectArray[n3] = null;
            }
            return objectArray;
        }

        Subset(Object object, Object object2, 1 var4_4) {
            this(object, object2);
        }

        public final class 1 {
        }
    }
}

