/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.HashMap;
import java.util.Stack;
import oracle.ide.util.HogTracker;

public final class Assert {
    private static HashMap _timingMap = new HashMap();
    private static HashMap _trackerMap = new HashMap();
    private static final String CHECKING_PROPERTY = "ide.AssertCheckingDisabled";
    private static final boolean checking = Boolean.getBoolean("ide.AssertCheckingDisabled") ^ true;
    private static final String TRACING_PROPERTY = "ide.AssertTracingDisabled";
    private static final boolean tracing = Boolean.getBoolean("ide.AssertTracingDisabled") ^ true;

    private Assert() {
    }

    public static void precondition(boolean bl, String string) throws PreconditionException {
        if (checking && !bl) {
            throw new PreconditionException(string);
        }
    }

    public static void precondition(boolean bl) throws PreconditionException {
        if (checking && !bl) {
            throw new PreconditionException();
        }
    }

    public static void check(boolean bl, String string) throws CheckException {
        if (checking && !bl) {
            throw new CheckException(string);
        }
    }

    public static void check(boolean bl) throws CheckException {
        if (checking && !bl) {
            throw new CheckException();
        }
    }

    public static void checkAWTThread() throws CheckException {
    }

    public static void fail(String string) throws CheckException {
    }

    public static void fail() throws CheckException {
    }

    public static void fail(Exception exception) throws CheckException {
    }

    public static void exit(int n) {
        System.exit(n);
    }

    public static void printStackTrace() {
    }

    public static void printStackTrace(Throwable throwable) {
        throwable.printStackTrace(System.err);
    }

    public static void printStackTrace(boolean bl, String string) {
        if (!bl || string != null) {
            // empty if block
        }
    }

    public static void print(String string) {
        if (tracing) {
            System.err.print("Assert: " + string);
        }
    }

    public static void print(boolean bl, String string) {
        if (bl) {
            // empty if block
        }
    }

    public static void print(boolean bl, String string, String string2) {
        if (!bl) {
            // empty if block
        }
    }

    public static void println(String string) {
        if (tracing) {
            System.err.println("Assert: " + string);
        }
    }

    public static void println(boolean bl, String string) {
        if (bl) {
            // empty if block
        }
    }

    public static void println(boolean bl, String string, String string2) {
        if (!bl) {
            // empty if block
        }
    }

    public static void println(String string, Object object) {
    }

    public static void println(String string, Object object, Object object2) {
    }

    public static void println(String string, Object object, Object object2, Object object3) {
    }

    public static void println(String string, Object[] objectArray) {
    }

    public static void execute(Runnable runnable) {
        runnable.run();
    }

    private static String getTimingKey(String string) {
        return Thread.currentThread().getName() + ":" + string;
    }

    public static void startTiming(String string, String string2, boolean bl) {
    }

    public static void startTiming(String string, String string2, boolean bl, boolean bl2) {
        if (bl) {
            return;
        }
        String string3 = bl2 ? Assert.getTimingKey(string) : string;
        _timingMap.put(string3, new Long(System.currentTimeMillis()));
    }

    public static void endTiming(String string, String string2, String string3, boolean bl) {
    }

    public static void endTiming(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        if (bl) {
            return;
        }
        long l = System.currentTimeMillis();
        String string5 = string4 = bl2 ? Assert.getTimingKey(string) : string;
        if (string2 != null) {
            if (!_timingMap.containsKey(string4)) {
                return;
            }
            long l2 = (Long)_timingMap.get(string4);
        }
        _timingMap.remove(string4);
    }

    public static void printTiming(long l, String string, String string2) {
    }

    public static void printTiming(long l, String string, String string2, long l2) {
        if (l >= l2) {
            StringBuffer stringBuffer = new StringBuffer(10 + string.length());
            stringBuffer.append("[").append(l).append("ms] ");
            while (stringBuffer.length() < 11) {
                stringBuffer.insert(0, " ");
            }
            if (string2 == null || string2.length() == 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string2).append(string);
            }
        }
    }

    public static void printHeader(String string) {
        if (string != null) {
            // empty if block
        }
    }

    public static void startTracking(String string) {
        String string2 = Assert.getTimingKey(string);
        Stack<HogTracker> stack = (Stack<HogTracker>)_trackerMap.get(string2);
        if (stack == null) {
            stack = new Stack<HogTracker>();
            _trackerMap.put(string2, stack);
        }
        stack.push(new HogTracker());
    }

    public static void markTracking(String string) {
        HogTracker hogTracker = Assert.getTracker(string, false);
        if (hogTracker != null) {
            hogTracker.mark();
        }
    }

    public static void checkTracking(String string, Object object) {
        HogTracker hogTracker = Assert.getTracker(string, false);
        if (hogTracker != null) {
            hogTracker.check(object);
        }
    }

    public static void endTracking(String string) {
    }

    public static void endTracking(String string, String string2) {
        HogTracker hogTracker = Assert.getTracker(string, true);
        if (hogTracker != null) {
            hogTracker.report();
            if (string2 != null && string2.length() > 0) {
                hogTracker.reportTotal(string2);
            }
            _trackerMap.remove(string);
        }
    }

    private static HogTracker getTracker(String string, boolean bl) {
        String string2 = Assert.getTimingKey(string);
        if (!_trackerMap.containsKey(string2)) {
            return null;
        }
        Stack stack = (Stack)_trackerMap.get(string2);
        if (bl) {
            HogTracker hogTracker = (HogTracker)stack.pop();
            if (stack.size() == 0) {
                _trackerMap.remove(stack);
            }
            return hogTracker;
        }
        return (HogTracker)stack.peek();
    }

    public static class PreconditionException
    extends IllegalStateException {
        PreconditionException() {
        }

        PreconditionException(String string) {
            super(string);
        }
    }

    public static class CheckException
    extends IllegalStateException {
        CheckException() {
            this("Check failed");
        }

        CheckException(String string) {
            super(string);
        }
    }
}

