/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public class BitField {
    private static final int FIELD_SIZE = 32;
    private int bits;
    private int size;

    void $init$() {
        this.size = 0;
    }

    public BitField() {
        this.$init$();
        this.bits = 0;
    }

    public BitField(int n) {
        this.$init$();
        this.setField(n);
    }

    public int getSize() {
        return this.size;
    }

    public void set(int n) {
        BitField.checkIndex(n);
        this.bits |= BitField.bitmask(n);
        this.determineSize();
    }

    public void unset(int n) {
        BitField.checkIndex(n);
        this.bits &= ~BitField.bitmask(n);
        this.determineSize();
    }

    public void clear(int n) {
        this.unset(n);
    }

    public void toggle(int n) {
        BitField.checkIndex(n);
        this.bits ^= BitField.bitmask(n);
        this.determineSize();
    }

    public boolean isSet(int n) {
        BitField.checkIndex(n);
        int n2 = BitField.bitmask(n);
        return (this.bits & n2) == n2;
    }

    public int get(int n) {
        BitField.checkIndex(n);
        return this.bits & BitField.bitmask(n);
    }

    public int getField() {
        return this.bits;
    }

    public void setField(int n) {
        this.bits = n;
        this.determineSize();
    }

    public static boolean isSet(int n, int n2) {
        return n2 != 0 ? (n & n2) == n2 : false;
    }

    public static int set(int n, int n2) {
        return n |= n2;
    }

    public static int unset(int n, int n2) {
        return n &= ~n2;
    }

    public static int toggle(int n, int n2) {
        return n ^ n2;
    }

    private void determineSize() {
        this.size = 0;
        int n = 0;
        while (n < 32) {
            if (this.isSet(n)) {
                this.size = n + 1;
            }
            ++n;
        }
    }

    private static int bitmask(int n) {
        return 1 << n;
    }

    private static void checkIndex(int n) {
        if (n < 0 || n >= 32) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
    }
}

