/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.util.ContextHolder;
import oracle.ide.util.WeakDataHolder;
import oracle.ide.util.WeakDataReference;

public final class ContextWatcher
implements WeakDataHolder,
Observer {
    private static final HashMap _WSP_TO_PRJ_MAP = new HashMap();
    private Node _node;
    private Project _prj;
    private Workspace _wsp;
    private ArrayList _holders;

    void $init$() {
        this._holders = new ArrayList();
    }

    private ContextWatcher(Context context) {
        this.$init$();
        if (context != null) {
            Workspaces workspaces = Ide.getWorkspaces();
            this._node = context.getNode();
            this._prj = context.getProject();
            this._wsp = context.getWorkspace();
            this._node.attach(this);
            this._prj.attach(this);
            this._wsp.attach(this);
            workspaces.attach(this);
        }
    }

    public static void startWatching(ContextHolder contextHolder) {
        Context context = contextHolder.getContext();
        ContextWatcher contextWatcher = ContextWatcher.findOrCreateWatcher(context);
        if (contextWatcher != null) {
            contextWatcher.addContextHolder(contextHolder);
        }
    }

    public static void stopWatching(ContextHolder contextHolder) {
        Node node;
        ContextWatcher contextWatcher;
        Project project;
        Context context = contextHolder != null ? contextHolder.getContext() : null;
        Workspace workspace = context != null ? context.getWorkspace() : null;
        HashMap hashMap = workspace != null ? _WSP_TO_PRJ_MAP.get(workspace) : null;
        if (hashMap != null && (hashMap = (HashMap)((project = context.getProject()) != null ? hashMap.get(project) : null)) != null && (contextWatcher = (ContextWatcher)((node = context.getNode()) != null ? hashMap.get(node) : null)) != null) {
            contextWatcher.removeContextHolder(contextHolder);
        }
    }

    public void dataExpired(WeakDataReference weakDataReference) {
        this._holders.remove(weakDataReference);
        if (this._holders.isEmpty()) {
            this.release();
        }
    }

    public boolean isExpired() {
        return false;
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.OBJECT_RENAMED) {
            if (object == this._node) {
                List list = updateMessage.getAddObjects();
                if (!list.isEmpty()) {
                    this._node = (Node)list.get(0);
                } else {
                    this._node = RenameMessage.getRenamedNode(updateMessage);
                    if (this._node == null) {
                        this._node = (Node)object;
                    }
                }
                this.fireNodeRenamed();
            } else if (object == this._prj) {
                this.fireProjectRenamed();
            } else if (object == this._wsp) {
                this.fireWorkspaceRenamed();
            }
        } else if (n == UpdateMessage.CHILD_REMOVED) {
            List list;
            if (object == this._prj) {
                List list2 = updateMessage.getRemoveObjects();
                if (list2 != null && list2.contains(this._node)) {
                    this.fireContextRemoved();
                }
            } else if (object == this._wsp) {
                List list3 = updateMessage.getRemoveObjects();
                if (list3.contains(this._prj)) {
                    this.fireContextRemoved();
                }
            } else if (object == Ide.getWorkspaces() && (list = updateMessage.getRemoveObjects()).contains(this._wsp)) {
                this.fireContextRemoved();
            }
        }
    }

    private void addContextHolder(ContextHolder contextHolder) {
        int n = this._holders.size() - 1;
        while (n >= 0) {
            WeakDataReference weakDataReference = (WeakDataReference)this._holders.get(n);
            if (weakDataReference.get() == contextHolder) {
                return;
            }
            --n;
        }
        WeakDataReference weakDataReference = new WeakDataReference(this, contextHolder);
        this._holders.add(weakDataReference);
    }

    private void removeContextHolder(ContextHolder contextHolder) {
        int n = this._holders.size() - 1;
        while (n >= 0) {
            WeakDataReference weakDataReference = (WeakDataReference)this._holders.get(n);
            if (weakDataReference.get() == contextHolder) {
                this._holders.remove(weakDataReference);
                break;
            }
            --n;
        }
    }

    private void fireNodeRenamed() {
        Context context = Context.newIdeContext(this._node);
        context.setProject(this._prj);
        context.setWorkspace(this._wsp);
        int n = this._holders.size() - 1;
        while (n >= 0) {
            WeakDataReference weakDataReference = (WeakDataReference)this._holders.get(n);
            ContextHolder contextHolder = (ContextHolder)weakDataReference.get();
            if (contextHolder != null) {
                contextHolder.nodeRenamed(context);
            } else {
                this._holders.remove(weakDataReference);
            }
            --n;
        }
        if (this._holders.size() == 0) {
            this.release();
        }
    }

    private void fireProjectRenamed() {
        Context context = Context.newIdeContext(this._node);
        context.setProject(this._prj);
        context.setWorkspace(this._wsp);
        int n = this._holders.size() - 1;
        while (n >= 0) {
            WeakDataReference weakDataReference = (WeakDataReference)this._holders.get(n);
            ContextHolder contextHolder = (ContextHolder)weakDataReference.get();
            if (contextHolder != null) {
                contextHolder.projectRenamed(context);
            } else {
                this._holders.remove(weakDataReference);
            }
            --n;
        }
        if (this._holders.size() == 0) {
            this.release();
        }
    }

    private void fireWorkspaceRenamed() {
        Context context = Context.newIdeContext(this._node);
        context.setProject(this._prj);
        context.setWorkspace(this._wsp);
        int n = this._holders.size() - 1;
        while (n >= 0) {
            WeakDataReference weakDataReference = (WeakDataReference)this._holders.get(n);
            ContextHolder contextHolder = (ContextHolder)weakDataReference.get();
            if (contextHolder != null) {
                contextHolder.workspaceRenamed(context);
            } else {
                this._holders.remove(weakDataReference);
            }
            --n;
        }
        if (this._holders.size() == 0) {
            this.release();
        }
    }

    private void fireContextRemoved() {
        int n = this._holders.size() - 1;
        while (n >= 0) {
            WeakDataReference weakDataReference = (WeakDataReference)this._holders.get(n);
            ContextHolder contextHolder = (ContextHolder)weakDataReference.get();
            if (contextHolder != null) {
                contextHolder.contextRemoved();
            }
            --n;
        }
        this.release();
    }

    private void release() {
        this._node.detach(this);
        this._prj.detach(this);
        this._wsp.detach(this);
        int n = this._holders.size() - 1;
        while (n >= 0) {
            WeakDataReference weakDataReference = (WeakDataReference)this._holders.get(n);
            weakDataReference.clear();
            --n;
        }
        this._holders.clear();
        HashMap hashMap = (HashMap)_WSP_TO_PRJ_MAP.get(this._wsp);
        HashMap hashMap2 = (HashMap)hashMap.get(this._prj);
        if (hashMap2 != null) {
            hashMap2.remove(this._node);
            if (hashMap2.isEmpty()) {
                hashMap.remove(this._prj);
                if (hashMap.isEmpty()) {
                    _WSP_TO_PRJ_MAP.remove(this._prj);
                }
            }
        }
    }

    private static ContextWatcher findOrCreateWatcher(Context context) {
        ContextWatcher contextWatcher;
        HashMap<Node, ContextWatcher> hashMap;
        if (context == null) {
            return null;
        }
        Workspace workspace = context.getWorkspace();
        Project project = context.getProject();
        Node node = context.getNode();
        if (workspace == null || project == null || node == null) {
            return null;
        }
        HashMap hashMap2 = (HashMap)_WSP_TO_PRJ_MAP.get(workspace);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            _WSP_TO_PRJ_MAP.put(workspace, hashMap2);
        }
        if ((hashMap = (HashMap<Node, ContextWatcher>)hashMap2.get(project)) == null) {
            hashMap = new HashMap<Node, ContextWatcher>();
            hashMap2.put(project, hashMap);
        }
        if ((contextWatcher = (ContextWatcher)hashMap.get(node)) == null) {
            contextWatcher = new ContextWatcher(context);
            hashMap.put(node, contextWatcher);
        }
        return contextWatcher;
    }
}

