/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.EncodingsData;
import oracle.ide.util.SwingWorker;
import sun.io.ByteToCharConverter;

public final class Encodings {
    public static final String UTF8_ENCODING = "UTF-8";
    private static final String LOADED_KEY = "encodings-loaded";
    private static File _encodingsFile;
    private static String[] _encodings;
    private static String _defaultEncoding;
    private static EncodingsData _data;

    private Encodings() {
    }

    public static void setEncodingsFile(File file) {
        _encodingsFile = file;
    }

    public static boolean isSupported(String string) {
        boolean bl = false;
        try {
            bl = Charset.isSupported(string);
            if (!bl) {
                String string2 = new String(new byte[0], string);
                bl = true;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return bl;
    }

    public static String getDefaultEncoding() {
        if (_defaultEncoding == null) {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            _defaultEncoding = inputStreamReader.getEncoding().intern();
        }
        return _defaultEncoding;
    }

    public static String getDefaultIanaEncoding() {
        if (Encodings.isDefaultCp1252()) {
            return "windows-1252";
        }
        return Encodings.convertJdk2IanaEncoding(Encodings.getDefaultEncoding());
    }

    public static String convertJdk2IanaEncoding(String string) {
        if (string == null) {
            return null;
        }
        EncodingsData encodingsData = Encodings.getEncodingsData();
        String string2 = (String)encodingsData.getJdk2IanaMap().get(string.toUpperCase());
        if (string2 == null) {
            string2 = string;
            try {
                Charset charset = Charset.forName(string);
                if (charset != null) {
                    string2 = charset.name();
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static synchronized String[] getEncodings() {
        Encodings.ensureInit();
        return (String[])_encodings.clone();
    }

    public static boolean isDefaultCp1252() {
        return "Cp1252".equalsIgnoreCase(Encodings.getDefaultEncoding());
    }

    public static void initComboBox(JComboBox jComboBox, boolean bl, String string) {
        String string2;
        String string3 = string2 = string == null ? Encodings.getDefaultEncoding() : string;
        if (_encodings == null) {
            jComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{string2}));
            jComboBox.setSelectedItem(string2);
            jComboBox.addPopupMenuListener(new 2(jComboBox, bl, string2));
        } else {
            Encodings.populateComboBox(jComboBox, bl, string2);
        }
    }

    public static void loadEncodings(JComboBox jComboBox, boolean bl, String string) {
        if (jComboBox == null) {
            return;
        }
        if (Boolean.TRUE.equals(jComboBox.getClientProperty(LOADED_KEY))) {
            jComboBox.setSelectedItem(string);
            return;
        }
        1 var3_3 = new 1(jComboBox, bl, string);
        var3_3.start();
    }

    private static void populateComboBox(JComboBox jComboBox, boolean bl, String string) {
        EncodingsComboBoxModel encodingsComboBoxModel = new EncodingsComboBoxModel(_encodings, bl, null);
        jComboBox.setModel(encodingsComboBoxModel);
        jComboBox.putClientProperty(LOADED_KEY, Boolean.TRUE);
        int n = 0;
        n = string != null ? EncodingsComboBoxModel.mav$indexOf(encodingsComboBoxModel, string) : (bl ? 0 : EncodingsComboBoxModel.mav$indexOf(encodingsComboBoxModel, Encodings.getDefaultEncoding()));
        jComboBox.setSelectedIndex(n);
    }

    private static synchronized void ensureInit() {
        if (_encodings == null) {
            SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
            TreeSet<String> treeSet = new TreeSet<String>(new CharsetComparator(null));
            for (Charset charset : sortedMap.values()) {
                treeSet.add(charset.name());
                Set<String> set = charset.aliases();
                treeSet.addAll(set);
            }
            String string = Encodings.getDefaultEncoding();
            if (treeSet.contains(string)) {
                treeSet.remove(string);
            }
            treeSet.add(string);
            EncodingsData encodingsData = Encodings.getEncodingsData();
            for (String string2 : encodingsData.getEncodingsList()) {
                if (treeSet.contains(string2)) continue;
                try {
                    ByteToCharConverter byteToCharConverter = ByteToCharConverter.getConverter((String)string2);
                    treeSet.add(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            _encodings = treeSet.toArray(new String[treeSet.size()]);
        }
    }

    private static synchronized EncodingsData getEncodingsData() {
        if (_data == null) {
            if (_encodingsFile != null) {
                try {
                    _data = new EncodingsData(_encodingsFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (_data == null) {
                _data = new EncodingsData();
            }
        }
        return _data;
    }

    static void maS$populateComboBox(JComboBox jComboBox, boolean bl, String string) {
        Encodings.populateComboBox(jComboBox, bl, string);
    }

    public static final class 2
    implements PopupMenuListener {
        private final /* synthetic */ JComboBox v$comboBox;
        private final /* synthetic */ boolean v$addDefaultItem;
        private final /* synthetic */ String v$curEncoding;

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            if (!Boolean.TRUE.equals(this.v$comboBox.getClientProperty(Encodings.LOADED_KEY))) {
                this.v$comboBox.removeAllItems();
                this.v$comboBox.addItem(IdeArb.getString(459));
                this.v$comboBox.setSelectedIndex(0);
                this.v$comboBox.removePopupMenuListener(this);
                Encodings.loadEncodings(this.v$comboBox, this.v$addDefaultItem, this.v$curEncoding);
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public 2(JComboBox jComboBox, boolean bl, String string) {
            this.v$curEncoding = string;
            this.v$addDefaultItem = bl;
            this.v$comboBox = jComboBox;
        }
    }

    public static final class 1
    extends SwingWorker {
        private String[] _encodings;
        private final /* synthetic */ JComboBox v$comboBox;
        private final /* synthetic */ boolean v$addDefaultItem;
        private final /* synthetic */ String v$selectedEncoding;

        public Object construct() {
            this._encodings = Encodings.getEncodings();
            return this._encodings;
        }

        public void finished() {
            if (this._encodings != null) {
                Encodings.maS$populateComboBox(this.v$comboBox, this.v$addDefaultItem, this.v$selectedEncoding);
            }
        }

        public 1(JComboBox jComboBox, boolean bl, String string) {
            this.v$selectedEncoding = string;
            this.v$addDefaultItem = bl;
            this.v$comboBox = jComboBox;
        }
    }

    private static class CharsetComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.compareToIgnoreCase(string2);
        }

        private CharsetComparator() {
        }

        CharsetComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class EncodingsComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private static final String DEF = "Default";
        private int _selection;
        private ArrayList _names;
        private Map _nameMap;

        private EncodingsComboBoxModel(String[] stringArray, boolean bl) {
            this._names = new ArrayList(bl ? stringArray.length + 1 : stringArray.length);
            this._nameMap = new HashMap();
            int n = 0;
            if (bl) {
                this._addElement(DEF, n++);
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                this._addElement(string, n++);
                ++n2;
            }
        }

        public void setSelectedItem(Object object) {
            String string;
            String string2;
            int n;
            if (object != null && (n = this._names.indexOf(string2 = (string = object.toString()).toUpperCase())) != this._selection) {
                this._selection = n;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.getElementAt(this._selection);
        }

        public int getSize() {
            return this._names.size();
        }

        public Object getElementAt(int n) {
            if (n == -1) {
                return null;
            }
            String string = this._names.get(n).toString();
            return this._nameMap.get(string);
        }

        private int indexOf(Object object) {
            if (object == null) {
                return -1;
            }
            return this._names.indexOf(object.toString().toUpperCase());
        }

        private void _addElement(String string, int n) {
            String string2 = string.toUpperCase();
            this._names.add(n, string2);
            this._nameMap.put(string2, string);
        }

        public void addElement(Object object) {
            this.insertElementAt(object, this.getSize());
        }

        private void _remove(int n) {
            if (n == this._selection) {
                this._selection = n == 0 ? (this.getSize() == 1 ? -1 : 0) : n - 1;
                this.fireContentsChanged(this, -1, -1);
            }
            this._names.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        public void removeElement(Object object) {
            String string = object.toString();
            String string2 = string.toUpperCase();
            if ((string = (String)this._nameMap.get(string2)) != null) {
                this._nameMap.remove(string2);
                int n = this._names.indexOf(string);
                this._remove(n);
            }
        }

        public void insertElementAt(Object object, int n) {
            String string = object.toString();
            if (!this._nameMap.containsKey(string.toUpperCase())) {
                this._addElement(string, n);
                this.fireIntervalAdded(this, n, n);
            }
        }

        public void removeElementAt(int n) {
            String string = (String)this._names.get(n);
            String string2 = string.toUpperCase();
            this._nameMap.remove(string2);
            this._remove(n);
        }

        EncodingsComboBoxModel(String[] stringArray, boolean bl, 1 var3_3) {
            this(stringArray, bl);
        }

        static int mav$indexOf(EncodingsComboBoxModel encodingsComboBoxModel, Object object) {
            return encodingsComboBoxModel.indexOf(object);
        }

        public final class 1 {
        }
    }
}

