/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.util.ModelUtil;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class EncodingsData {
    private ArrayList _encodingsList;
    private HashMap _jdk2iana;

    void $init$() {
        this._encodingsList = new ArrayList();
        this._jdk2iana = new HashMap();
    }

    public EncodingsData(File file) throws IOException {
        this.$init$();
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            try {
                dOMParser.parse((Reader)bufferedReader);
                this.processEncodings(dOMParser.getDocument().getDocumentElement());
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public EncodingsData() {
        this.$init$();
    }

    public List getEncodingsList() {
        return this._encodingsList;
    }

    public Map getJdk2IanaMap() {
        return this._jdk2iana;
    }

    private void processEncodings(Element element) {
        ChildIter childIter = new ChildIter(element);
        while (childIter.hasNext()) {
            Element element2 = childIter.nextElem();
            String string = element2.getTagName();
            if ("iana".equals(string)) {
                this.processIana(element2);
                continue;
            }
            if (!"sun-jdk".equals(string)) continue;
            this.processSunJdk(element2);
        }
    }

    private void processIana(Element element) {
        ChildIter childIter = new ChildIter(element);
        while (childIter.hasNext()) {
            Element element2 = childIter.nextElem();
            String string = element2.getTagName();
            if (!"cs".equals(string)) continue;
            this.processCs(element2);
        }
    }

    private void processCs(Element element) {
        this.addEncoding(element.getAttribute("name"));
        this.addEncoding(element.getAttribute("preferred-mime-name"));
        ChildIter childIter = new ChildIter(element);
        block0: while (childIter.hasNext()) {
            Element element2 = childIter.nextElem();
            String string = element2.getTagName();
            if (!"alias".equals(string)) continue;
            NodeList nodeList = element2.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string2;
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 3 && (string2 = node.getNodeValue()) != null) {
                    this.addEncoding(string2.toString());
                    continue block0;
                }
                ++n2;
            }
        }
    }

    private void addEncoding(String string) {
        if (ModelUtil.hasLength((String)string)) {
            this._encodingsList.add(string);
        }
    }

    private void processSunJdk(Element element) {
        ChildIter childIter = new ChildIter(element);
        while (childIter.hasNext()) {
            Element element2 = childIter.nextElem();
            String string = element2.getTagName();
            if (!"jdk2iana".equals(string)) continue;
            this.processJdk2Iana(element2);
        }
    }

    private void processJdk2Iana(Element element) {
        String string = element.getAttribute("jdk");
        String string2 = element.getAttribute("iana");
        if (ModelUtil.hasLength((String)string)) {
            this.addEncoding(string);
            if (ModelUtil.hasLength((String)string2)) {
                this._jdk2iana.put(string.toUpperCase(), string2);
            }
        }
    }

    private static class ChildIter {
        private final NodeList _nodes;
        private final int _n;
        private int _i;
        private Element _nextElem;

        ChildIter(Node node) {
            this._nodes = node.getChildNodes();
            this._n = this._nodes.getLength();
            this._i = 0;
        }

        public boolean hasNext() {
            this.seekNext();
            return this._nextElem != null;
        }

        public Element nextElem() {
            this.seekNext();
            Element element = this._nextElem;
            this._nextElem = null;
            return element;
        }

        private void seekNext() {
            if (this._nextElem == null) {
                while (this._i < this._n) {
                    Node node;
                    if ((node = this._nodes.item(this._i++)).getNodeType() != 1) continue;
                    this._nextElem = (Element)node;
                    return;
                }
            }
        }
    }
}

