/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import oracle.ide.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public final class ExecUtil {
    public static final boolean quoteExec = ExecUtil.canQuoteExecName();
    public static final boolean quoteArgs = ExecUtil.canQuoteArgs();
    public static final char argQuoteChar = ExecUtil.getArgQuoteChar();
    public static final String argQuoteString = ExecUtil.getArgQuoteString();

    private ExecUtil() {
    }

    private static boolean canQuoteExecName() {
        return PlatformUtils.isWindows();
    }

    private static boolean canQuoteArgs() {
        return PlatformUtils.isWindows();
    }

    private static char getArgQuoteChar() {
        return PlatformUtils.isWindows() ? (char)'\"' : ' ';
    }

    private static String getArgQuoteString() {
        return PlatformUtils.isWindows() ? "\"" : "";
    }

    private static String[] _makeNewStringArray(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = n + n2;
        String[] stringArray3 = new String[n3];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, n2);
        return stringArray3;
    }

    public static String[] getExecCommandArray(String[] stringArray) {
        if (PlatformUtils.isWindows()) {
            String[] stringArray2 = new String[]{"CMD.EXE", "/C", "START"};
            return ExecUtil._makeNewStringArray(stringArray2, stringArray);
        }
        return stringArray;
    }

    public static String[] cleanUpCommand(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (ModelUtil.hasLength((String)stringArray[n3])) {
                stringArray2[n2++] = stringArray[n3];
            }
            ++n3;
        }
        if (n2 < n) {
            String[] stringArray3 = new String[n2];
            System.arraycopy(stringArray2, 0, stringArray3, 0, n2);
            stringArray2 = stringArray3;
        }
        return stringArray2;
    }

    public static String adjustArgument(String string) {
        String string2 = string;
        if (!PlatformUtils.isWindows()) {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string2 = string.substring(1, string.length() - 1);
            }
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < string2.length()) {
                char c = string2.charAt(n);
                if (c == '\\' && ++n < string2.length()) {
                    c = string2.charAt(n);
                }
                stringBuffer.append(c);
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }
}

