/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public final class FastStringBuffer {
    private static char[] logicalLiteral = new char[]{'\r', '\n', '\t', '\'', '\\'};
    private static char[] displayLiteral = new char[]{'r', 'n', 't', '\'', '\\'};
    public static final int NOTACHAR = 0;
    public static final int NOT_A_CHAR = 0;
    private char[] value;
    private int count;
    private int offset;
    static final String needingEscape = "\b\t\n\f\r\"\\";
    private static final int SUGGESTED_MAX_SOURCE_COLS = 64;
    private static final int ABSOLUTE_MAX_SOURCE_COLS = 100;

    public FastStringBuffer() {
        this(16);
    }

    public FastStringBuffer(int n) {
        this.value = new char[n];
        this.offset = 0;
        this.count = 0;
    }

    public FastStringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
        this.offset = 0;
        this.count = string.length();
    }

    public FastStringBuffer(char[] cArray) {
        this(cArray.length + 16);
        this.append(cArray);
        this.offset = 0;
        this.count = cArray.length;
    }

    public FastStringBuffer(char[] cArray, int n, int n2) {
        this(n2 + 16);
        this.append(cArray, n, n2);
        n = 0;
        this.count = n2;
    }

    public FastStringBuffer(char c, int n) {
        this(n);
        int n2 = 0;
        while (n2 < n) {
            this.value[n2] = c;
            ++n2;
        }
        this.count = n;
    }

    public void empty() {
        int n = 0;
        while (n < this.count) {
            this.value[n] = '\u0000';
            ++n;
        }
        this.count = 0;
        this.offset = 0;
    }

    public char[] value() {
        return this.value;
    }

    public char[] getValue() {
        return this.value;
    }

    public int length() {
        return this.count;
    }

    public int getLength() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public int offset() {
        return this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public void makeroom(int n) {
        int n2 = this.value.length;
        if (n > n2) {
            int n3 = (n2 + 1) * 2;
            if (n > n3) {
                n3 = n;
            }
            char[] cArray = new char[n3];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.makeroom(n);
        if (this.count < n) {
            while (this.count < n) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        }
        this.count = n;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.offset = n;
        return this.value[n];
    }

    public char firstChar() {
        if (this.count <= 0) {
            return '\u0000';
        }
        this.offset = 0;
        return this.value[0];
    }

    public char lastChar() {
        if (this.count <= 0) {
            return '\u0000';
        }
        this.offset = this.count - 1;
        return this.value[this.offset];
    }

    public char currentChar() {
        if (this.offset < 0 || this.offset >= this.count) {
            return '\u0000';
        }
        return this.value[this.offset];
    }

    public char nextChar() {
        if (this.offset < -1 || this.offset >= this.count - 1) {
            return '\u0000';
        }
        return this.value[++this.offset];
    }

    public char priorChar() {
        if (this.offset < 1 || this.offset > this.count) {
            return '\u0000';
        }
        return this.value[--this.offset];
    }

    public char peekNextChar() {
        if (this.offset < -1 || this.offset >= this.count - 1) {
            return '\u0000';
        }
        return this.value[this.offset + 1];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        if (n < n2) {
            System.arraycopy(this.value, n, cArray, n3, n2 - n);
        }
    }

    public char[] getChars() {
        char[] cArray = new char[this.count];
        System.arraycopy(this.value, 0, cArray, 0, this.count);
        return cArray;
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = c;
    }

    public void removeCharAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = this.count - n - 1;
        if (n < this.count - 1 && n2 > 0) {
            System.arraycopy(this.value, n + 1, this.value, n, n2);
        }
        this.offset = n - 1;
        --this.count;
    }

    public void removeChar() {
        this.removeCharAt(this.offset);
    }

    public void removeCharsAt(int n, int n2) {
        if (n < 0 || n + n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n < this.count - n2) {
            System.arraycopy(this.value, n + n2, this.value, n, this.count - n - n2);
        }
        this.offset = n - n2;
        this.count -= n2;
    }

    public void removeChars(int n) {
        this.removeCharsAt(this.offset, n);
    }

    public void replaceCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.value[n] = c;
    }

    public FastStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public FastStringBuffer append(char c) {
        this.makeroom(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public FastStringBuffer append(char c, int n) {
        this.makeroom(this.count + n);
        int n2 = 0;
        while (n2 < n) {
            this.value[this.count++] = c;
            ++n2;
        }
        return this;
    }

    public FastStringBuffer append(String string) {
        if (string == null) {
            string = String.valueOf(string);
        }
        int n = string.length();
        this.makeroom(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public FastStringBuffer append(FastStringBuffer fastStringBuffer) {
        if (fastStringBuffer == null) {
            return this;
        }
        int n = fastStringBuffer.count;
        this.makeroom(this.count + n);
        fastStringBuffer.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    public FastStringBuffer append(char[] cArray) {
        int n = cArray.length;
        this.makeroom(this.count + n);
        System.arraycopy(cArray, 0, this.value, this.count, n);
        this.count += n;
        return this;
    }

    public FastStringBuffer append(char[] cArray, int n, int n2) {
        this.makeroom(this.count + n2);
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public FastStringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public FastStringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = string.length();
        this.makeroom(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public FastStringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        this.makeroom(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        System.arraycopy(cArray, 0, this.value, n, n2);
        this.count += n2;
        return this;
    }

    public FastStringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public FastStringBuffer insert(int n, char c) {
        this.makeroom(this.count + 1);
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public int IndexOfSubString(FastStringBuffer fastStringBuffer, int n) {
        return this.indexOf(fastStringBuffer, n);
    }

    public int indexOf(FastStringBuffer fastStringBuffer, int n) {
        char[] cArray = this.value;
        char[] cArray2 = fastStringBuffer.value();
        int n2 = this.count - fastStringBuffer.length();
        int n3 = n < 0 ? 0 : n;
        while (n3 <= n2) {
            block3: {
                int n4 = fastStringBuffer.length();
                int n5 = n3;
                int n6 = 0;
                while (n4-- != 0) {
                    if (cArray[n5++] == cArray2[n6++]) {
                        continue;
                    }
                    break block3;
                }
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOf(FastStringBuffer fastStringBuffer, int n) {
        char[] cArray = this.value;
        char[] cArray2 = fastStringBuffer.value();
        int n2 = this.count - fastStringBuffer.length();
        int n3 = n;
        while (n3 >= 0) {
            block3: {
                int n4 = fastStringBuffer.length();
                int n5 = n3;
                int n6 = 0;
                while (n4-- != 0) {
                    if (cArray[n5++] == cArray2[n6++]) {
                        continue;
                    }
                    break block3;
                }
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public FastStringBuffer substring(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.count) {
            n2 = this.count - 1;
        }
        FastStringBuffer fastStringBuffer = n >= n2 ? new FastStringBuffer() : new FastStringBuffer(this.value, n, n2 - n);
        return fastStringBuffer;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public char parseBackSlash() {
        int n;
        int n2;
        char c = this.nextChar();
        char c2 = FastStringBuffer.displayToLiteral(c);
        if (c2 != '\u0000') {
            return c2;
        }
        switch (c) {
            case 'U': 
            case 'u': {
                n2 = 16;
                n = 4;
                break;
            }
            case '0': {
                n2 = 8;
                n = 3;
                c = this.peekNextChar();
                if (c == 'x' || c == 'X') {
                    n2 = 16;
                    n = 2;
                    ++this.offset;
                    break;
                }
                this.priorChar();
                break;
            }
            default: {
                return c;
            }
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
        int n3 = 0;
        while (n3 < n) {
            c = Character.toUpperCase(this.nextChar());
            if (!Character.isDigit(c) && (n2 == 8 && c > '7' || n2 == 16 && (c < 'A' || c > 'F'))) {
                this.priorChar();
                break;
            }
            fastStringBuffer.append(c);
            ++n3;
        }
        return (char)Integer.parseInt(fastStringBuffer.toString(), n2);
    }

    public FastStringBuffer parseLiteral(char c, boolean bl) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        char c2 = this.nextChar();
        while (c2 != '\u0000') {
            if (c2 == c) {
                if (!bl || this.peekNextChar() != c2) break;
                fastStringBuffer.append(c2);
                this.nextChar();
            } else {
                if (c2 == '\\') {
                    c2 = this.parseBackSlash();
                }
                fastStringBuffer.append(c2);
            }
            c2 = this.nextChar();
        }
        return fastStringBuffer;
    }

    public FastStringBuffer parseLiteral() {
        return this.parseLiteral(this.currentChar(), false);
    }

    public static FastStringBuffer expandDelimiters(String string, String string2) {
        int n = string == null ? 0 : string.length();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) >= 0) {
                fastStringBuffer.append(FastStringBuffer.charToUnicodeEscape(c));
            } else {
                fastStringBuffer.append(c);
            }
            ++n2;
        }
        return fastStringBuffer;
    }

    /*
     * Unable to fully structure code
     */
    public FastStringBuffer normalizeDelimiters(String var1_1) {
        var2_2 = new FastStringBuffer(this.count);
        var4_3 = this.firstChar();
        while (var4_3 != '\u0000') {
            if (var4_3 != '\\') ** GOTO lbl19
            var3_4 = this.offset;
            var5_5 = this.parseBackSlash();
            if (var1_1.indexOf(var5_5) >= 0) {
                var6_6 = FastStringBuffer.literalToDisplay(var5_5);
                if (var6_6 != '\u0000') {
                    var2_2.append('\\');
                    var2_2.append(var6_6);
                } else {
                    var2_2.append(var5_5);
                }
            } else {
                this.offset = var3_4;
lbl19:
                // 2 sources

                var2_2.append(var4_3);
            }
            var4_3 = this.nextChar();
        }
        return var2_2;
    }

    public static String charToUnicodeEscape(char c) {
        char[] cArray = new char[]{'\\', 'u', Hex.chars[c >> 12 & 0xF], Hex.chars[c >> 8 & 0xF], Hex.chars[c >> 4 & 0xF], Hex.chars[c & 0xF]};
        return new String(cArray, 0, 6);
    }

    private static char displayToLiteral(char c) {
        int n = 0;
        while (n < displayLiteral.length) {
            if (c == displayLiteral[n]) {
                return logicalLiteral[n];
            }
            ++n;
        }
        return '\u0000';
    }

    private static char literalToDisplay(char c) {
        int n = 0;
        while (n < logicalLiteral.length) {
            if (c == logicalLiteral[n]) {
                return displayLiteral[n];
            }
            ++n;
        }
        return '\u0000';
    }

    public static char charFromString(String string) {
        char c = '\u0000';
        if (string != null && string.length() >= 0) {
            if (string.length() == 1) {
                c = string.charAt(0);
            } else {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(string);
                c = fastStringBuffer.firstChar();
                if (c == '\\') {
                    c = fastStringBuffer.parseBackSlash();
                }
            }
        }
        return c;
    }

    public static String stringFromChar(char c) {
        char c2 = FastStringBuffer.literalToDisplay(c);
        String string = c2 != '\u0000' ? "\\" + c2 : (c < ' ' ? FastStringBuffer.charToUnicodeEscape(c) : new String(new char[]{c}));
        return string;
    }

    public static FastStringBuffer sourceToText(String string) {
        int n;
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(string);
        if (fastStringBuffer2.charAt(0) == '\"') {
            fastStringBuffer2.removeCharAt(0);
        }
        if ((n = fastStringBuffer2.length()) > 0 && fastStringBuffer2.charAt(n - 1) == '\"') {
            fastStringBuffer2.removeCharAt(n - 1);
        }
        char c = fastStringBuffer2.firstChar();
        while (c != '\u0000') {
            if (c == '\\') {
                c = fastStringBuffer2.parseBackSlash();
            }
            fastStringBuffer.append(c);
            c = fastStringBuffer2.nextChar();
        }
        return fastStringBuffer;
    }

    public static FastStringBuffer textToSource(String string, boolean bl) {
        return FastStringBuffer.textToSource(string, bl, "    ");
    }

    /*
     * Unable to fully structure code
     */
    public static FastStringBuffer textToSource(String var0, boolean var1_1, String var2_2) {
        var3_3 = new FastStringBuffer(var0.length() * 2 + 2);
        var3_3.append("\"");
        var4_4 = 0;
        var5_5 = 0;
        while (var5_5 < var0.length()) {
            var6_6 = var0.charAt(var5_5);
            if (var6_6 != '\\' || !var1_1 || var5_5 + 2 >= var0.length()) ** GOTO lbl-1000
            var7_7 = var0.charAt(var5_5 + 2);
            switch (var0.charAt(var5_5 + 1)) {
                case '0': {
                    if ((var7_7 == 'x' || var7_7 == 'X') && var5_5 + 3 < var0.length()) {
                        var7_7 = var0.charAt(var5_5 + 3);
                    }
                }
                case 'U': 
                case 'u': {
                    if (var7_7 >= '0' && var7_7 <= '9') {
                        var3_3.append(var6_6);
                        break;
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    if ("\b\t\n\f\r\"\\".indexOf(var6_6) < 0) ** GOTO lbl56
                    var3_3.append("\\");
                    switch (var6_6) {
                        case '\b': {
                            var3_3.append('b');
                            break;
                        }
                        case '\t': {
                            var3_3.append('t');
                            break;
                        }
                        case '\n': {
                            var3_3.append('n');
                            break;
                        }
                        case '\f': {
                            var3_3.append('f');
                            break;
                        }
                        case '\r': {
                            var3_3.append('r');
                            break;
                        }
                        case '\\': {
                            var3_3.append('\\');
                            if (var1_1 && var5_5 + 1 < var0.length() && var0.charAt(var5_5 + 1) == '\\') {
                                var3_3.append(var0.charAt(++var5_5));
                                break;
                            }
                            ** GOTO lbl58
                        }
                        default: {
                            var3_3.append(FastStringBuffer.stringFromChar(var6_6));
                        }
                    }
                    ** GOTO lbl58
lbl56:
                    // 1 sources

                    var3_3.append(FastStringBuffer.stringFromChar(var6_6));
lbl58:
                    // 3 sources

                    if (var5_5 >= var0.length() - 1 || ++var4_4 <= 64 || (!(var8_8 = Character.isWhitespace(var6_6)) || var4_4 <= 64) && var4_4 <= 100) break;
                    var3_3.append("\" +\n");
                    var3_3.append(var2_2);
                    var3_3.append("\"");
                    var4_4 = 0;
                }
            }
            ++var5_5;
        }
        var3_3.append("\"");
        return var3_3;
    }

    public static class Hex {
        public static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        public static final byte[] bytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

        Hex() {
        }
    }
}

