/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import oracle.ide.util.FastStringBuffer;
import sun.security.action.GetPropertyAction;

public class FastStringWriter
extends PrintWriter {
    private FastStringBuffer buf;
    private String lineSeparator;

    public FastStringWriter() {
        super(System.out, true);
        this.out = this;
        this.buf = new FastStringBuffer();
        this.lock = null;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public FastStringWriter(int n) {
        super(System.out, true);
        this.out = this;
        this.buf = new FastStringBuffer(n);
        this.lock = null;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public void write(int n) {
        this.buf.append((char)n);
    }

    public void write(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.buf.append(cArray, n, n2);
    }

    public void write(String string) {
        this.buf.append(string);
    }

    public void write(String string, int n, int n2) {
        this.buf.append(string.substring(n, n + n2));
    }

    public String toString() {
        return this.buf.toString();
    }

    public FastStringBuffer getBuffer() {
        return this.buf;
    }

    public void flush() {
    }

    public void close() {
    }

    private void newLine() throws IOException {
        this.out.write(this.lineSeparator);
        this.out.flush();
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(int n) {
        this.write(String.valueOf(n));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        try {
            this.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(int n) {
        this.print(n);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void println(Object object) {
        this.print(object);
        this.println();
    }
}

