/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.ide.resource.UtilArb;

public final class FileCopyUtil {
    private FileCopyUtil() {
    }

    public static void copyFile(File file, File file2) throws IOException {
        block19: {
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            long l = file.lastModified();
            long l2 = file2.lastModified();
            try {
                try {
                    int n;
                    if (l <= l2) break block19;
                    FileCopyUtil.ensureParent(file2);
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                    byte[] byArray = new byte[4096];
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    file2 = null;
                    throw iOException;
                }
                catch (Exception exception) {
                    file2 = null;
                    throw new IOException(UtilArb.format(0, file.getName()));
                }
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
                if (file2 != null) {
                    file2.setLastModified(l);
                }
            }
        }
    }

    private static void ensureParent(File file) throws IOException {
        File file2;
        String string = file.getParent();
        if (string != null && (file2 = new File(string)) != null && !file2.exists()) {
            file2.mkdirs();
        }
    }
}

