/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class FilePath {
    public static final int LOADING = 1;
    public static final int SAVING = 2;

    public static final boolean isAbsolute(String string) {
        return new File(string).isAbsolute();
    }

    public static final String makeQualified(String string, String string2) {
        String string3 = null;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            string3 = "";
        } else {
            File file;
            String string4 = null;
            if (string2.startsWith("[") && string2.indexOf("]") > 0) {
                string4 = string2;
                string2 = string2.substring(1, string2.indexOf("]"));
            }
            if ((file = new File(string2)).isAbsolute()) {
                try {
                    string2 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string3 = string2;
            }
            if (string3 == null) {
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                try {
                    string3 = new File(string + string2).getCanonicalPath();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    string3 = string + string2;
                }
            }
            if (string4 != null) {
                string3 = "[" + string3 + string4.substring(string4.indexOf("]"));
            }
        }
        return string3;
    }

    public static final String makeRelative(String string, String string2) {
        return FilePath.makeRelative(string, string2, false);
    }

    public static final String makeRelative(String string, String string2, boolean bl) {
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return "";
        }
        String string3 = string2;
        String string4 = null;
        if (string3.startsWith("[") && string3.indexOf("]") > 0) {
            string4 = string3;
            string3 = string3.substring(1, string3.indexOf("]"));
        }
        if (!FilePath.isAbsolute(string3)) {
            return string2;
        }
        try {
            string = new File(string.trim()).getCanonicalPath();
            string3 = new File(string3.trim()).getCanonicalPath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.equals(string3)) {
            string3 = "." + File.separator;
        } else if (!bl || string3.startsWith(string)) {
            int n = string3.length();
            if (n == 0) {
                string3 = "";
            } else {
                String string5;
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                if (string.equals(string5 = string3.substring(0, n = Math.min(string3.length(), string.length())))) {
                    string3 = string3.substring(string.length(), string3.length());
                } else {
                    String string6 = "";
                    String string7 = string;
                    while (string7.length() > 2) {
                        n = Math.min(string3.length(), string7.length());
                        if (string7.equals(string3.substring(0, n))) {
                            StringBuffer stringBuffer = new StringBuffer(string3.substring(string7.length()));
                            if (stringBuffer.charAt(0) != File.separatorChar) {
                                stringBuffer.insert(0, File.separator);
                            }
                            stringBuffer.insert(0, string6);
                            string3 = stringBuffer.toString();
                            break;
                        }
                        if (string7.endsWith(File.separator)) {
                            string7 = string7.substring(0, string7.length() - 1);
                        }
                        if ((string7 = FilePath.getParent(string7)) == null) break;
                        string6 = string6.length() > 0 ? string6 + File.separator + ".." : string6 + "..";
                    }
                }
            }
        }
        if (string4 != null) {
            string3 = "[" + string3 + string4.substring(string4.indexOf("]"));
        }
        return string3;
    }

    public static String makePathQualified(String string, String string2) {
        String string3 = null;
        if (string2 != null) {
            if (string2.indexOf(File.pathSeparator) < 0) {
                string3 = string2.length() == 0 ? string2 : FilePath.makeQualified(string, string2);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
                String string4 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    if (string4.length() == 0) {
                        stringBuffer.append(string4);
                    } else {
                        stringBuffer.append(FilePath.makeQualified(string, string4));
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer.append(File.pathSeparator);
                        string4 = stringTokenizer.nextToken();
                        if (string4.length() == 0 || FilePath.isAbsolute(string4)) {
                            stringBuffer.append(string4);
                            continue;
                        }
                        stringBuffer.append(FilePath.makeQualified(string, string4));
                    }
                }
                string3 = stringBuffer.toString();
            }
        }
        return string3;
    }

    public static String makePathRelative(String string, String string2) {
        return FilePath.makePathRelative(string, string2, false);
    }

    public static String makePathRelative(String string, String string2, boolean bl) {
        String string3 = null;
        if (string2 != null) {
            if (string2.indexOf(File.pathSeparatorChar) < 0) {
                string3 = FilePath.makeRelative(string, string2, bl);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
                if (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(FilePath.makeRelative(string, stringTokenizer.nextToken(), bl));
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer.append(File.pathSeparator);
                        stringBuffer.append(FilePath.makeRelative(string, stringTokenizer.nextToken(), bl));
                    }
                }
                string3 = stringBuffer.toString();
            }
        }
        return string3;
    }

    public static final String getParent(String string) {
        return new File(string).getParent();
    }

    public static final String getFilename(String string) {
        return new File(string).getName();
    }

    public static final String getExtension(String string) {
        String string2 = FilePath.getFilename(string);
        int n = Math.min(string2.lastIndexOf("."), string2.length());
        if (n < 0) {
            return "";
        }
        return string2.substring(n, string2.length());
    }

    public static final String getName(String string) {
        String string2 = FilePath.getFilename(string);
        int n = Math.min(string2.lastIndexOf("."), string2.length());
        if (n < 0) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public static final boolean mayBeADirectory(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            return true;
        }
        if (file.exists()) {
            return false;
        }
        return FilePath.getExtension(file.getAbsolutePath()).length() == 0;
    }

    public static final String convertPath(String string, int n) {
        if (File.pathSeparatorChar == ';' && File.separatorChar == '\\') {
            return string;
        }
        if (n == 1) {
            string = string.replace(';', File.pathSeparatorChar);
            string = string.replace('\\', File.separatorChar);
        } else if (n == 2) {
            string = string.replace(File.pathSeparatorChar, ';');
            string = string.replace(File.separatorChar, '\\');
        } else {
            throw new IllegalArgumentException("direction must be 1 or 2");
        }
        return string;
    }

    public static final String getBasePath(String string, String string2) {
        String string3 = FilePath.makeQualified(string, string2);
        int n = string3.indexOf(string2);
        if (n < 0) {
            return null;
        }
        return string3.substring(0, n - 1);
    }
}

