/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public final class GraphicsUtils
extends oracle.javatools.util.GraphicsUtils {
    private static final Insets HIGHLIGHT_INSETS = new Insets(1, 1, 1, 1);
    protected static final Component component = new 1();
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static Hashtable imageCache = new Hashtable();
    private static final String[] m_ImageExtensions = new File("A").equals(new File("a")) ? new String[]{".gif", ".jpg", ".jpeg", ".png"} : new String[]{".gif", ".GIF", ".jpg", ".JPG", ".jpeg", ".JPEG", ".png", ".PNG"};

    private GraphicsUtils() {
    }

    public static void drawHighlightBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.translate(n, n2);
        graphics.setColor(bl ? color2 : color);
        graphics.drawLine(0, 0, n3 - 2, 0);
        graphics.drawLine(0, 1, 0, n4 - 2);
        graphics.setColor(bl ? color : color2);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 2, n4 - 1);
        graphics.translate(-n, -n2);
        graphics.setColor(color3);
    }

    public static Insets getHighlightBorderInsets() {
        return HIGHLIGHT_INSETS;
    }

    public static ImageIcon createImageIcon(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return GraphicsUtils.createImageIcon(Toolkit.getDefaultToolkit().createImage(uRL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon createImageIcon(Image image) {
        if (image == null) {
            return null;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, 0);
        }
        return new ImageIcon(image);
    }

    public static Point getPopupMenuShowPoint(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        Point point = component.getLocationOnScreen();
        Point point2 = GraphicsUtils.getPopupMenuShowPoint(jPopupMenu, point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
        point2.translate(-point.x, -point.y);
        return point2;
    }

    public static Point getPopupMenuShowPoint(JPopupMenu jPopupMenu, int n, int n2) {
        Dimension dimension = jPopupMenu.getPreferredSize();
        Point point = new Point(n + dimension.width, n2 + dimension.height);
        Rectangle[] rectangleArray = GraphicsUtils.getScreenBounds();
        int n3 = rectangleArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Rectangle rectangle = rectangleArray[n4];
            if (rectangle.x <= n && n <= rectangle.x + rectangle.width) {
                Dimension dimension2 = rectangle.getSize();
                dimension2.height -= 32;
                int n5 = 0;
                if (point.x > rectangle.x + dimension2.width) {
                    n5 = -dimension.width;
                }
                int n6 = 0;
                if (point.y > rectangle.y + dimension2.height) {
                    n6 = dimension2.height - point.y;
                }
                return new Point(n + n5, n2 + n6);
            }
            ++n4;
        }
        return new Point(n, n2);
    }

    public static void centerWindowOnComponent(Window window, Component component) {
        if (component == null || !component.isShowing()) {
            GraphicsUtils.centerWindowOnScreen((Window)window);
            return;
        }
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        Dimension dimension2 = window.getSize();
        int n = point.x + (dimension.width - dimension2.width) / 2;
        int n2 = point.y + (dimension.height - dimension2.height) / 2;
        Rectangle[] rectangleArray = GraphicsUtils.getScreenBounds();
        Point point2 = new Point(n + dimension2.width, n2 + dimension2.height);
        int n3 = 0;
        while (n3 < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n3];
            if (rectangle.contains(point2)) {
                if (n + dimension2.width > rectangle.width) {
                    n = rectangle.width - dimension2.width;
                }
                if (n < rectangle.x) {
                    n = rectangle.x;
                }
                if (n2 + dimension2.height > rectangle.height) {
                    n2 = rectangle.height - dimension2.height;
                }
                if (n2 >= rectangle.y) break;
                n2 = rectangle.y;
                break;
            }
            ++n3;
        }
        window.setLocation(n, n2);
    }

    public static boolean isAncestorOfFocusedComponent(Component component) {
        Component component2 = GraphicsUtils.getFocusedChildComponent(component);
        return component2 != null;
    }

    public static Component getFocusedChildComponent(Component component) {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component2 = keyboardFocusManager.getPermanentFocusOwner();
        if (component2 != null && SwingUtilities.isDescendingFrom(component2, component)) {
            return component2;
        }
        return null;
    }

    public static Component getFocusableComponentOrChild(Component component) {
        return GraphicsUtils.getFocusableComponentOrChild(component, false);
    }

    public static JComponent getFocusableComponentOrChild(Component component, boolean bl) {
        if (component != null && component.isEnabled() && component.isVisible() && component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (!bl && jComponent.isFocusable() && jComponent.isRequestFocusEnabled() && !jComponent.getClass().getName().equals("javax.swing.JPanel")) {
                return jComponent;
            }
            int n = jComponent.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component2 = jComponent.getComponent(n2);
                JComponent jComponent2 = GraphicsUtils.getFocusableComponentOrChild(component2, bl);
                if (jComponent2 != null) {
                    return jComponent2;
                }
                ++n2;
            }
            if (bl && jComponent.isFocusable() && jComponent.isRequestFocusEnabled() && !jComponent.getClass().getName().equals("javax.swing.JPanel")) {
                return jComponent;
            }
        }
        return null;
    }

    public static Component focusComponentOrChild(Component component) {
        return GraphicsUtils.focusComponentOrChild(component, false);
    }

    public static JComponent focusComponentOrChild(Component component, boolean bl) {
        JComponent jComponent = null;
        JComponent jComponent2 = GraphicsUtils.getFocusableComponentOrChild(component, bl);
        if (jComponent2 != null && jComponent2.requestFocusInWindow()) {
            jComponent = jComponent2;
        }
        return jComponent;
    }

    public static Image loadFromResource(String string, Class clazz) {
        try {
            URL uRL = clazz.getResource(string);
            if (uRL == null) {
                Image image = null;
                return image;
            }
            Image image = (Image)imageCache.get(uRL.toString());
            if (image == null) {
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                imageCache.put(uRL.toString(), image);
            }
            Image image2 = image;
            return image2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Rectangle[] getScreenBounds() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle[] rectangleArray = new Rectangle[graphicsDeviceArray.length];
        int n = 0;
        while (n < graphicsDeviceArray.length) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n];
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.width -= Math.abs(insets.left + insets.right);
            rectangle.height -= Math.abs(insets.top + insets.bottom);
            rectangle.x += Math.abs(insets.left);
            rectangle.y += Math.abs(insets.top);
            rectangleArray[n] = rectangle;
            ++n;
        }
        return rectangleArray;
    }

    public static String[] getImageExtensions() {
        return m_ImageExtensions;
    }

    public static final class 1
    extends Component {
    }
}

