/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.ide.util.PropertyAccess;

public class HistoryList {
    private String name;
    private LinkedList items;
    private int maxHistorySize;
    private PropertyAccess properties;
    private static final int defaultMaxHistorySize = 32;
    private static String KEY_SUFFIX_COUNT = "HistoryCount";
    private static String KEY_SUFFIX_ITEM = "HistoryItem";

    public HistoryList(String string) {
        this(string, null);
    }

    public HistoryList(String string, PropertyAccess propertyAccess) {
        this.name = string;
        this.items = new LinkedList();
        this.maxHistorySize = 32;
        if (propertyAccess != null) {
            this.load(propertyAccess);
        }
    }

    public synchronized int getMaxHistorySize() {
        return this.maxHistorySize;
    }

    public synchronized void setMaxHistorySize(int n) {
        this.maxHistorySize = n;
        while (this.items.size() > n) {
            this.items.removeLast();
        }
    }

    public synchronized void load(PropertyAccess propertyAccess) {
        this.properties = propertyAccess;
        try {
            String string = propertyAccess.getProperty(this.name + KEY_SUFFIX_COUNT, null);
            int n = Integer.parseInt(string);
            int n2 = 0;
            while (n2 < n) {
                string = propertyAccess.getProperty(this.name + KEY_SUFFIX_ITEM + n2, null);
                if (string != null) {
                    this.items.add(string);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void clear() {
        this.items.clear();
    }

    public synchronized String[] getHistory() {
        return this.items.toArray(new String[this.items.size()]);
    }

    public int getSize() {
        return this.items.size();
    }

    public void fill(String[] stringArray) {
        if (this.items.size() == 0) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.items.add(stringArray[n2]);
                ++n2;
            }
        } else {
            int n = stringArray.length;
            while (n >= 0) {
                this.update(stringArray[n]);
                --n;
            }
        }
    }

    public synchronized void update(String string) {
        int n = this.items.indexOf(string);
        if (n == -1) {
            this.items.add(0, string);
            int n2 = this.items.size();
            if (n2 > this.maxHistorySize) {
                this.items.remove(n2 - 1);
            }
        } else {
            this.items.remove(n);
            this.items.add(0, string);
        }
    }

    public synchronized boolean remove(String string) {
        return this.items.remove(string);
    }

    public synchronized void save() {
        this.saveAs(this.properties);
    }

    public synchronized void saveAs(PropertyAccess propertyAccess) {
        this.properties = propertyAccess;
        int n = this.items.size();
        propertyAccess.setProperty(this.name + KEY_SUFFIX_COUNT, Integer.toString(n));
        int n2 = 0;
        while (n2 < n) {
            propertyAccess.setProperty(this.name + KEY_SUFFIX_ITEM + n2, (String)this.items.get(n2));
            ++n2;
        }
        int n3 = n;
        while (n3 < this.maxHistorySize) {
            propertyAccess.removeProperty(this.name + KEY_SUFFIX_ITEM + n3);
            ++n3;
        }
    }

    public String comboBoxGetSelectedItem(JComboBox jComboBox) {
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        return this.comboBoxGetSelectedItem(jTextField);
    }

    public String comboBoxGetSelectedItem(JTextField jTextField) {
        String string = jTextField.getText();
        this.updateHistory(string);
        return string;
    }

    public void updateHistory(String string) {
        this.update(string);
        this.save();
    }
}

