/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public final class IdeProfile {
    public static int PROF_FIRST;
    public static final int PROF_GENERIC;
    public static final int PROF_STARTUP;
    public static final int PROF_LOAD_ADDINS;
    public static final int PROF_INIT_ADDINS;
    public static final int PROF_KEYPRESSED;
    public static final int PROF_DOCK_LAYOUT;
    public static final int PROF_NOTIFY_OBSERVERS;
    public static final int PROF_JOT_FIRST = 3000;
    public static final int PROF_JOT_LAST = 3099;
    public static final int PROF_CMT_FIRST = 3100;
    public static final int PROF_CMT_LAST = 3199;
    public static final int PROF_IDE_FIRST = 3200;
    public static final int PROF_IDE_LAST = 3299;
    public static final int PROF_IDEIMPL_FIRST = 3300;
    public static final int PROF_IDEIMPL_LAST = 3399;
    public static final int PROF_JDEVELOPER_FIRST = 3400;
    public static final int PROF_JDEVELOPER_LAST = 3499;
    public static final int PROF_JDEVIMPL_FIRST = 3500;
    public static final int PROF_JDEVIMPL_LAST = 3599;
    public static final int PROF_EJB_FIRST = 3600;
    public static final int PROF_EJB_LAST = 3699;
    public static final int PROF_DEBUGGER_FIRST = 3700;
    public static final int PROF_DEBUGGER_LAST = 3799;
    public static final int PROF_PERSISTENCE_FIRST = 3800;
    public static final int PROF_PERSISTENCE_LAST = 3899;
    public static final int PROF_REFACTORING_FIRST = 3900;
    public static final int PROF_REFACTORING_LAST = 3999;
    private static Class _profilerApiClass;
    private static boolean _isInitialized;
    private static boolean _canRun;
    private static Field _isActiveField;
    private static Method _isEventActive_int;
    private static Method _startEvent_int_String;
    private static Method _startEvent_int;
    private static Method _endEvent_int_String;
    private static Method _endEvent_int;
    private static Method _pulseEvent_int_String;
    private static Method _startSampling;
    private static Method _stopSampling;

    static {
        PROF_GENERIC = PROF_FIRST = 100;
        PROF_STARTUP = PROF_FIRST + 1;
        PROF_LOAD_ADDINS = PROF_FIRST + 2;
        PROF_INIT_ADDINS = PROF_FIRST + 3;
        PROF_KEYPRESSED = PROF_FIRST + 4;
        PROF_DOCK_LAYOUT = PROF_FIRST + 5;
        PROF_NOTIFY_OBSERVERS = PROF_FIRST + 6;
    }

    private static boolean canRun() {
        if (!_isInitialized) {
            _isInitialized = true;
            try {
                String string = System.getProperty("user.dir", ".").trim();
                File file = new File(string);
                File file2 = new File(file.getParentFile(), "lib/jdev-rt.jar");
                URL uRL = file2.toURL();
                URL[] uRLArray = new URL[]{uRL};
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                _profilerApiClass = uRLClassLoader.loadClass("oracle.jdeveloper.profiler.ProfilerAPI");
                _isActiveField = _profilerApiClass.getDeclaredField("isActive");
                _isEventActive_int = _profilerApiClass.getDeclaredMethod("isEventActive", Integer.TYPE);
                _startEvent_int_String = _profilerApiClass.getDeclaredMethod("startEvent", Integer.TYPE, String.class);
                _startEvent_int = _profilerApiClass.getDeclaredMethod("startEvent", Integer.TYPE);
                _endEvent_int_String = _profilerApiClass.getDeclaredMethod("endEvent", Integer.TYPE, String.class);
                _endEvent_int = _profilerApiClass.getDeclaredMethod("endEvent", Integer.TYPE);
                _pulseEvent_int_String = _profilerApiClass.getDeclaredMethod("pulseEvent", Integer.TYPE, String.class);
                _startSampling = _profilerApiClass.getDeclaredMethod("startSampling", new Class[0]);
                _stopSampling = _profilerApiClass.getDeclaredMethod("stopSampling", new Class[0]);
                _canRun = _isActiveField.getBoolean(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _canRun;
    }

    public static boolean isActive() {
        boolean bl = false;
        if (IdeProfile.canRun()) {
            try {
                bl = _isActiveField.getBoolean(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return bl;
    }

    public static boolean isEventActive(int n) {
        boolean bl = false;
        if (IdeProfile.canRun()) {
            try {
                Boolean bl2 = (Boolean)_isEventActive_int.invoke(null, new Integer(n));
                bl = bl2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static int startEvent(int n, String string) {
        int n2 = -1;
        if (IdeProfile.canRun()) {
            try {
                Integer n3 = (Integer)_startEvent_int_String.invoke(null, new Integer(n), string);
                n2 = n3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n2;
    }

    public static int startEvent(int n) {
        int n2 = -1;
        if (IdeProfile.canRun()) {
            try {
                Integer n3 = (Integer)_startEvent_int.invoke(null, new Integer(n));
                n2 = n3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n2;
    }

    public static void startEvent(int[] nArray, int n, String string) {
        nArray[0] = IdeProfile.startEvent(n, string);
    }

    public static void startEvent(int[] nArray, int n) {
        nArray[0] = IdeProfile.startEvent(n);
    }

    public static void endEvent(int n, String string) {
        if (IdeProfile.canRun()) {
            try {
                _endEvent_int_String.invoke(null, new Integer(n), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void endEvent(int n) {
        if (IdeProfile.canRun()) {
            try {
                _endEvent_int.invoke(null, new Integer(n));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void endEvent(int[] nArray, String string) {
        IdeProfile.endEvent(nArray[0], string);
    }

    public static void endEvent(int[] nArray) {
        IdeProfile.endEvent(nArray[0]);
    }

    public static void pulseEvent(int n, String string) {
        if (IdeProfile.canRun()) {
            try {
                _pulseEvent_int_String.invoke(null, new Integer(n), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void startSampling() {
        try {
            _startSampling.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void stopSampling() {
        try {
            _stopSampling.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

