/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.AWTEventListener;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.Version;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.StringTokenizerEx;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.util.SwingUtils;

public final class IdeUtil {
    private static HashSet javaKeywords;
    private static HashSet javaReservedWords;
    private static String _encoding;

    private IdeUtil() {
    }

    public static void centerWindow(Container container, Component component) {
        Dimension dimension;
        Point point;
        if (container != null) {
            point = container.getLocationOnScreen();
            dimension = container.getSize();
        } else {
            point = new Point(0, 0);
            dimension = component.getToolkit().getScreenSize();
        }
        Dimension dimension2 = component.getSize();
        component.setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
    }

    public static void centerTreeSelection(JTree jTree) {
        if (jTree == null) {
            return;
        }
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jTree);
        if (jScrollPane == null) {
            return;
        }
        3 var2_2 = new 3(jTree, jScrollPane);
        SwingUtilities.invokeLater(var2_2);
    }

    public static void expandAllTreeRows(JTree jTree) {
        IdeUtil.expandTreeToDepth(jTree, 0);
    }

    public static void expandTreeToDepth(JTree jTree, int n) {
        TreePath treePath = jTree.getSelectionPath();
        int n2 = 0;
        while (n2 < jTree.getRowCount()) {
            if (n <= 0) {
                jTree.expandRow(n2);
            } else {
                TreePath treePath2 = jTree.getPathForRow(n2);
                if (treePath2 != null && treePath2.getPathCount() <= n) {
                    jTree.expandRow(n2);
                } else {
                    jTree.collapseRow(n2);
                }
            }
            ++n2;
        }
        if (treePath != null) {
            jTree.setSelectionPath(treePath);
        } else {
            jTree.setSelectionRow(0);
        }
    }

    public static Dialog findDialog(Component component) {
        if (component instanceof Dialog) {
            return (Dialog)component;
        }
        return (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, component);
    }

    public static Frame findFrame(Component component) {
        return SwingUtils.findFrame((Component)component);
    }

    public static boolean isJavaKeyword(String string) {
        if (javaKeywords == null) {
            String[] stringArray = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
            javaKeywords = new HashSet();
            int n = 0;
            while (n < stringArray.length) {
                javaKeywords.add(stringArray[n]);
                ++n;
            }
        }
        return javaKeywords.contains(string);
    }

    public static boolean isJavaReservedWord(String string) {
        if (javaReservedWords == null) {
            String[] stringArray = new String[]{"true", "false", "null"};
            javaReservedWords = new HashSet();
            int n = 0;
            while (n < stringArray.length) {
                javaReservedWords.add(stringArray[n]);
                ++n;
            }
        }
        return IdeUtil.isJavaKeyword(string) || javaReservedWords.contains(string);
    }

    public static boolean isJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0)) || IdeUtil.isJavaReservedWord(string)) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isPackageIdentifier(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith(".") || string.endsWith(".") || string.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (IdeUtil.isJavaIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    public static String list2String(List list) {
        int n;
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        if (list != null) {
            Object[] objectArray = list.toArray(new Object[list.size()]);
            int n2 = 0;
            while (n2 < objectArray.length) {
                fastStringBuffer.append(objectArray[n2].toString()).append(";");
                ++n2;
            }
        }
        if ((n = fastStringBuffer.length()) > 0) {
            fastStringBuffer.setLength(n - 1);
        }
        return fastStringBuffer.toString();
    }

    public static void string2List(String string, List list) {
        list.clear();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                list.add(stringTokenizer.nextToken());
            }
        }
    }

    public static String[] convertStringToStringArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] convertStringToStringArray(String string, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizerEx stringTokenizerEx = new StringTokenizerEx(string, " \t\n\r\f", false, bl, bl2);
        while (stringTokenizerEx.hasMoreTokens()) {
            arrayList.add(stringTokenizerEx.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getSubString(String string, char c, boolean bl) {
        String string2 = null;
        int n = string.indexOf(c);
        if (n < 0) {
            if (bl) {
                string2 = string;
            }
        } else {
            string2 = bl ? string.substring(0, n) : string.substring(n + 1);
        }
        return string2;
    }

    public static String removeChars(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (n != -1) {
            stringBuffer.deleteCharAt(n);
            n = stringBuffer.toString().indexOf(string2);
        }
        return stringBuffer.toString();
    }

    public static String prepad(String string, char c, int n) {
        int n2 = n - string.length();
        if (n2 > 0) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
            int n3 = 0;
            while (n3 < n2) {
                fastStringBuffer.append(c);
                ++n3;
            }
            fastStringBuffer.append(string);
            string = fastStringBuffer.toString();
        }
        return string;
    }

    public static void addAll(Collection collection, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            collection.add(objectArray[n]);
            ++n;
        }
    }

    public static void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static boolean containsAny(AbstractCollection abstractCollection, Collection collection) {
        for (Object e : collection) {
            if (!abstractCollection.contains(e)) continue;
            return true;
        }
        return false;
    }

    public static String getDocumentVersion(URL uRL) {
        try {
            StartElementPacket startElementPacket = XMLUtil.getXMLRootElement(uRL);
            if (startElementPacket != null) {
                String string = IdeUtil.getVersionFromNamespaceURI(startElementPacket.namespaceURI);
                return string;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = IdeUtil.getVersionFromNamespaceURI(Version.BASE_NAMESPACE_URI);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void addComboBoxDocumentListener(JComboBox jComboBox, DocumentListener documentListener) {
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        jTextField.getDocument().addDocumentListener(new 2(documentListener, jTextField));
    }

    public static void comboBoxSelectItem(JComboBox jComboBox, Object object) {
        boolean bl = false;
        int n = jComboBox.getItemCount() - 1;
        while (n >= 0) {
            if (jComboBox.getItemAt(n).equals(object)) {
                bl = true;
                jComboBox.setSelectedIndex(n);
            }
            --n;
        }
        if (!bl) {
            jComboBox.insertItemAt(object, 0);
            jComboBox.setSelectedIndex(0);
        }
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        jTextField.setText(object.toString());
    }

    public static Icon grayIcon(Icon icon) {
        Image image = GrayFilter.createDisabledImage(((ImageIcon)icon).getImage());
        return new ImageIcon(image);
    }

    public static void runNow(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void copyToClipboard(String string) {
        if (string != null && string.length() > 0) {
            StringSelection stringSelection = new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            ClipboardStack.pushCurrentClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    public static Frame getMainWindow() {
        return SwingUtils.getMainWindow();
    }

    public static void setMainWindow(JFrame jFrame) {
        SwingUtils.setMainWindow((JFrame)jFrame);
    }

    public static void setStartupWindow(JFrame jFrame) {
        SwingUtils.setStartupWindow((JFrame)jFrame);
    }

    public static String getProgramName() {
        String string = SwingUtils.getProgramName();
        return ModelUtil.hasLength((String)string) ? string : "Oracle Development Tool";
    }

    public static void setProgramName(String string) {
        SwingUtils.setProgramName((String)string);
    }

    public static String getProgramShortName() {
        String string = SwingUtils.getProgramShortName();
        return ModelUtil.hasLength((String)string) ? string : "Development Tool";
    }

    public static void setProgramShortName(String string) {
        SwingUtils.setProgramShortName((String)string);
    }

    public static String getIdeEncoding() {
        return _encoding != null ? _encoding : Encodings.getDefaultEncoding();
    }

    public static void setIdeEncoding(String string) {
        _encoding = string;
    }

    public static String getIdeIanaEncoding() {
        String string = IdeUtil.getIdeEncoding();
        if (string.equals("Cp1252")) {
            return "windows-1252";
        }
        return Encodings.convertJdk2IanaEncoding(string);
    }

    public static String replaceHTMLReservedCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            char c = stringBuffer.charAt(n2);
            switch (c) {
                default: {
                    string2 = null;
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                }
            }
            if (string2 != null) {
                stringBuffer.replace(n2, n2 + 1, string2);
                n = stringBuffer.length();
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String decodeHTMLReservedCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            String string2 = null;
            int n3 = 0;
            char c = stringBuffer.charAt(n2);
            switch (c) {
                default: {
                    string2 = null;
                    break;
                }
                case '&': {
                    String string3 = stringBuffer.substring(n2, Math.min(n, n2 + 4));
                    if (string3.equals("&lt;")) {
                        string2 = "<";
                        n3 = 4;
                        break;
                    }
                    if (string3.equals("&gt;")) {
                        string2 = ">";
                        n3 = 4;
                        break;
                    }
                    string3 = stringBuffer.substring(n2, Math.min(n, n2 + 5));
                    if (string3.equals("&amp;")) {
                        string2 = "&";
                        n3 = 5;
                        break;
                    }
                    string3 = stringBuffer.substring(n2, Math.min(n, n2 + 6));
                    if (!string3.equals("&quot;")) break;
                    string2 = "\"";
                    n3 = 6;
                    break;
                }
            }
            if (string2 != null) {
                stringBuffer.replace(n2, n2 + n3, string2);
                n = stringBuffer.length();
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static Component moveFocusAway() {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        Component component = ideMainWindow.getFocusOwner();
        Menubar menubar = Ide.getMenubar();
        Container container = menubar.getGUI(false);
        GraphicsUtils.focusComponentOrChild(container, false);
        return component;
    }

    public static void tryToRestoreFocus(Component component) {
        if (component != null && component.isShowing() && component.isEnabled()) {
            component.requestFocus();
        } else {
            Editor editor;
            EditorManager editorManager = EditorManager.getEditorManager();
            Editor editor2 = editor = editorManager != null ? editorManager.getCurrentEditor() : null;
            if (editor != null) {
                Component component2 = editor.getGUI();
                GraphicsUtils.focusComponentOrChild(component2, true);
            } else {
                DockStation dockStation = DockStation.getDockStation();
                if (dockStation != null) {
                    dockStation.activateAnyDockable();
                }
            }
        }
    }

    public static final Window findActiveModalWindow() {
        Window window;
        Window window2 = IdeUtil.findActiveModalWindowImpl(IdeUtil.getMainWindow());
        if (window2 == null) {
            return null;
        }
        while ((window = IdeUtil.findActiveModalWindowImpl(window2.getOwnedWindows())) != null) {
            window2 = window;
        }
        return window2;
    }

    private static final Window findActiveModalWindowImpl(Window window) {
        if (!window.isShowing()) {
            return null;
        }
        if (window instanceof Dialog && ((Dialog)window).isModal()) {
            return window;
        }
        return IdeUtil.findActiveModalWindowImpl(window.getOwnedWindows());
    }

    private static final Window findActiveModalWindowImpl(Window[] windowArray) {
        int n = 0;
        while (n < windowArray.length) {
            Window window = IdeUtil.findActiveModalWindowImpl(windowArray[n]);
            if (window != null) {
                return window;
            }
            ++n;
        }
        return null;
    }

    public static String getDigitsFromString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            if (Character.isDigit(string.charAt(n2))) {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String getVersionFromNamespaceURI(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (++n != 4) continue;
            return string2;
        }
        return null;
    }

    public static void invokeAfterRepaint(Runnable runnable) {
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show(0L);
        if (IdeUtil.hasPaintEventsPending()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            1 var3_3 = new 1(toolkit, runnable, waitCursor);
            toolkit.addAWTEventListener(var3_3, 8192L);
        } else {
            try {
                try {
                    runnable.run();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    private static boolean hasPaintEventsPending() {
        boolean bl = false;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        if (eventQueue.peekEvent(800) != null || eventQueue.peekEvent(801) != null) {
            bl = true;
        }
        return bl;
    }

    static boolean maS$hasPaintEventsPending() {
        return IdeUtil.hasPaintEventsPending();
    }

    public static final class 3
    implements Runnable {
        private final /* synthetic */ JTree v$tree;
        private final /* synthetic */ JScrollPane v$sp;

        public void run() {
            int n;
            TreePath treePath = this.v$tree.getSelectionPath();
            Rectangle rectangle = this.v$tree.getPathBounds(treePath);
            JViewport jViewport = this.v$sp.getViewport();
            Rectangle rectangle2 = jViewport.getViewRect();
            rectangle2.y = rectangle.y - (rectangle2.height - rectangle.height >> 1);
            if (rectangle2.y < 0) {
                rectangle2.y = 0;
            }
            if (rectangle2.y + rectangle2.height > (n = this.v$tree.getHeight())) {
                rectangle2.y = n - rectangle2.height;
            }
            this.v$tree.scrollRectToVisible(rectangle2);
        }

        public 3(JTree jTree, JScrollPane jScrollPane) {
            this.v$sp = jScrollPane;
            this.v$tree = jTree;
        }
    }

    public static final class 2
    implements DocumentListener {
        private final /* synthetic */ DocumentListener v$documentListener;
        private final /* synthetic */ JTextField v$editor;

        public void changedUpdate(DocumentEvent documentEvent) {
            this.v$documentListener.changedUpdate(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.v$documentListener.insertUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.v$editor.hasFocus()) {
                this.v$documentListener.removeUpdate(documentEvent);
            }
        }

        public 2(DocumentListener documentListener, JTextField jTextField) {
            this.v$editor = jTextField;
            this.v$documentListener = documentListener;
        }
    }

    public static final class oracle.ide.util.IdeUtil$1
    implements AWTEventListener {
        private final /* synthetic */ Toolkit v$toolkit;
        private final /* synthetic */ Runnable v$runnable;
        private final /* synthetic */ WaitCursor v$waitCursor;

        public void eventDispatched(AWTEvent aWTEvent) {
            int n = aWTEvent.getID();
            if (!(n != 800 && n != 801 || IdeUtil.maS$hasPaintEventsPending())) {
                this.v$toolkit.removeAWTEventListener(this);
                SwingUtilities.invokeLater(new 1());
            }
        }

        public oracle.ide.util.IdeUtil$1(Toolkit toolkit, Runnable runnable, WaitCursor waitCursor) {
            this.v$waitCursor = waitCursor;
            this.v$runnable = runnable;
            this.v$toolkit = toolkit;
        }

        static Runnable ra$v$runnable(oracle.ide.util.IdeUtil$1 var0) {
            return var0.v$runnable;
        }

        static WaitCursor ra$v$waitCursor(oracle.ide.util.IdeUtil$1 var0) {
            return var0.v$waitCursor;
        }

        public final class 1
        implements Runnable {
            public void run() {
                try {
                    try {
                        oracle.ide.util.IdeUtil$1.ra$v$runnable(1.this).run();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    oracle.ide.util.IdeUtil$1.ra$v$waitCursor(1.this).hide();
                }
            }
        }
    }
}

