/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class InflaterInputStreamPatch
extends FilterInputStream {
    int initAvail;
    int avail;

    public InflaterInputStreamPatch(InputStream inputStream, ZipEntry zipEntry) {
        super(inputStream);
        this.initAvail = this.avail = (int)zipEntry.getSize();
    }

    public int available() throws IOException {
        return this.avail;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n >= 0) {
            --this.avail;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        this.avail -= n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.avail = (int)((long)this.avail - l2);
        return l2;
    }

    public synchronized void reset() throws IOException {
        super.reset();
        this.avail = this.initAvail;
    }

    public boolean markSupported() {
        return false;
    }
}

