/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntHashMap {
    private static final int DEFAULT_SIZE = 11;
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();

    void $init$() {
        this.modCount = 0;
    }

    public IntHashMap(int n, float f) {
        this.$init$();
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap() {
        this(11, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int n = entryArray.length;
            while (n-- > 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(int n, Object object) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n2 = 0;
        n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry2 = entryArray[n2];
        while (entry2 != null) {
            if (n == entry2.key) {
                Object object2 = entry2.value;
                entry2.value = object;
                return object2;
            }
            entry2 = entry2.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, entryArray[n2]);
        ++this.count;
        return null;
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (n == entry.key) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object object = entry.value;
                return object;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public Iterator iterator() {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator();
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    static int ra$modCount(IntHashMap intHashMap) {
        return intHashMap.modCount;
    }

    static Entry[] ra$table(IntHashMap intHashMap) {
        return intHashMap.table;
    }

    static void wa$modCount(IntHashMap intHashMap, int n) {
        intHashMap.modCount = n;
    }

    static int ra$count(IntHashMap intHashMap) {
        return intHashMap.count;
    }

    static void wa$count(IntHashMap intHashMap, int n) {
        intHashMap.count = n;
    }

    private static class Entry {
        int key;
        Object value;
        Entry next;

        Entry(int n, Object object, Entry entry) {
            this.key = n;
            this.value = object;
            this.next = entry;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        private int expectedModCount;

        void $init$() {
            this.table = IntHashMap.ra$table(IntHashMap.this);
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IntHashMap.ra$modCount(IntHashMap.this);
        }

        HashIterator() {
            this.$init$();
        }

        public boolean hasNext() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        public Object next() {
            if (IntHashMap.ra$modCount(IntHashMap.this) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                Entry entry2 = this.lastReturned = this.entry;
                this.entry = entry2.next;
                return entry2.value;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IntHashMap.ra$modCount(IntHashMap.this) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = IntHashMap.ra$table(IntHashMap.this);
            int n = (this.lastReturned.key & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturned) {
                    IntHashMap intHashMap = IntHashMap.this;
                    IntHashMap.wa$modCount(intHashMap, IntHashMap.ra$modCount(intHashMap) + 1);
                    ++this.expectedModCount;
                    if (entry2 == null) {
                        entryArray[n] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    IntHashMap intHashMap2 = IntHashMap.this;
                    IntHashMap.wa$count(intHashMap2, IntHashMap.ra$count(intHashMap2) - 1);
                    this.lastReturned = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

