/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;

public final class IntersectedFilters {
    private final PatternFilters[] _filters;
    private final int _n;

    public IntersectedFilters(PatternFilters[] patternFiltersArray) {
        int n = 0;
        int n2 = patternFiltersArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (patternFiltersArray[n3] != null) {
                ++n;
            }
            ++n3;
        }
        if (n == n2) {
            this._filters = patternFiltersArray;
            this._n = n2;
        } else {
            PatternFilters[] patternFiltersArray2 = new PatternFilters[n];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                PatternFilters patternFilters = patternFiltersArray[n5];
                if (patternFilters != null) {
                    patternFiltersArray2[n4++] = patternFilters;
                }
                ++n5;
            }
            this._filters = patternFiltersArray2;
            this._n = n;
        }
    }

    public IntersectedFilters(IntersectedFilters intersectedFilters, IntersectedFilters intersectedFilters2) {
        this._filters = IntersectedFilters.intersect(intersectedFilters, intersectedFilters2);
        this._n = this._filters.length;
    }

    public IntersectedFilters(PatternFilters patternFilters) {
        this(new PatternFilters[]{patternFilters});
    }

    public IntersectedFilters(PatternFilters patternFilters, PatternFilters patternFilters2) {
        this(new PatternFilters[]{patternFilters, patternFilters2});
    }

    public IntersectedFilters(PatternFilters patternFilters, PatternFilters patternFilters2, PatternFilters patternFilters3) {
        this(new PatternFilters[]{patternFilters, patternFilters2, patternFilters3});
    }

    public IntersectedFilters intersectWith(PatternFilters patternFilters) {
        return new IntersectedFilters(IntersectedFilters.intersect(patternFilters, this));
    }

    public TriStateBoolean inferFromFilters(String string) {
        TriStateBoolean triStateBoolean = TriStateBoolean.TRUE;
        int n = 0;
        while (n < this._n) {
            PatternFilters patternFilters = this._filters[n];
            if (patternFilters.containsFilters()) {
                TriStateBoolean triStateBoolean2 = patternFilters.inferFromFilters(string);
                if (triStateBoolean2.isFalse()) {
                    return TriStateBoolean.FALSE;
                }
                triStateBoolean = triStateBoolean.and(triStateBoolean2);
            }
            ++n;
        }
        return triStateBoolean;
    }

    public boolean isIncluded(String string) {
        int n = 0;
        while (n < this._n) {
            PatternFilters patternFilters = this._filters[n];
            if (patternFilters.containsFilters() && !patternFilters.isIncluded(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static PatternFilters[] intersect(IntersectedFilters intersectedFilters, IntersectedFilters intersectedFilters2) {
        int n = intersectedFilters != null ? intersectedFilters._n : 0;
        int n2 = intersectedFilters2 != null ? intersectedFilters2._n : 0;
        int n3 = n + n2;
        PatternFilters[] patternFiltersArray = new PatternFilters[n3];
        if (intersectedFilters != null) {
            System.arraycopy(intersectedFilters._filters, 0, patternFiltersArray, 0, n);
        }
        if (intersectedFilters2 != null) {
            System.arraycopy(intersectedFilters2._filters, 0, patternFiltersArray, n, n2);
        }
        return patternFiltersArray;
    }

    private static PatternFilters[] intersect(PatternFilters patternFilters, IntersectedFilters intersectedFilters) {
        int n = patternFilters != null ? 1 : 0;
        int n2 = intersectedFilters != null ? intersectedFilters._n : 0;
        int n3 = n + n2;
        PatternFilters[] patternFiltersArray = new PatternFilters[n3];
        if (patternFilters != null) {
            patternFiltersArray[0] = patternFilters;
        }
        if (intersectedFilters != null) {
            System.arraycopy(intersectedFilters._filters, 0, patternFiltersArray, n, n2);
        }
        return patternFiltersArray;
    }
}

