/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class IteratorFilter
implements Iterator {
    private Iterator _baseIterator;
    private boolean _bNextIsFetched;
    private Object _next;

    public IteratorFilter(Iterator iterator) {
        this._baseIterator = iterator;
    }

    protected abstract boolean isValid(Object var1);

    public boolean hasNext() {
        return this._bNextIsFetched || this.fetchNext();
    }

    public Object next() {
        if (!this._bNextIsFetched && !this.fetchNext()) {
            throw new NoSuchElementException();
        }
        Object object = this._next;
        this._next = null;
        this._bNextIsFetched = false;
        return object;
    }

    public void remove() {
        if (this._bNextIsFetched) {
            throw new IllegalStateException();
        }
        this._baseIterator.remove();
    }

    private boolean fetchNext() {
        boolean bl = false;
        while (!bl && this._baseIterator.hasNext()) {
            Object e = this._baseIterator.next();
            if (!this.isValid(e)) continue;
            this._bNextIsFetched = true;
            this._next = e;
            bl = true;
        }
        return bl;
    }
}

