/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Locale;

public class MenuCJKUtil {
    private static final String INVOKED_TOKEN = "...";
    private static final String LOCAL_LANG = Locale.getDefault().getLanguage();
    private static final boolean isCJK = LOCAL_LANG.equals(Locale.CHINESE.getLanguage()) || LOCAL_LANG.equals(Locale.JAPANESE.getLanguage()) || LOCAL_LANG.equals(Locale.KOREAN.getLanguage());

    public static String addSingleByteCharsForMnemonics(String string) {
        if (isCJK) {
            return string + "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        }
        return string;
    }

    public static String getCJKMenuLabel(String string, Integer n) {
        if (n == null) {
            return string;
        }
        return MenuCJKUtil.getCJKMenuLabel(string, (int)n);
    }

    public static String getCJKMenuLabel(String string, int n) {
        return MenuCJKUtil.getModifiedMenuLabel(string, n);
    }

    private static String getModifiedMenuLabel(String string, int n) {
        boolean bl = false;
        if (!isCJK || string == null) {
            return string;
        }
        string = string.trim();
        int n2 = string.length();
        boolean bl2 = false;
        if (MenuCJKUtil.isInvoked(string)) {
            bl = true;
            n2 -= 3;
        }
        if (n2 >= 4 && string.charAt(n2 - 4) == '(' && string.charAt(n2 - 3) == '&' && string.charAt(n2 - 1) == ')') {
            bl2 = true;
            if (string.charAt(n2 - 2) == (char)n) {
                return string;
            }
            n2 -= 4;
        }
        if (n2 >= 3 && !bl2 && string.charAt(n2 - 3) == '(' && string.charAt(n2 - 1) == ')') {
            if (string.charAt(n2 - 2) == (char)n) {
                return string;
            }
            n2 -= 3;
        }
        string = string.substring(0, n2).trim();
        if (n != 0) {
            string = string + MenuCJKUtil.getMnemonicToken(n, bl2);
        }
        if (bl) {
            string = string + INVOKED_TOKEN;
        }
        return string;
    }

    private static String getMnemonicToken(int n, boolean bl) {
        String string = "";
        if (n >= 97 && n <= 122 || n >= 65 && n <= 90) {
            if (bl) {
                char[] cArray = new char[]{'(', '&', (char)n, ')'};
                string = new String(cArray).toUpperCase();
            } else {
                char[] cArray = new char[]{'(', (char)n, ')'};
                string = new String(cArray).toUpperCase();
            }
        }
        return string;
    }

    private static boolean isInvoked(String string) {
        return string.trim().endsWith(INVOKED_TOKEN);
    }
}

