/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;

public final class MenuSpec {
    public final String label;
    public final Integer mnemonic;
    private Icon icon;
    private ResourceBundle bundle;
    private int key;
    private String strKey;

    void $init$() {
        this.key = -1;
    }

    public MenuSpec(String string, Integer n, Icon icon) {
        this.$init$();
        this.label = string;
        this.mnemonic = n;
        this.icon = icon;
    }

    public MenuSpec(String string, Integer n, ArrayResourceBundle arrayResourceBundle, int n2) {
        this.$init$();
        this.label = string;
        this.mnemonic = n;
        this.bundle = n2 >= 0 ? arrayResourceBundle : null;
        this.key = n2;
    }

    public MenuSpec(String string, Integer n, ResourceBundle resourceBundle, String string2) {
        this.$init$();
        this.label = string;
        this.mnemonic = n;
        this.bundle = string2 != null ? resourceBundle : null;
        this.strKey = string2;
    }

    public Icon getIcon() {
        if (this.icon == null && this.bundle != null) {
            if (this.key >= 0) {
                try {
                    this.icon = ((ArrayResourceBundle)this.bundle).getIconImpl(this.key);
                }
                catch (Exception exception) {
                    this.icon = null;
                }
            } else if (this.strKey != null) {
                try {
                    ImageIcon imageIcon;
                    Image image;
                    URL uRL = this.bundle.getClass().getResource(this.strKey);
                    if (uRL != null && (image = Toolkit.getDefaultToolkit().createImage(uRL)) != null && (imageIcon = GraphicsUtils.createImageIcon(image)).getImageLoadStatus() == 8) {
                        this.icon = imageIcon;
                    }
                }
                catch (Exception exception) {
                    this.icon = null;
                }
            }
            this.resetBundle();
        }
        return this.icon;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public Object getBundleKey() {
        if (this.key >= 0) {
            return new Integer(this.key);
        }
        return this.strKey;
    }

    private void resetBundle() {
        this.bundle = null;
        this.key = -1;
        this.strKey = null;
    }
}

