/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.ide.util.Letter;
import oracle.ide.util.MenuCJKUtil;
import oracle.ide.util.MenuLabelComparator;

public class MnemonicSolver {
    private Collection _labels;
    private Map _letters;

    void $init$() {
        this._labels = new TreeSet(new MenuLabelComparator());
        this._letters = new HashMap();
    }

    public MnemonicSolver() {
        this.$init$();
    }

    public MnemonicSolver(String[] stringArray) {
        this.$init$();
        int n = 0;
        while (n < stringArray.length) {
            this.addMenuLabel(stringArray[n]);
            ++n;
        }
    }

    public MnemonicSolver(String[] stringArray, int[] nArray) {
        this.$init$();
        int n = 0;
        while (n < stringArray.length) {
            this.addMenuLabel(stringArray[n], nArray[n]);
            ++n;
        }
    }

    public MnemonicSolver(String[] stringArray, int[] nArray, boolean[] blArray) {
        this.$init$();
        int n = 0;
        while (n < stringArray.length) {
            this.addMenuLabel(stringArray[n], nArray[n], blArray[n]);
            ++n;
        }
    }

    public MnemonicSolver(JMenu jMenu) {
        this(jMenu.getPopupMenu());
    }

    public MnemonicSolver(JPopupMenu jPopupMenu) {
        this.$init$();
        this.addMenuLabels(jPopupMenu);
    }

    public MenuLabel addMenuLabel(String string) {
        return this.addMenuLabel(string, 0);
    }

    public MenuLabel addMenuLabel(String string, int n) {
        return this.addMenuLabel(string, n, false);
    }

    public MenuLabel addMenuLabel(String string, int n, boolean bl) {
        MenuLabel menuLabel = new MenuLabel(string, n, bl);
        this.registerMenuLabel(menuLabel);
        return menuLabel;
    }

    public MenuLabel addMenuLabel(JMenuItem jMenuItem) {
        return this.addMenuLabel(jMenuItem, false);
    }

    public MenuLabel addMenuLabel(JMenuItem jMenuItem, boolean bl) {
        return this.addMenuLabel(jMenuItem, null, bl);
    }

    public MenuLabel addMenuLabel(JMenuItem jMenuItem, String string, boolean bl) {
        MenuLabel menuLabel = this.findMenuLabel(jMenuItem);
        if (menuLabel != null) {
            menuLabel.setFixed(bl);
            menuLabel.setText(string);
        } else {
            menuLabel = new MenuLabel(jMenuItem, string, bl);
            this.registerMenuLabel(menuLabel);
        }
        return menuLabel;
    }

    public MenuLabel addMenuLabel(Component component, boolean bl) {
        return this.addMenuLabel(component, null, bl);
    }

    public MenuLabel addMenuLabel(Component component, String string, boolean bl) {
        if (component instanceof JMenuItem) {
            return this.addMenuLabel((JMenuItem)component, string, bl);
        }
        return null;
    }

    public Collection addMenuLabels(JMenu jMenu) {
        return this.addMenuLabels(jMenu.getPopupMenu());
    }

    public Collection addMenuLabels(JPopupMenu jPopupMenu) {
        Component[] componentArray = jPopupMenu.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component instanceof JMenuItem) {
                this.addMenuLabel((JMenuItem)component);
            }
            ++n;
        }
        return this._labels;
    }

    public MenuLabel findMenuLabel(JMenuItem jMenuItem) {
        for (MenuLabel menuLabel : this._labels) {
            if (menuLabel.getMenuItem() != jMenuItem) continue;
            return menuLabel;
        }
        return null;
    }

    public void removeMenuLabel(MenuLabel menuLabel) {
        this.decrementLetterCounter(menuLabel.getText(), true);
        this._labels.remove(menuLabel);
    }

    public Collection solve() {
        this.resolve();
        this.fineTune();
        return this._labels;
    }

    public void clear() {
        this._labels.clear();
        this._letters.clear();
    }

    private void resolve() {
        Iterator iterator = this._labels.iterator();
        while (iterator.hasNext()) {
            this.resolve((MenuLabel)iterator.next());
        }
    }

    private void fineTune() {
        Iterator iterator = this._labels.iterator();
        while (iterator.hasNext()) {
            this.fineTune((MenuLabel)iterator.next());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void resolve(MenuLabel var1_1) {
        var2_2 = MenuCJKUtil.addSingleByteCharsForMnemonics(var1_1.getText());
        var3_3 = var1_1.getMnemonic();
        var4_4 = new Letter();
        var4_4._counter = 0x7FFFFFFF;
        var5_5 = 0;
        var6_6 = false;
        var7_7 = new ArrayList<Integer>();
        var8_8 = 0;
        while (var8_8 < var2_2.length()) {
            block21: {
                block20: {
                    var9_9 = var2_2.charAt(var8_8);
                    if (Letter.isValid(var9_9)) break block20;
                    var5_5 = var9_9;
                    break block21;
                }
                var10_10 = this.findLetter(var9_9);
                if (!var10_10.isUsed()) ** GOTO lbl-1000
                var11_11 = var10_10.getUsageCount();
                if (this.areEqual(var10_10._char, var3_3)) {
                    if (var11_11 == 1) {
                        var1_1.setFixed(true);
                        this.decrementLetterCounter(var2_2, false);
                        return;
                    }
                    for (MenuLabel var13_13 : var10_10._labels) {
                        if (var13_13 == var1_1) continue;
                        var13_13.setMnemonic(0);
                        var13_13.setFixed(false);
                    }
                    var10_10._labels.clear();
                    var1_1.setFixed(true);
                    var10_10._labels.add(var1_1);
                    this.decrementLetterCounter(var2_2, false);
                    return;
                }
                if (var10_10.isFixed()) {
                    var5_5 = var10_10._char;
                } else if (this.isSpace(var9_9)) {
                    var5_5 = var9_9;
                } else {
                    if (var10_10._counter < var4_4._counter) {
                        if (!var6_6) {
                            var4_4._char = var9_9;
                            var4_4._counter = var10_10._counter;
                            if (var8_8 == 0) {
                                var6_6 = true;
                            }
                        }
                    } else if (var10_10._counter == var4_4._counter) {
                        if (!var6_6 && this.isSpace(var5_5)) {
                            var4_4._char = var9_9;
                            var4_4._counter = var10_10._counter;
                            var6_6 = true;
                        }
                    } else if (!var6_6 && (var8_8 == 0 || this.isSpace(var5_5))) {
                        var7_7.add(new Integer(var9_9));
                    }
                    var5_5 = var9_9;
                }
            }
            ++var8_8;
        }
        if (var4_4.isValid()) {
            var14_14 = this.findLetter(var4_4._char);
            for (MenuLabel var16_16 : var14_14._labels) {
                var16_16.setMnemonic(0);
                var16_16.setFixed(false);
            }
            var14_14._labels.clear();
            var1_1.initMnemonic(var4_4._char);
            if (!var1_1.isFixed()) {
                var1_1.setFixed(true);
                var1_1.setPotentialMnemonics(var7_7);
            }
            var14_14._labels.add(var1_1);
            this.decrementLetterCounter(var2_2, false);
        } else {
            var1_1.initMnemonic(0);
        }
    }

    private void fineTune(MenuLabel menuLabel) {
        List list = menuLabel.getPotentialMnemonics();
        if (list == null || list.size() == 0) {
            return;
        }
        String string = menuLabel.getText();
        int n = menuLabel.getMnemonic();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            Letter letter = this.findLetter(n2);
            if (letter.isUsed()) continue;
            menuLabel.initMnemonic(n2);
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void registerMenuLabel(MenuLabel var1_1) {
        var2_2 = MenuCJKUtil.addSingleByteCharsForMnemonics(var1_1.getText());
        var3_3 = var1_1.getMnemonic();
        var4_4 = var2_2.length();
        var5_5 = new char[var4_4];
        var6_6 = 0;
        var7_7 = 0;
        while (var7_7 < var4_4) {
            block6: {
                block7: {
                    block9: {
                        block8: {
                            var8_8 = var2_2.charAt(var7_7);
                            if (!Letter.isValid((int)var8_8)) break block6;
                            var9_9 = this.findLetter(var8_8);
                            if (var9_9 == null) {
                                var9_9 = new Letter(var8_8);
                                this.cacheLetter(var8_8, var9_9);
                            }
                            if (MenuLabelComparator.isUniqueChar(var5_5, var8_8)) {
                                var5_5[var6_6++] = var8_8;
                                ++var9_9._counter;
                            }
                            if (!this.areEqual(var3_3, var8_8)) break block6;
                            var10_10 = var9_9.getUsageCount();
                            if (var10_10 == 0) ** GOTO lbl-1000
                            if (!var1_1.isFixed()) break block7;
                            if (var10_10 <= 1) break block8;
                            for (MenuLabel var12_12 : var9_9._labels) {
                                var12_12.setMnemonic(0);
                                var12_12.setFixed(false);
                            }
                            var9_9._labels.clear();
                            ** GOTO lbl-1000
                        }
                        var13_13 = (MenuLabel)var9_9._labels.first();
                        if (var13_13 == var1_1) break block6;
                        if (!var13_13.isFixed()) ** GOTO lbl-1000
                        if (MenuLabelComparator.length(var13_13.getText()) <= MenuLabelComparator.length(var1_1.getText())) break block9;
                        var9_9._labels.clear();
                        var13_13.setMnemonic(0);
                        var13_13.setFixed(false);
                        ** GOTO lbl-1000
                    }
                    var1_1.setMnemonic(0);
                    var1_1.setFixed(false);
                    break block6;
                }
                if (var10_10 == 1 && (var14_14 = (MenuLabel)var9_9._labels.first()).isFixed()) {
                    var1_1.setMnemonic(0);
                    var1_1.setFixed(false);
                } else lbl-1000:
                // 5 sources

                {
                    var9_9._labels.add(var1_1);
                }
            }
            ++var7_7;
        }
        this._labels.add(var1_1);
    }

    private void decrementLetterCounter(String string, boolean bl) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        if (n == 0) {
            return;
        }
        char[] cArray = new char[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Letter letter;
            char c = string.charAt(n4);
            if (Letter.isValid((int)c) && (letter = this.findLetter(c)) != null && MenuLabelComparator.isUniqueChar(cArray, c)) {
                cArray[n3++] = c;
                --letter._counter;
                if (bl && letter._counter == 0) {
                    this.uncacheLetter(c);
                }
            }
            ++n4;
        }
    }

    private Letter findLetter(int n) {
        return (Letter)this._letters.get(this.toLowerCase(n));
    }

    private void cacheLetter(int n, Letter letter) {
        this._letters.put(this.toLowerCase(n), letter);
    }

    private void uncacheLetter(int n) {
        this._letters.remove(this.toLowerCase(n));
    }

    private boolean isSpace(int n) {
        return Character.isSpaceChar((char)n);
    }

    private Integer toLowerCase(int n) {
        return new Integer(Character.toLowerCase((char)n));
    }

    private boolean areEqual(int n, int n2) {
        return Character.toLowerCase((char)n) == Character.toLowerCase((char)n2);
    }

    static void mav$registerMenuLabel(MnemonicSolver mnemonicSolver, MenuLabel menuLabel) {
        mnemonicSolver.registerMenuLabel(menuLabel);
    }

    public class MenuLabel {
        private JMenuItem _menuItem;
        private String _text;
        private int _mnemonic;
        private boolean _fixed;
        private List _potentialMnemonics;

        protected MenuLabel(String string) {
            this(string, 0);
        }

        protected MenuLabel(String string, int n) {
            this(string, n, false);
        }

        protected MenuLabel(String string, int n, boolean bl) {
            this._text = string;
            this._mnemonic = n;
            this._fixed = bl;
        }

        protected MenuLabel(JMenuItem jMenuItem, boolean bl) {
            this(jMenuItem, null, bl);
        }

        protected MenuLabel(JMenuItem jMenuItem, String string, boolean bl) {
            this(string, jMenuItem.getMnemonic(), bl);
            if (!this.isValidText(this._text)) {
                this._text = jMenuItem.getText();
            }
            this._menuItem = jMenuItem;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String string) {
            if (this.isValidText(string)) {
                MnemonicSolver.this.removeMenuLabel(this);
                this._text = string;
                MnemonicSolver.mav$registerMenuLabel(MnemonicSolver.this, this);
            }
        }

        public int getMnemonic() {
            return this._mnemonic;
        }

        public void setMnemonic(int n) {
            this._mnemonic = n;
        }

        public void initMnemonic(int n) {
            this.setMnemonic(n);
            if (this._menuItem != null) {
                this._menuItem.setText(MenuCJKUtil.getCJKMenuLabel(this._menuItem.getText(), n));
                int n2 = n;
                if (n2 >= 97 && n2 <= 122) {
                    n2 -= 32;
                }
                this._menuItem.setMnemonic(n2);
            }
        }

        public boolean isFixed() {
            return this._fixed;
        }

        public void setFixed(boolean bl) {
            this._fixed = bl;
        }

        public JMenuItem getMenuItem() {
            return this._menuItem;
        }

        public void setMenuItem(JMenuItem jMenuItem) {
            this._menuItem = jMenuItem;
        }

        public List getPotentialMnemonics() {
            return this._potentialMnemonics;
        }

        public void setPotentialMnemonics(List list) {
            this._potentialMnemonics = list;
        }

        public boolean isValidText(String string) {
            return string != null && string.length() > 0;
        }
    }
}

