/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.HashMap;
import java.util.Map;

public class Namespace {
    private final Map _data;
    private Namespace _parent;

    public Namespace() {
        this((Namespace)null);
    }

    public Namespace(Map map) {
        this(map == null ? new HashMap() : new HashMap(map), null);
    }

    public Namespace(Namespace namespace) {
        this(new HashMap(), namespace);
    }

    protected Namespace(Map map, Namespace namespace) {
        this._data = map;
        this.setParent(namespace != null ? namespace : this);
    }

    protected Namespace(Namespace namespace, boolean bl) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        Map map = namespace.getData();
        this._data = bl ? new HashMap(map) : map;
        this.setParent(namespace.getParent());
    }

    public boolean isRoot() {
        return this.getParent() == this;
    }

    public Namespace getParent() {
        return this._parent;
    }

    public Namespace getRoot() {
        Namespace namespace;
        Namespace namespace2 = this;
        while (namespace2 != (namespace = namespace2.getParent())) {
            namespace2 = namespace;
        }
        return namespace2;
    }

    public boolean contains(String string) {
        return this.getData().containsKey(string);
    }

    public Object find(String string) {
        String string2 = this.translateKey(string);
        Namespace namespace = this;
        while (!namespace.contains(string2)) {
            Namespace namespace2 = namespace.getParent();
            if (namespace == namespace2) {
                return null;
            }
            namespace = namespace2;
        }
        return namespace.get(string2);
    }

    public void findAndReplace(String string, Object object) {
        String string2 = this.translateKey(string);
        Namespace namespace = this;
        while (true) {
            if (namespace.contains(string2)) {
                namespace.put(string2, object);
                return;
            }
            Namespace namespace2 = namespace.getParent();
            if (namespace == namespace2) {
                namespace.put(string2, object);
                return;
            }
            namespace = namespace2;
        }
    }

    public Object get(String string) {
        return this.getData().get(string);
    }

    public Object get(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return this.get((String)null);
        }
        int n = stringArray.length - 1;
        Namespace namespace = this.findNamespace(stringArray, n);
        if (namespace != null) {
            String string = stringArray[n];
            return namespace.get(string);
        }
        return null;
    }

    public void put(String string, Object object) {
        this.getData().put(string, object);
    }

    public void put(String string, Namespace namespace) {
        if (namespace != null) {
            namespace.setParent(this);
        }
        this.put(string, (Object)namespace);
    }

    public void put(String[] stringArray, Object object) {
        if (stringArray == null || stringArray.length <= 0) {
            this.put((String)null, object);
            return;
        }
        int n = stringArray.length - 1;
        Namespace namespace = this.findNamespace(stringArray, n);
        if (namespace != null) {
            String string = stringArray[n];
            namespace.put(string, object);
        }
    }

    public void put(String[] stringArray, Namespace namespace) {
        if (stringArray == null || stringArray.length <= 0) {
            this.put((String)null, namespace);
            return;
        }
        int n = stringArray.length - 1;
        Namespace namespace2 = this.findNamespace(stringArray, n);
        if (namespace2 != null) {
            String string = stringArray[n];
            namespace2.put(string, namespace);
        }
    }

    public Object remove(String string) {
        return this.getData().remove(string);
    }

    public Map toMap() {
        return new HashMap(this.getData());
    }

    protected void setParent(Namespace namespace) {
        this._parent = namespace;
    }

    protected Map getData() {
        return this._data;
    }

    protected String translateKey(String string) {
        return string;
    }

    private Namespace findNamespace(String[] stringArray, int n) {
        Namespace namespace = this;
        int n2 = 0;
        while (n2 < n) {
            Object object = namespace.get(stringArray[n2]);
            if (object == null || object.getClass() != Namespace.class) {
                return null;
            }
            namespace = (Namespace)object;
            ++n2;
        }
        return namespace;
    }
}

