/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public final class PatternFilter {
    private boolean _include;
    private String _pattern;
    static final int DOES_NOT_CONSUME = -1;
    static final int CONSUMES_ONLY = 0;
    static final int CONSUMES_AND_MATCHES = 1;
    private static int END = -1;
    private static int CHAR = 0;
    private static int SLASH = 1;
    private static int STAR = 2;
    private static int STARSTAR = 3;
    private static int QMARK = 4;

    private PatternFilter(boolean bl, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this._include = bl;
        this._pattern = string;
    }

    public static PatternFilter newInclude(String string) {
        return new PatternFilter(true, string);
    }

    public static PatternFilter newExclude(String string) {
        return new PatternFilter(false, string);
    }

    public static PatternFilter fromStr(String string) {
        boolean bl;
        if (string == null || string.length() < 2) {
            throw new IllegalArgumentException();
        }
        char c = string.charAt(0);
        if (c == '-') {
            bl = false;
        } else if (c == '+') {
            bl = true;
        } else {
            throw new IllegalArgumentException("Filter type '" + c + "' not recognized.");
        }
        String string2 = string.substring(1);
        return new PatternFilter(bl, string2);
    }

    public String toStr() {
        StringBuffer stringBuffer = new StringBuffer(this._pattern.length() + 1);
        stringBuffer.append(this._include ? "+" : "-");
        stringBuffer.append(this._pattern);
        return stringBuffer.toString();
    }

    public boolean isInclude() {
        return this._include;
    }

    public boolean isExclude() {
        return this._include ^ true;
    }

    public boolean containsWildcard() {
        if (this._pattern != null) {
            return this._pattern.indexOf(42) >= 0;
        }
        return false;
    }

    public void setInclude(boolean bl) {
        this._include = bl;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String string) {
        if (string != null && string.length() > 0) {
            this._pattern = string;
        }
    }

    public boolean matches(String string) {
        if (string == null) {
            return false;
        }
        if ("**".equals(this._pattern)) {
            return true;
        }
        return this.matchesImpl(string, new int[]{0, 0});
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this._pattern.length() + 1);
        stringBuffer.append(this._include ? "Include " : "Exclude ");
        stringBuffer.append(this._pattern);
        return stringBuffer.toString();
    }

    int consumes(String string) {
        if (this._pattern == null || string == null) {
            return -1;
        }
        if ("**".equals(this._pattern)) {
            return 1;
        }
        int[] nArray = new int[]{0, 0};
        boolean bl = this.matchesImpl(string, nArray);
        if (bl) {
            return 1;
        }
        if ("".equals(string) && this.isInclude()) {
            return 0;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (n == string.length() && (this._pattern.charAt(n2) == '/' || n > 0 && n2 > 0 && this._pattern.charAt(n2 - 1) == '/')) {
            return 0;
        }
        return -1;
    }

    private int nextPatternUnit_not_yet_complete(int[] nArray) {
        int n = nArray[1];
        int n2 = this._pattern.length();
        if (n >= n2) {
            return END;
        }
        char c = this._pattern.charAt(n++);
        switch (c) {
            case '*': {
                int n3 = 1;
                while (n < n2) {
                    if (this._pattern.charAt(n) == '*') {
                        ++n3;
                        ++n;
                        continue;
                    }
                    if (!"/**".equals(this._pattern.substring(n, n + 3))) break;
                    ++n3;
                    n += 3;
                }
                return n3 == 1 ? STAR : STARSTAR;
            }
            case '/': {
                return SLASH;
            }
            case '?': {
                return QMARK;
            }
        }
        return CHAR;
    }

    private boolean matchesImpl(String string, int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        try {
            int n3 = string.length();
            int n4 = this._pattern.length();
            block2: while (n < n3 && n2 < n4) {
                if (this._pattern.charAt(n2) == '*') {
                    boolean bl;
                    boolean bl2 = true;
                    if (n2 > 0) {
                        bl2 = this._pattern.charAt(n2 - 1) == '/';
                    }
                    int n5 = 0;
                    while (n2 < n4 && this._pattern.charAt(n2) == '*') {
                        ++n5;
                        ++n2;
                    }
                    boolean bl3 = bl = n5 > 1;
                    if (n2 >= n4) {
                        if (bl) {
                            boolean bl4 = true;
                            nArray[0] = n;
                            nArray[1] = n2;
                            return bl4;
                        }
                        boolean bl5 = string.indexOf(47, n) < 0;
                        nArray[0] = n;
                        nArray[1] = n2;
                        return bl5;
                    }
                    boolean bl6 = false;
                    if (bl && bl2) {
                        while (n2 < n4 && this._pattern.charAt(n2) == '/') {
                            bl6 = true;
                            ++n2;
                        }
                        if (n2 >= n4) {
                            boolean bl7 = true;
                            nArray[0] = n;
                            nArray[1] = n2;
                            return bl7;
                        }
                    }
                    char c = this._pattern.charAt(n2);
                    boolean bl8 = bl2 && bl6;
                    char c2 = n > 0 ? string.charAt(n - 1) : (char)'\u0000';
                    while (n < n3) {
                        char c3 = c2;
                        c2 = string.charAt(n);
                        if (!(c2 != c && c != '*' || !this.matchesImpl(string, new int[]{n, n2}) || (!bl8 || c3 != '/' && c3 != '\u0000') && bl8)) {
                            boolean bl9 = true;
                            nArray[0] = n;
                            nArray[1] = n2;
                            return bl9;
                        }
                        if (c2 == '/') {
                            if (!bl) continue block2;
                            if (this.matchesImpl(string, new int[]{n, n2})) {
                                boolean bl10 = true;
                                nArray[0] = n;
                                nArray[1] = n2;
                                return bl10;
                            }
                        }
                        ++n;
                    }
                    continue;
                }
                if (this._pattern.charAt(n2) == string.charAt(n)) {
                    ++n2;
                    ++n;
                    continue;
                }
                boolean bl = false;
                nArray[0] = n;
                nArray[1] = n2;
                return bl;
            }
            int n6 = n2;
            while (n2 < n4) {
                if (this._pattern.charAt(n2) != '*') break;
                ++n2;
            }
            if (n2 < n4 && this._pattern.charAt(n2) != '/') {
                n2 = n6;
            }
            if (n == n3) {
                boolean bl = n2 == n4;
                nArray[0] = n;
                nArray[1] = n2;
                return bl;
            }
            if (string.charAt(n) == '/') {
                boolean bl = true;
                nArray[0] = n;
                nArray[1] = n2;
                return bl;
            }
            if (n2 == 0) {
                boolean bl = false;
                nArray[0] = n;
                nArray[1] = n2;
                return bl;
            }
            boolean bl = this._pattern.charAt(n2 - 1) == '/';
            nArray[0] = n;
            nArray[1] = n2;
            return bl;
        }
        catch (Throwable throwable) {
            nArray[0] = n;
            nArray[1] = n2;
            throw throwable;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PatternFilter)) {
            return false;
        }
        PatternFilter patternFilter = (PatternFilter)object;
        return this._include == patternFilter._include && this._pattern.equals(patternFilter._pattern);
    }
}

