/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class PatternFilters
extends HashStructureAdapter {
    public static final String DATA_KEY = "pattern-filters";
    private transient PatternFilter[] _filters;

    private PatternFilters(HashStructure hashStructure) {
        super(hashStructure);
        this.refreshFilters();
    }

    private void refreshFilters() {
        ListStructure listStructure = this._hash.getListStructure(DATA_KEY);
        if (listStructure != null) {
            ArrayList<PatternFilter> arrayList = new ArrayList<PatternFilter>();
            Iterator iterator = listStructure.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                arrayList.add(PatternFilter.fromStr(string));
            }
            this._filters = PatternFilters.toArray(arrayList);
        } else {
            this._filters = null;
        }
    }

    public static PatternFilters getInstance(HashStructure hashStructure) {
        return new PatternFilters(hashStructure);
    }

    public Object copyTo(Object object) {
        PatternFilters patternFilters = (PatternFilters)((Object)super.copyTo(object));
        patternFilters.refreshFilters();
        return patternFilters;
    }

    public PatternFilter[] getFilters() {
        return this._filters != null ? (PatternFilter[])this._filters.clone() : null;
    }

    public void setFilters(PatternFilter[] patternFilterArray) {
        if (patternFilterArray != null) {
            int n = patternFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (patternFilterArray[n2] == null) {
                    throw new IllegalArgumentException();
                }
                ++n2;
            }
            if (this._filters != null && Arrays.equals(this._filters, patternFilterArray)) {
                return;
            }
        }
        this._filters = patternFilterArray;
        this.updateListStructure();
    }

    public void addInclude(String string) {
        this.addInclude(string, true);
    }

    public void addInclude(String string, boolean bl) {
        if (string != null) {
            this.addFilterImpl(PatternFilter.newInclude(string), bl);
        }
    }

    public void addExclude(String string) {
        this.addExclude(string, true);
    }

    public void addExclude(String string, boolean bl) {
        if (string != null) {
            this.addFilterImpl(PatternFilter.newExclude(string), bl);
        }
    }

    public boolean containsFilters() {
        return this._hash.containsKey(DATA_KEY);
    }

    public void removeFilters() {
        this._hash.remove(DATA_KEY);
    }

    public static boolean containsFilters(HashStructure hashStructure) {
        return hashStructure.containsKey(DATA_KEY);
    }

    public static void removeFilters(HashStructure hashStructure) {
        hashStructure.remove(DATA_KEY);
    }

    public PatternFilter findMatchingFilter(String string) {
        if (this._filters != null) {
            int n = this._filters.length;
            int n2 = 0;
            while (n2 < n) {
                PatternFilter patternFilter = this._filters[n2];
                if (patternFilter != null && patternFilter.matches(string)) {
                    return patternFilter;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isIncluded(String string) {
        PatternFilter patternFilter = this.findMatchingFilter(string);
        return patternFilter != null ? patternFilter.isInclude() : false;
    }

    public TriStateBoolean inferFromFilters(String string) {
        if (this._filters != null) {
            int n = this._filters.length;
            int n2 = 0;
            while (n2 < n) {
                PatternFilter patternFilter = this._filters[n2];
                if (patternFilter != null) {
                    int n3 = patternFilter.consumes(string);
                    if (n3 == 0) {
                        if (patternFilter.isInclude()) {
                            return TriStateBoolean.TRI_STATE;
                        }
                    } else if (n3 == 1) {
                        return TriStateBoolean.getState(patternFilter.isInclude());
                    }
                }
                ++n2;
            }
        }
        return TriStateBoolean.FALSE;
    }

    private void addFilterImpl(PatternFilter patternFilter, boolean bl) {
        ArrayList<PatternFilter> arrayList;
        block23: {
            String string = patternFilter.getPattern();
            arrayList = new ArrayList<PatternFilter>();
            if (this._filters != null) {
                arrayList.addAll(Arrays.asList(this._filters));
            }
            if (arrayList.size() == 0) {
                if (patternFilter.isExclude()) {
                    return;
                }
            } else if (bl) {
                PatternFilter patternFilter2;
                if ("**".equals(string) && (patternFilter2 = (PatternFilter)arrayList.get(0)) != null && "**".equals(patternFilter2.getPattern())) {
                    arrayList.remove(0);
                }
                if (!PatternFilters.containsWildcard(string)) {
                    Iterator iterator = arrayList.iterator();
                    boolean bl2 = false;
                    while (iterator.hasNext()) {
                        PatternFilter patternFilter3 = (PatternFilter)iterator.next();
                        if (patternFilter3 == null) continue;
                        String string2 = patternFilter3.getPattern();
                        if (string2 != null) {
                            if ("**".equals(string2)) {
                                if (patternFilter3.isInclude() == patternFilter.isInclude()) {
                                    this.setFiltersImpl(arrayList);
                                    return;
                                }
                            } else if (patternFilter3.matches(string)) {
                                boolean bl3;
                                boolean bl4 = bl3 = patternFilter3.isInclude() == patternFilter.isInclude();
                                if (PatternFilters.containsWildcard(string2)) {
                                    if (bl3) {
                                        this.setFiltersImpl(arrayList);
                                        return;
                                    }
                                } else {
                                    if (string2.equals(string)) {
                                        iterator.remove();
                                        if (bl3) continue;
                                        bl2 = true;
                                        continue;
                                    }
                                    if (bl3) {
                                        this.setFiltersImpl(arrayList);
                                        return;
                                    }
                                }
                            } else {
                                if (string2.startsWith(string) && (string.endsWith("/") || string2.charAt(string.length()) == '/')) {
                                    iterator.remove();
                                    continue;
                                }
                                if (!string.startsWith(string2) || !string2.endsWith("/") && string.charAt(string2.length()) != '/') continue;
                                if (patternFilter3.isInclude() == patternFilter.isInclude()) {
                                    this.setFiltersImpl(arrayList);
                                    return;
                                }
                            }
                        }
                        break block23;
                    }
                    if (bl2 && patternFilter.isExclude()) {
                        this.setFiltersImpl(arrayList);
                        return;
                    }
                    if (arrayList.size() == 0 && patternFilter.isExclude()) {
                        this.setFiltersImpl(arrayList);
                        return;
                    }
                }
            }
        }
        arrayList.add(0, patternFilter);
        this.setFiltersImpl(arrayList);
    }

    private void setFiltersImpl(ArrayList arrayList) {
        this._filters = PatternFilters.toArray(arrayList);
        this.updateListStructure();
    }

    private void updateListStructure() {
        if (this._filters == null) {
            this._hash.remove(DATA_KEY);
        } else {
            ListStructure listStructure = this._hash.getListStructure(DATA_KEY);
            if (listStructure == null) {
                listStructure = ListStructure.newInstance();
                this._hash.putListStructure(DATA_KEY, listStructure);
            }
            listStructure.clear();
            int n = this._filters.length;
            int n2 = 0;
            while (n2 < n) {
                listStructure.add((Object)this._filters[n2].toStr());
                ++n2;
            }
        }
    }

    private static PatternFilter[] toArray(ArrayList arrayList) {
        return arrayList.toArray(new PatternFilter[arrayList.size()]);
    }

    private static boolean containsWildcard(String string) {
        return string.indexOf(42) >= 0;
    }
}

