/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizerEx
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private boolean allowQuotedStrings;
    private boolean keepQuotes;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char c = '\u0000';
        int n = 0;
        while (n < this.delimiters.length()) {
            char c2 = this.delimiters.charAt(n);
            if (c < c2) {
                c = c2;
            }
            ++n;
        }
        this.maxDelimChar = c;
    }

    public StringTokenizerEx(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.str = string;
        this.maxPosition = string.length();
        this.delimiters = string2;
        this.retDelims = bl;
        this.allowQuotedStrings = bl2;
        this.keepQuotes = bl3;
        this.setMaxDelimChar();
        if (bl2 && string2.indexOf(34) > -1) {
            throw new IllegalArgumentException("A '\"' character can not be a delimiter if allowQuotedStrings==-true");
        }
    }

    public StringTokenizerEx(String string, String string2, boolean bl) {
        this(string, string2, bl, false, false);
    }

    public StringTokenizerEx(String string, String string2) {
        this(string, string2, false);
    }

    public StringTokenizerEx(String string) {
        this(string, " \t\n\r\f", false);
    }

    private int skipDelimiters(int n) {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        while (!this.retDelims && n2 < this.maxPosition) {
            char c = this.str.charAt(n2);
            if (this.allowQuotedStrings && c == '\"' || c > this.maxDelimChar || this.delimiters.indexOf(c) < 0) break;
            ++n2;
        }
        return n2;
    }

    private int scanToken(int n) {
        char c;
        int n2 = n;
        int n3 = 32;
        boolean bl = false;
        while (n2 < this.maxPosition) {
            char c2 = this.str.charAt(n2);
            if (this.allowQuotedStrings && c2 == '\"' && n3 != 92) {
                if (bl) {
                    ++n2;
                    break;
                }
                bl = true;
            }
            if (c2 <= this.maxDelimChar && this.delimiters.indexOf(c2) >= 0 && !bl) break;
            n3 = c2 == '\\' && n3 == 92 ? 32 : (int)c2;
            ++n2;
        }
        if (this.retDelims && n == n2 && (c = this.str.charAt(n2)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++n2;
        }
        return n2;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        if (this.allowQuotedStrings && this.str.charAt(n) == '\"' && this.str.charAt(this.currentPosition - 1) == '\"') {
            if (this.keepQuotes) {
                return this.str.substring(n, this.currentPosition);
            }
            return this.str.substring(n + 1, this.currentPosition - 1);
        }
        return this.str.substring(n, this.currentPosition);
    }

    public String nextToken(String string) {
        this.delimiters = string;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int n = 0;
        int n2 = this.currentPosition;
        while (n2 < this.maxPosition) {
            if ((n2 = this.skipDelimiters(n2)) >= this.maxPosition) break;
            n2 = this.scanToken(n2);
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        String string = "\"1 2 \"3  4                ";
        int n = 0;
        StringTokenizerEx stringTokenizerEx = new StringTokenizerEx(string, " \t\n\r\f", false, true, true);
        while (stringTokenizerEx.hasMoreTokens()) {
            System.out.println("[" + n + "] [" + stringTokenizerEx.nextToken() + "]");
            ++n;
        }
    }
}

