/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.javatools.buffer.TextBuffer;

public final class TextBufferStreamFactory {
    public static InputStream getInputStream(TextBuffer textBuffer) {
        return TextBufferStreamFactory.getInputStream(textBuffer, null);
    }

    public static InputStream getInputStream(TextBuffer textBuffer, String string) {
        if (textBuffer == null) {
            throw new IllegalArgumentException("null text buffer");
        }
        char[] cArray = TextBufferStreamFactory.getCharData(textBuffer);
        byte[] byArray = TextBufferStreamFactory.char2Byte(cArray, string);
        return new ByteArrayInputStream(byArray);
    }

    public static OutputStream getOutputStream(TextBuffer textBuffer) {
        if (textBuffer == null) {
            throw new IllegalArgumentException("null text buffer");
        }
        textBuffer.writeLock();
        1 var1_1 = new 1(textBuffer);
        return var1_1;
    }

    private static char[] getCharData(TextBuffer textBuffer) {
        textBuffer.readLock();
        try {
            int n = textBuffer.getLength();
            char[] cArray = textBuffer.getChars(0, n);
            textBuffer.readUnlock();
            return cArray;
        }
        catch (Throwable throwable) {
            textBuffer.readUnlock();
            throw throwable;
        }
    }

    private static byte[] char2Byte(char[] cArray, String string) {
        String string2 = new String(cArray);
        if (string != null) {
            try {
                byte[] byArray = string2.getBytes(string);
                return byArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2.getBytes();
    }

    public static final class 1
    extends ByteArrayOutputStream {
        private final /* synthetic */ TextBuffer v$textBuffer;

        public void close() throws IOException {
            super.close();
            byte[] byArray = this.toByteArray();
            String string = new String(byArray);
            char[] cArray = string.toCharArray();
            int n = this.v$textBuffer.getLength();
            this.v$textBuffer.remove(0, n);
            this.v$textBuffer.insert(0, cArray);
            this.v$textBuffer.writeUnlock();
        }

        public 1(TextBuffer textBuffer) {
            this.v$textBuffer = textBuffer;
        }
    }
}

