/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Timer;
import oracle.ide.util.AddinPolicyUtils;

public class TimedCache {
    public static final int DEFAULT_EXPIRATION = 10;
    public static final int MAXIMUM_EXPIRATION = 1000;
    public static final int NEVER_EXPIRES = 0;
    private int defaultExpiration;
    private final HashMap cacheMap;
    private static final boolean DEBUG_OUTPUT = false;
    private static final int EXPIRATION_UNIT = 60000;

    public TimedCache() {
        this(10);
    }

    public TimedCache(int n) {
        this.setDefaultExpiration(n);
        this.cacheMap = new HashMap(5);
    }

    public Object get(Object object) {
        if (object == null) {
            throw new NullPointerException("get(): null key not allowed");
        }
        return this.getFromCache(object);
    }

    public void put(Object object, Object object2) {
        this.put(object, object2, this.defaultExpiration);
    }

    public void put(Object object, Object object2, int n) {
        if (object == null) {
            throw new NullPointerException("put(): null key not allowed");
        }
        if (object2 == null) {
            this.remove(object);
        } else {
            n = this.sanitizeExpiration(n);
            this.putIntoCache(object, object2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this.cacheMap.remove(object);
            if (entry != null) {
                Entry.mav$removeTimer(entry);
            }
            Object object2 = entry != null ? Entry.ra$cache(entry) : null;
            return object2;
        }
    }

    public void setDefaultExpiration(int n) {
        this.defaultExpiration = this.sanitizeExpiration(n);
    }

    public void setExpiration(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("setExpire(): null key not allowed");
        }
        n = this.sanitizeExpiration(n);
        this.changeExpiration(object, n);
    }

    public void clear() {
        this.clearCache();
    }

    private int sanitizeExpiration(int n) {
        if ((n = Math.min(1000, n)) < 0) {
            n = 10;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromCache(Object object) {
        Object object2 = null;
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this.cacheMap.get(object);
            if (entry != null) {
                Entry.mav$restartTimer(entry);
                object2 = Entry.ra$cache(entry);
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIntoCache(Object object, Object object2, int n) {
        Entry entry = new Entry(object, object2, n, null);
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry entry2 = this.cacheMap.put(object, entry);
            if (entry2 != null) {
                Entry.mav$removeTimer(entry2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Collection collection = this.cacheMap.values();
            for (Entry entry : collection) {
                if (entry == null) continue;
                Entry.mav$removeTimer(entry);
            }
            this.cacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeExpiration(Object object, int n) {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry entry = (Entry)this.cacheMap.get(object);
            if (entry != null) {
                Entry.mav$changeExpiration(entry, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entryExpired(Entry entry) {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry entry2 = (Entry)this.cacheMap.get(Entry.ra$key(entry));
            if (entry2 == entry) {
                this.cacheMap.remove(Entry.ra$key(entry));
            }
            Entry.mav$removeTimer(entry);
        }
    }

    private static void debugPrint(String string) {
        System.out.print("Time: " + System.currentTimeMillis());
        System.out.print(" Thread: " + Thread.currentThread().toString());
        System.out.println(" Out: " + string);
    }

    static void mav$entryExpired(TimedCache timedCache, Entry entry) {
        timedCache.entryExpired(entry);
    }

    private final class Entry
    implements ActionListener {
        private Object key;
        private Object cache;
        private Timer timer;

        private Entry(Object object, Object object2, int n) {
            this.key = object;
            this.cache = object2;
            this.changeExpiration(n);
        }

        private void changeExpiration(int n) {
            if (n == 0) {
                this.removeTimer();
            } else {
                int n2 = n * 60000;
                if (this.timer == null) {
                    this.timer = new Timer(n2, this);
                    this.timer.setRepeats(false);
                } else {
                    this.timer.setInitialDelay(n2);
                }
                this.restartTimer();
            }
        }

        private void restartTimer() {
            if (this.timer != null) {
                boolean bl = AddinPolicyUtils.setWarnWhenCreatingThreads(false);
                this.timer.restart();
                AddinPolicyUtils.setWarnWhenCreatingThreads(bl);
            }
        }

        private void removeTimer() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer.removeActionListener(this);
                this.timer = null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TimedCache.mav$entryExpired(TimedCache.this, this);
        }

        static Object ra$key(Entry entry) {
            return entry.key;
        }

        static void mav$removeTimer(Entry entry) {
            entry.removeTimer();
        }

        static void mav$changeExpiration(Entry entry, int n) {
            entry.changeExpiration(n);
        }

        Entry(Object object, Object object2, int n, 1 var5_5) {
            this(object, object2, n);
        }

        static void mav$restartTimer(Entry entry) {
            entry.restartTimer();
        }

        static Object ra$cache(Entry entry) {
            return entry.cache;
        }

        public final class 1 {
        }
    }
}

