/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

public class TriStateBoolean {
    public static final TriStateBoolean TRUE = new TriStateBoolean();
    public static final TriStateBoolean TRI_STATE = new TriStateBoolean();
    public static final TriStateBoolean FALSE = new TriStateBoolean();
    public static final TriStateBoolean UNDEF = new TriStateBoolean();

    private TriStateBoolean() {
    }

    public static TriStateBoolean getState(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static TriStateBoolean getState(Boolean bl) {
        if (bl == null) {
            return TRI_STATE;
        }
        return TriStateBoolean.getState((boolean)bl);
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isTriState() {
        return this == TRI_STATE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public boolean isUndef() {
        return this == UNDEF;
    }

    public boolean booleanValue() {
        if (this == TRI_STATE || this == UNDEF) {
            throw new IllegalStateException();
        }
        return this == TRUE;
    }

    public TriStateBoolean toggle() {
        if (this == FALSE) {
            return TRUE;
        }
        return FALSE;
    }

    public TriStateBoolean aggregate(TriStateBoolean triStateBoolean) {
        if (triStateBoolean == null) {
            return null;
        }
        if (this == UNDEF) {
            return triStateBoolean;
        }
        if (triStateBoolean == UNDEF) {
            return this;
        }
        if (this == TRI_STATE || triStateBoolean == TRI_STATE || this != triStateBoolean) {
            return TRI_STATE;
        }
        return this;
    }

    public TriStateBoolean and(TriStateBoolean triStateBoolean) {
        if (triStateBoolean == null) {
            return null;
        }
        if (this == UNDEF) {
            return triStateBoolean;
        }
        if (triStateBoolean == UNDEF) {
            return this;
        }
        if (this == TRI_STATE || triStateBoolean == TRI_STATE) {
            return TRI_STATE;
        }
        if (this == FALSE || triStateBoolean == FALSE) {
            return FALSE;
        }
        return TRUE;
    }

    public TriStateBoolean or(TriStateBoolean triStateBoolean) {
        if (triStateBoolean == null) {
            return null;
        }
        if (this == UNDEF) {
            return triStateBoolean;
        }
        if (triStateBoolean == UNDEF) {
            return this;
        }
        if (this == TRI_STATE || triStateBoolean == TRI_STATE) {
            return TRI_STATE;
        }
        if (this == TRUE || triStateBoolean == TRUE) {
            return TRUE;
        }
        return FALSE;
    }

    public TriStateBoolean not() {
        if (this == TRI_STATE) {
            return TRI_STATE;
        }
        if (this == UNDEF) {
            return UNDEF;
        }
        if (this == FALSE) {
            return TRUE;
        }
        return FALSE;
    }
}

