/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.StringTokenizer;
import oracle.javatools.marshal.StringConversion;

public final class VersionNumber
implements StringConversion,
Comparable {
    private final String[] _versionParts;
    private transient int _hash;

    public VersionNumber(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        this._versionParts = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this._versionParts[n2] = stringTokenizer.nextToken();
            ++n2;
        }
    }

    public int countParts() {
        return this._versionParts.length;
    }

    public String getPart(int n) {
        if (n < 0 || n >= this._versionParts.length) {
            return null;
        }
        return this._versionParts[n];
    }

    public final boolean isAfter(VersionNumber versionNumber) {
        int n = this.compareToImpl(versionNumber);
        return n > 0;
    }

    public final boolean isAfter(VersionNumber versionNumber, boolean bl) {
        int n = this.compareToImpl(versionNumber);
        return bl ? n >= 0 : n > 0;
    }

    public final boolean isBefore(VersionNumber versionNumber) {
        int n = this.compareToImpl(versionNumber);
        return n < 0;
    }

    public boolean isBefore(VersionNumber versionNumber, boolean bl) {
        int n = this.compareToImpl(versionNumber);
        return bl ? n <= 0 : n < 0;
    }

    public int compareTo(Object object) {
        return this.compareToImpl((VersionNumber)object);
    }

    private int compareToImpl(VersionNumber versionNumber) {
        if (versionNumber == null) {
            return 1;
        }
        int n = this._versionParts.length;
        int n2 = versionNumber.countParts();
        int n3 = 0;
        while (n3 < n) {
            block9: {
                String string = versionNumber.getPart(n3);
                if (string == null) {
                    return 1;
                }
                String string2 = this._versionParts[n3];
                try {
                    int n4 = Integer.parseInt(string2);
                    int n5 = Integer.parseInt(string);
                    if (n4 < n5) {
                        int n6 = -1;
                        return n6;
                    }
                    if (n4 > n5) {
                        int n7 = 1;
                        return n7;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    int n8 = string2.compareTo(string);
                    if (n8 < 0) {
                        int n9 = -1;
                        return n9;
                    }
                    if (n8 <= 0) break block9;
                    int n10 = 1;
                    return n10;
                }
            }
            ++n3;
        }
        if (n == n2) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((VersionNumber)object);
    }

    private boolean equalsImpl(VersionNumber versionNumber) {
        int n = this._versionParts.length;
        if (n != versionNumber.countParts()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = versionNumber.getPart(n2);
            if (string == null || !string.equals(this._versionParts[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n = this._hash;
        if (n == 0) {
            int n2 = this._versionParts.length;
            int n3 = 0;
            while (n3 < n2) {
                n = 31 * n + Integer.parseInt(this._versionParts[n3]);
                ++n3;
            }
            this._hash = n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(25);
        int n = this._versionParts.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this._versionParts[n2]).append('.');
            ++n2;
        }
        if (n > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

