/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.WeightedList;
import oracle.ide.view.View;

public class WeightedController
implements Controller {
    public static final Controller USE_ACTIVE_VIEW_CONTROLLER = new 2();
    public static final Controller NOOP_CONTROLLER = new 1();
    private WeightedList _controllers;
    private static final String ACTION_CONTROLLER = "WeightedController";

    void $init$() {
        this._controllers = new WeightedList(3);
    }

    public WeightedController() {
        this.$init$();
    }

    public WeightedController(Controller controller, Controller controller2) {
        this.$init$();
        if (controller != null) {
            this._controllers.add(controller, Double.MIN_VALUE);
        }
        if (controller2 != null) {
            this._controllers.add(controller2, Double.MAX_VALUE);
        }
    }

    public void addController(Controller controller, double d) {
        if (controller == null || d == Double.MAX_VALUE || d == Double.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        this._controllers.add(controller, d);
    }

    public void removeController(Controller controller) {
        this._controllers.remove(controller);
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        String string = "WeightedController.update()";
        Iterator iterator = this._controllers.iterator();
        while (!bl && iterator.hasNext()) {
            Controller controller = (Controller)iterator.next();
            bl = controller.update(ideAction, context);
            if (!bl) continue;
            ideAction.putValue(ACTION_CONTROLLER, new WeakReference<Controller>(controller));
        }
        return bl;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        WeakReference weakReference = (WeakReference)ideAction.getValue(ACTION_CONTROLLER);
        if (weakReference != null) {
            Controller controller = (Controller)weakReference.get();
            if (controller != null && controller.handleEvent(ideAction, context)) {
                return true;
            }
            ideAction.putValue(ACTION_CONTROLLER, null);
        }
        for (Controller controller : this._controllers) {
            if (!controller.handleEvent(ideAction, context)) continue;
            return true;
        }
        return false;
    }

    public static final class 2
    implements Controller {
        public boolean update(IdeAction ideAction, Context context) {
            Controller controller;
            View view = context.getView();
            if (view != null && (controller = view.getController()) != null) {
                return controller.update(ideAction, context);
            }
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            Controller controller;
            View view = context.getView();
            if (view != null && (controller = view.getController()) != null) {
                return controller.handleEvent(ideAction, context);
            }
            return false;
        }
    }

    public static final class 1
    implements Controller {
        public boolean update(IdeAction ideAction, Context context) {
            ideAction.setEnabled(false);
            return true;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return true;
        }
    }
}

