/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.ModelUtil;

public class WeightedList
implements Collection {
    private ArrayList _storage;

    public WeightedList() {
        this._storage = new ArrayList();
    }

    public WeightedList(int n) {
        this._storage = new ArrayList(n);
    }

    public void add(Object object, double d) {
        Entry entry = new Entry(object, d);
        int n = 0;
        while (n < this._storage.size()) {
            Entry entry2 = (Entry)this._storage.get(n);
            if (entry._weight < entry2._weight) {
                this._storage.add(n, entry);
                return;
            }
            ++n;
        }
        this._storage.add(entry);
    }

    public boolean remove(Object object) {
        int n = 0;
        while (n < this._storage.size()) {
            Entry entry = (Entry)this._storage.get(n);
            if (ModelUtil.areEqual((Object)entry._object, (Object)object)) {
                this._storage.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public Iterator iterator() {
        Object[] objectArray = new Object[this._storage.size()];
        int n = 0;
        while (n < this._storage.size()) {
            Entry entry = (Entry)this._storage.get(n);
            objectArray[n] = entry._object;
            ++n;
        }
        List<Object> list = Arrays.asList(objectArray);
        return list.iterator();
    }

    public int size() {
        return this._storage.size();
    }

    public void clear() {
        this._storage.clear();
    }

    public boolean isEmpty() {
        return this._storage.isEmpty();
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        while (n < this._storage.size()) {
            Entry entry = (Entry)this._storage.get(n);
            objectArray[n] = entry._object;
            ++n;
        }
        return objectArray;
    }

    public boolean add(Object object) {
        this.add(object, 0.0);
        return true;
    }

    private int indexOf(Object object) {
        if (object != null) {
            int n = 0;
            while (n < this._storage.size()) {
                Entry entry = (Entry)this._storage.get(n);
                if (object.equals(entry._object)) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this._storage.size()) {
                Entry entry = (Entry)this._storage.get(n);
                if (entry._object == null) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public boolean addAll(Collection collection) {
        for (Object e : collection) {
            if (this.add(e)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            if (!this.remove(e)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n = this._storage.size() - 1;
        while (n >= 0) {
            Entry entry = (Entry)this._storage.get(n);
            if (!collection.contains(entry._object)) {
                this._storage.remove(n);
                bl = true;
            }
            --n;
        }
        return bl;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        Object[] objectArray2 = objectArray == null || objectArray.length < n ? new Object[n] : objectArray;
        int n2 = 0;
        while (n2 < this._storage.size()) {
            Entry entry = (Entry)this._storage.get(n2);
            objectArray2[n2] = entry._object;
            ++n2;
        }
        while (n2 < this._storage.size()) {
            objectArray2[n2] = null;
            ++n2;
        }
        return objectArray2;
    }

    private static class Entry {
        Object _object;
        double _weight;

        public Entry(Object object, double d) {
            this._object = object;
            this._weight = d;
        }
    }
}

