/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;

public class DefaultDropTargetListener
implements DropTargetListener {
    public static final DataFlavor JAVA_FILELIST_FLAVOR = DataFlavor.javaFileListFlavor;
    private DropSite _dropSite;

    public DefaultDropTargetListener(DropSite dropSite) {
        this._dropSite = dropSite;
        new DropTarget(dropSite.getComponent(), dropSite.getActions(), this);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.doDefaultAction(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.doDefaultAction(dropTargetDragEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.doDefaultAction(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if ((dropTargetDropEvent.getSourceActions() & this.getActions()) == 0) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            for (DataFlavor dataFlavor : this.getFlavors()) {
                if (!dropTargetDropEvent.isDataFlavorSupported(dataFlavor)) continue;
                this._dropSite.handleDrop(dataFlavor, dropTargetDropEvent, transferable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    protected void doDefaultAction(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOK(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    protected boolean isDragOK(DropTargetDragEvent dropTargetDragEvent) {
        if ((dropTargetDragEvent.getDropAction() & this.getActions()) == 0) {
            return false;
        }
        return this.isDataFlavorSupported(dropTargetDragEvent);
    }

    protected boolean isDataFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        for (DataFlavor dataFlavor : this.getFlavors()) {
            if (!dropTargetDragEvent.isDataFlavorSupported(dataFlavor)) continue;
            return this._dropSite.canDrop(dataFlavor, dropTargetDragEvent);
        }
        return false;
    }

    private int getActions() {
        return this._dropSite.getActions();
    }

    private List getFlavors() {
        return this._dropSite.getFlavors();
    }

    public interface DropSite {
        public Component getComponent();

        public int getActions();

        public List getFlavors();

        public boolean canDrop(DataFlavor var1, DropTargetDragEvent var2);

        public void handleDrop(DataFlavor var1, DropTargetDropEvent var2, Transferable var3) throws IOException, UnsupportedFlavorException;
    }
}

