/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util.dnd;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.util.dnd.DropHelper;

public class DragDropManager {
    private HashMap registry = new HashMap();
    private static DragDropManager instance;
    private static WeightComparator comparator;

    private DragDropManager() {
        comparator = new WeightComparator(null);
    }

    public static DragDropManager getInstance() {
        if (instance == null) {
            instance = new DragDropManager();
        }
        return instance;
    }

    public void registerDragHelperForInstance(DragHelper dragHelper, Class clazz) {
        this.registerDragHelper(dragHelper, clazz, false);
    }

    public void registerDragHelperForType(DragHelper dragHelper, Class clazz) {
        this.registerDragHelper(dragHelper, clazz, true);
    }

    public void unRegisterDragHelperForInstance(DragHelper dragHelper, Class clazz) {
        this.unRegisterDragHelper(dragHelper, clazz, false);
    }

    public void unRegisterDragHelperForType(DragHelper dragHelper, Class clazz) {
        this.unRegisterDragHelper(dragHelper, clazz, true);
    }

    public Iterator getDragHelpers(Class clazz) {
        ArrayList<DragHelper> arrayList = new ArrayList<DragHelper>();
        if (this.registry.keySet().contains(clazz)) {
            RegInfo regInfo = (RegInfo)this.registry.get(clazz);
            arrayList.addAll(regInfo.getDragHelpers(true));
        }
        for (Class clazz2 : this.registry.keySet()) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            RegInfo regInfo = (RegInfo)this.registry.get(clazz2);
            for (DragHelper dragHelper : regInfo.getDragHelpers(false)) {
                if (arrayList.contains(dragHelper)) continue;
                arrayList.add(dragHelper);
            }
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDragHelper(DragHelper dragHelper, Class clazz, boolean bl) {
        if (dragHelper == null) {
            throw new IllegalArgumentException("The DropHelper cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The supplied class cannot be null.");
        }
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            if (!this.registry.containsKey(clazz)) {
                RegInfo regInfo = new RegInfo();
                regInfo.addDragHelper(dragHelper, bl);
                this.registry.put(clazz, regInfo);
            } else {
                RegInfo regInfo = (RegInfo)this.registry.get(clazz);
                regInfo.addDragHelper(dragHelper, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterDragHelper(DragHelper dragHelper, Class clazz, boolean bl) {
        if (dragHelper == null || clazz == null) {
            return;
        }
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            if (this.registry.containsKey(clazz)) {
                RegInfo regInfo = (RegInfo)this.registry.get(clazz);
                regInfo.removeDragHelper(dragHelper, bl);
                if (regInfo.shouldCleanUp()) {
                    regInfo = null;
                    this.registry.remove(clazz);
                }
            }
        }
    }

    public void registerDropHelperForInstance(DropHelper dropHelper, Class clazz) {
        this.registerDropHelper(dropHelper, clazz, false);
    }

    public void registerDropHelperForType(DropHelper dropHelper, Class clazz) {
        this.registerDropHelper(dropHelper, clazz, true);
    }

    public void unRegisterDropHelperForInstance(DropHelper dropHelper, Class clazz) {
        this.unRegisterDropHelper(dropHelper, clazz, false);
    }

    public void unRegisterDropHelperForType(DropHelper dropHelper, Class clazz) {
        this.unRegisterDropHelper(dropHelper, clazz, true);
    }

    public Iterator getDropHelpers(Class clazz) {
        ArrayList<DropHelper> arrayList = new ArrayList<DropHelper>();
        if (this.registry.keySet().contains(clazz)) {
            RegInfo regInfo = (RegInfo)this.registry.get(clazz);
            arrayList.addAll(regInfo.getDropHelpers(true));
        }
        for (Class clazz2 : this.registry.keySet()) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            RegInfo regInfo = (RegInfo)this.registry.get(clazz2);
            for (DropHelper dropHelper : regInfo.getDropHelpers(false)) {
                if (arrayList.contains(dropHelper)) continue;
                arrayList.add(dropHelper);
            }
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDropHelper(DropHelper dropHelper, Class clazz, boolean bl) {
        if (dropHelper == null) {
            throw new IllegalArgumentException("The DropHelper cannot be null.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The supplied class cannot be null.");
        }
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            if (!this.registry.containsKey(clazz)) {
                RegInfo regInfo = new RegInfo();
                regInfo.addDropHelper(dropHelper, bl);
                this.registry.put(clazz, regInfo);
            } else {
                RegInfo regInfo = (RegInfo)this.registry.get(clazz);
                regInfo.addDropHelper(dropHelper, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterDropHelper(DropHelper dropHelper, Class clazz, boolean bl) {
        if (dropHelper == null || clazz == null) {
            return;
        }
        HashMap hashMap = this.registry;
        synchronized (hashMap) {
            if (this.registry.containsKey(clazz)) {
                RegInfo regInfo = (RegInfo)this.registry.get(clazz);
                regInfo.removeDropHelper(dropHelper, bl);
                if (regInfo.shouldCleanUp()) {
                    regInfo = null;
                    this.registry.remove(clazz);
                }
            }
        }
    }

    private static class WeightComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            DropHelper dropHelper = (DropHelper)object;
            DropHelper dropHelper2 = (DropHelper)object2;
            if (dropHelper.getWeight() < dropHelper2.getWeight()) {
                return -1;
            }
            if (dropHelper.getWeight() > dropHelper2.getWeight()) {
                return 1;
            }
            return 0;
        }

        private WeightComparator() {
        }

        WeightComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class RegInfo {
        HelperData matchInstance;
        HelperData matchExactType;

        public RegInfo() {
            this.matchInstance = new HelperData();
            this.matchExactType = new HelperData();
        }

        public boolean shouldCleanUp() {
            return this.matchInstance.getDragHelpers().size() == 0 && this.matchInstance.getDropHelpers().size() == 0 && this.matchExactType.getDragHelpers().size() == 0 && this.matchExactType.getDropHelpers().size() == 0;
        }

        public void addDragHelper(DragHelper dragHelper, boolean bl) {
            if (bl) {
                this.matchExactType.addDragHelper(dragHelper);
            } else {
                this.matchInstance.addDragHelper(dragHelper);
            }
        }

        public List getDragHelpers(boolean bl) {
            if (bl) {
                return this.matchExactType.getDragHelpers();
            }
            return this.matchInstance.getDragHelpers();
        }

        public void removeDragHelper(DragHelper dragHelper, boolean bl) {
            if (bl) {
                this.matchExactType.removeDragHelper(dragHelper);
            } else {
                this.matchInstance.removeDragHelper(dragHelper);
            }
        }

        public void addDropHelper(DropHelper dropHelper, boolean bl) {
            if (bl) {
                this.matchExactType.addDropHelper(dropHelper);
            } else {
                this.matchInstance.addDropHelper(dropHelper);
            }
        }

        public List getDropHelpers(boolean bl) {
            if (bl) {
                return this.matchExactType.getDropHelpers();
            }
            return this.matchInstance.getDropHelpers();
        }

        public void removeDropHelper(DropHelper dropHelper, boolean bl) {
            if (bl) {
                this.matchExactType.removeDropHelper(dropHelper);
            } else {
                this.matchInstance.removeDropHelper(dropHelper);
            }
        }
    }

    private final class HelperData {
        ArrayList drag = new ArrayList(2);
        ArrayList drop = new ArrayList(2);

        public List getDragHelpers() {
            return this.drag;
        }

        public void addDragHelper(DragHelper dragHelper) {
            if (!this.drag.contains(dragHelper)) {
                this.drag.add(dragHelper);
            }
        }

        public void removeDragHelper(DragHelper dragHelper) {
            this.drag.remove(dragHelper);
        }

        public List getDropHelpers() {
            return this.drop;
        }

        public void addDropHelper(DropHelper dropHelper) {
            if (!this.drop.contains(dropHelper)) {
                this.drop.add(dropHelper);
            }
        }

        public void removeDropHelper(DropHelper dropHelper) {
            this.drop.remove(dropHelper);
        }
    }
}

