/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.Pinnable;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

public abstract class AbstractPinnable
extends DockableWindow
implements Observer,
Pinnable,
ViewSelectionListener {
    public static final String TOOLBAR_ITEM = "Toolbar.item";
    public static final String TOOLBAR_ITEM_COUNT = "Toolbar.count";
    private View pinnedView;
    private int pinState;
    private ViewMonitor viewMonitor;
    protected Toolbar toolbar;
    protected boolean isToolbarVisible;
    protected Node _node;
    protected boolean forceUpdate;

    void $init$() {
        this.pinState = 0;
    }

    protected AbstractPinnable(String string) {
        super(string);
        this.$init$();
        this.viewMonitor = new ViewMonitor(null);
        this.viewMonitor.start();
    }

    protected AbstractPinnable(IdeMainWindow ideMainWindow, String string) {
        this(string);
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public void setToolbarVisible(boolean bl) {
        this.isToolbarVisible = bl;
    }

    public void setContext(Context context) {
        View view;
        View view2 = view = context != null ? context.getView() : null;
        if (!this.isViewSupported(view) && view instanceof AbstractPinnable && (view = ((AbstractPinnable)view).getPinnedView()) == null) {
            view = Ide.getMainWindow().getLastActiveView();
        }
        ActiveViewEvent activeViewEvent = new ActiveViewEvent(Ide.getMainWindow(), this.getPinnedView(), view);
        this.activeViewChanged(activeViewEvent);
    }

    protected boolean isSingleton() {
        return false;
    }

    public void stateChange(int n) {
        switch (n) {
            case 1: {
                super.stateChange(n);
                if (this.getPinnedView() == null && this.getPinState() == 0) {
                    this.setPinState(0);
                    break;
                }
                if (this.getPinnedView() != null) {
                    this.getPinnedView().addViewSelectionListener(this);
                }
                this.restorePinTarget();
                this.setPinState(this.getPinState());
                break;
            }
            case 2: {
                super.stateChange(n);
                if (this.getPinnedView() == null) break;
                this.getPinnedView().removeViewSelectionListener(this);
                this.persistPinTarget();
                this.clear();
                break;
            }
            case 3: {
                Ide.getMainWindow().unregisterView(this);
                if (!this.isSingleton()) {
                    this.viewMonitor.stop();
                }
                this.fireViewClosed();
            }
        }
    }

    protected synchronized void activeViewChanged(ActiveViewEvent activeViewEvent) {
        View view = activeViewEvent.getNewView();
        if (!this.isViewSupported(view)) {
            return;
        }
        if (this.getPinState() != 0) {
            return;
        }
        this.setPinnedView(view);
    }

    public synchronized void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        if (this.getPinState() == 2) {
            return;
        }
        this.viewSelectionChangedImpl(viewSelectionEvent.getView());
    }

    private void viewSelectionChangedImpl(View view) {
        Context context = view.getContext();
        this.viewSelectionChanged(context);
    }

    public int getPinState() {
        return this.pinState;
    }

    public synchronized void setPinState(int n) {
        this.pinState = n;
        switch (n) {
            case 0: {
                View view = this.getPinnedView();
                if (view == null || view != this.viewMonitor.getLastSupportedView()) {
                    IdeMainWindow ideMainWindow = Ide.getMainWindow();
                    ActiveViewEvent activeViewEvent = new ActiveViewEvent(ideMainWindow, view, this.viewMonitor.getLastSupportedView());
                    this.activeViewChanged(activeViewEvent);
                    break;
                }
                this.viewSelectionChangedImpl(view);
                break;
            }
            case 1: {
                View view = this.getPinnedView();
                if (view != null) {
                    this.viewSelectionChangedImpl(view);
                    break;
                }
                this.clear();
                break;
            }
            case 2: {
                this.updateTitle(this.getTitleName());
            }
        }
    }

    protected abstract boolean isViewSupported(View var1);

    protected void persistPinTarget() {
    }

    protected void restorePinTarget() {
    }

    protected void viewSelectionChanged(Context context) {
        Node node;
        Node node2 = node = context != null ? context.getNode() : null;
        if (node != this._node) {
            if (this._node != null) {
                this._node.detach(this);
            }
            this._node = node;
            if (this._node != null) {
                this._node.attach(this);
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n;
        int n2 = n = updateMessage != null ? updateMessage.getMessageID() : -1;
        if (n == UpdateMessage.OBJECT_CLOSED) {
            this.objectClosed((Subject)object, updateMessage);
        } else if (n == UpdateMessage.OBJECT_RENAMED) {
            this.objectRenamed((Subject)object, updateMessage);
        }
    }

    protected void objectClosed(Subject subject, UpdateMessage updateMessage) {
        this.setPinnedView(null);
        this.clear();
        1 var3_3 = new 1();
        SwingUtilities.invokeLater(var3_3);
    }

    protected void objectRenamed(Subject subject, UpdateMessage updateMessage) {
        this.setPinnedView(null);
        this.clear();
        this.setPinState(this.getPinState());
    }

    protected void clear() {
        if (this._node != null) {
            this._node.detach(this);
            this._node = null;
        }
    }

    protected View getPinnedView() {
        return this.pinnedView;
    }

    protected synchronized void setPinnedView(View view) {
        if (view != null && view == this.pinnedView) {
            if (!this.forceUpdate) {
                return;
            }
            this.forceUpdate = false;
        }
        if (this.pinnedView != null) {
            this.pinnedView.removeViewSelectionListener(this);
        }
        this.pinnedView = view;
        if (this.pinnedView == null) {
            if (this.getPinState() != 2) {
                this.clear();
            }
        } else {
            this.pinnedView.addViewSelectionListener(this);
            this.viewSelectionChangedImpl(this.pinnedView);
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            AbstractPinnable.this.setPinState(AbstractPinnable.this.getPinState());
        }
    }

    private final class ViewMonitor
    implements ViewListener,
    ActiveViewListener {
        private View lastSupportedView;

        public View getLastSupportedView() {
            return this.lastSupportedView;
        }

        public void start() {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            this.lastSupportedView = AbstractPinnable.this.isViewSupported(ideMainWindow.getLastActiveView()) ? ideMainWindow.getLastActiveView() : null;
            ideMainWindow.addActiveViewListener(this);
        }

        public void stop() {
            Ide.getMainWindow().removeActiveViewListener(this);
            if (this.lastSupportedView != null) {
                this.lastSupportedView.removeViewListener(this);
            }
            this.lastSupportedView = null;
        }

        public void activeViewChanged(ActiveViewEvent activeViewEvent) {
            View view = activeViewEvent.getNewView();
            if (AbstractPinnable.this.isViewSupported(view)) {
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.removeViewListener(this);
                }
                this.lastSupportedView = view;
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.addViewListener(this);
                }
                if (AbstractPinnable.this.isVisible()) {
                    AbstractPinnable.this.activeViewChanged(activeViewEvent);
                }
            }
        }

        public void viewActivated(ViewEvent viewEvent) {
        }

        public void viewDeactivated(ViewEvent viewEvent) {
        }

        public void viewClosed(ViewEvent viewEvent) {
            View view = viewEvent.getView();
            if (view == this.lastSupportedView) {
                if (this.lastSupportedView != null) {
                    this.lastSupportedView.removeViewListener(this);
                }
                this.lastSupportedView = null;
            }
            if (view == AbstractPinnable.this.getPinnedView()) {
                AbstractPinnable.this.setPinnedView(null);
                AbstractPinnable.this.setPinState(AbstractPinnable.this.getPinState());
            }
        }

        private ViewMonitor() {
        }

        ViewMonitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

