/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.ViewId;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;

public abstract class MultiManager
implements Addin,
Controller {
    private IdeAction _showAction;
    private IdeAction _toggleToolbarAction;
    private final List _views;
    private final L _listener;
    private static final String TOOLBAR_VISIBLE_PROP = ".Toolbar.visible";

    void $init$() {
        this._views = new ArrayList();
        this._listener = new L(null);
    }

    public void initialize() {
        Menubar menubar;
        DockStation dockStation;
        DockableFactory dockableFactory = this.getDockableFactory();
        if (dockableFactory != null && (dockStation = DockStation.getDockStation()) != null) {
            dockStation.registerDockableFactory(this.getViewCategory(), dockableFactory);
        }
        if ((menubar = Ide.getMenubar()) != null) {
            String string;
            this._toggleToolbarAction = this.createToggleToolbarAction();
            if (this._toggleToolbarAction != null) {
                this._toggleToolbarAction.putValue("Check", Boolean.TRUE);
                this._toggleToolbarAction.addController(this);
                JMenuItem jMenuItem = menubar.createMenuItem(this._toggleToolbarAction, this.getToggleToolbarMenuWeight());
                menubar.add((Component)jMenuItem, MenuManager.getJMenu("ViewToolbars"));
            }
            if ((string = this.getAcceleratorFile()) != null) {
                KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
                keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), string);
            }
        }
    }

    public final IdeAction getShowAction() {
        if (this._showAction == null) {
            this._showAction = this.createShowAction();
        }
        return this._showAction;
    }

    public DockableView showLastView(Context context) {
        DockableView dockableView = this.getLastView();
        if (dockableView == null) {
            return this.showView(context);
        }
        if (dockableView == Ide.getMainWindow().getLastActiveView() && this._views.size() > 1) {
            this._views.remove(dockableView);
            this._views.add(0, dockableView);
            dockableView = this.getLastView();
        }
        dockableView.show();
        DockStation.getDockStation().activateDockable(dockableView);
        return dockableView;
    }

    public DockableView showView(Context context) {
        DockableView dockableView = this.findOrCreateView(context);
        if (dockableView != null) {
            dockableView.show();
            DockStation.getDockStation().activateDockable(dockableView);
        }
        return dockableView;
    }

    public DockableView getLastView() {
        if (this._views.isEmpty()) {
            return null;
        }
        return (DockableView)this._views.get(this._views.size() - 1);
    }

    public DockableView getNewView(Context context, ViewId viewId) {
        DockableView dockableView = this.createDockableView(context, viewId);
        if (dockableView != null) {
            dockableView.setToolbarVisible(this.isToolbarVisible());
            this.registerView(dockableView);
        }
        return dockableView;
    }

    public Collection getViews() {
        return new ArrayList(this._views);
    }

    public ViewId getDefaultViewId() {
        return new ViewId(this.getViewCategory(), this.getDefaultName());
    }

    protected abstract String getViewCategory();

    protected abstract String getDefaultName();

    protected String getAcceleratorFile() {
        return null;
    }

    protected abstract DockableView createDockableView(Context var1, ViewId var2);

    protected abstract IdeAction createShowAction();

    protected abstract DockableFactory getDockableFactory();

    protected IdeAction createToggleToolbarAction() {
        return null;
    }

    protected float getToggleToolbarMenuWeight() {
        return Float.MAX_VALUE;
    }

    protected ViewId getViewId(Context context) {
        return this.getDefaultViewId();
    }

    protected DockableView findView(ViewId viewId) {
        Dockable dockable;
        if (viewId != null && (dockable = DockStation.getDockStation().getDockable(viewId)) instanceof DockableView) {
            return (DockableView)dockable;
        }
        return null;
    }

    protected DockableView findOrCreateView(Context context) {
        DockableView dockableView;
        ViewId viewId = this.getViewId(context);
        if (viewId == null || viewId.getName() == null) {
            viewId = new ViewId(this.getViewCategory(), Long.toString(new Date().getTime()));
        }
        if ((dockableView = this.findView(viewId)) == null) {
            DockableView dockableView2 = this.getRelativeView(context, viewId);
            Collection collection = this.getViews();
            int n = collection != null ? collection.size() : 0;
            dockableView = this.getNewView(context, viewId);
            if (dockableView != null) {
                int n2;
                DockStation dockStation = DockStation.getDockStation();
                if (dockableView2 != null && ((n2 = dockStation.getDockableStatus(dockableView2)) & 1) != 1) {
                    dockableView2 = null;
                }
                DockingParam dockingParam = new DockingParam();
                if (n == 0) {
                    int n3 = this.getOrientation(viewId, dockableView2);
                    if (dockableView2 != null) {
                        dockingParam.setPosition(dockableView2, n3);
                    } else {
                        dockingParam.setPosition(n3);
                    }
                } else {
                    dockingParam.setTabbedWith(dockableView2);
                }
                dockStation.dock(dockableView, dockingParam);
            }
        }
        return dockableView;
    }

    protected DockableView getRelativeView(Context context, ViewId viewId) {
        String string;
        String string2 = string = viewId != null ? viewId.getName() : null;
        if (string != null && string.equals(this.getDefaultName())) {
            return null;
        }
        return this.getLastView();
    }

    protected int getOrientation(ViewId viewId, DockableView dockableView) {
        return dockableView != null ? 4 : 0;
    }

    protected boolean isToolbarVisible() {
        String string = Ide.getProperty(this.getViewCategory() + TOOLBAR_VISIBLE_PROP, Boolean.TRUE.toString());
        return Boolean.valueOf(string);
    }

    protected void setToolbarVisible(boolean bl) {
        Ide.setProperty(this.getViewCategory() + TOOLBAR_VISIBLE_PROP, Boolean.toString(bl));
        Iterator iterator = this._views.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ((View)iterator.next()).setToolbarVisible(bl);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction != null) {
            int n = ideAction.getCommandId();
            if (n == 67) {
                this.showView(context);
                return true;
            }
            if (this._toggleToolbarAction != null && n == this._toggleToolbarAction.getCommandId()) {
                this.setToolbarVisible(this.isToolbarVisible() ^ true);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction != null) {
            int n = ideAction.getCommandId();
            if (n == 67) {
                ideAction.setEnabled(true);
                return true;
            }
            if (this._toggleToolbarAction != null && n == this._toggleToolbarAction.getCommandId()) {
                ideAction.setEnabled(true);
                ideAction.setState(this.isToolbarVisible());
                return true;
            }
        }
        return false;
    }

    private void registerView(View view) {
        this.addView(view);
        view.addViewListener(this._listener);
    }

    private void addView(View view) {
        this._views.remove(view);
        this._views.add(view);
    }

    private void removeView(View view) {
        if (this._views.contains(view)) {
            this._views.remove(view);
        }
    }

    public MultiManager() {
        this.$init$();
    }

    static void mav$addView(MultiManager multiManager, View view) {
        multiManager.addView(view);
    }

    static void mav$removeView(MultiManager multiManager, View view) {
        multiManager.removeView(view);
    }

    private class L
    implements ViewListener {
        public void viewClosed(ViewEvent viewEvent) {
            View view;
            if (viewEvent != null && (view = viewEvent.getView()) != null) {
                MultiManager.mav$removeView(MultiManager.this, view);
            }
        }

        public void viewActivated(ViewEvent viewEvent) {
            View view;
            if (viewEvent != null && (view = viewEvent.getView()) != null) {
                MultiManager.mav$addView(MultiManager.this, view);
            }
        }

        public void viewDeactivated(ViewEvent viewEvent) {
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

