/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableView;
import oracle.ide.view.MultiManager;
import oracle.ide.view.Pinnable;
import oracle.ide.view.View;

public abstract class PinnableManager
extends MultiManager {
    private static final String PINNED_STATE = "PinnableManager.PINNED_STATE";

    public DockableView showLastView(Context context) {
        if (context != null) {
            PinnableManager.setPinnedState(context, false);
        }
        return super.showLastView(context);
    }

    public DockableView showView(Context context) {
        boolean bl;
        DockableView dockableView = super.showView(context);
        if (dockableView instanceof Pinnable && (bl = PinnableManager.getPinnedState(context))) {
            ((Pinnable)((Object)dockableView)).setPinState(2);
        }
        return dockableView;
    }

    private static boolean getPinnedState(Context context) {
        if (context != null) {
            return Boolean.TRUE.equals(context.getProperty(PINNED_STATE));
        }
        return false;
    }

    private static void setPinnedState(Context context, boolean bl) {
        if (context != null) {
            context.setProperty(PINNED_STATE, bl);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n;
        if (ideAction != null && (n = ideAction.getCommandId()) == 68) {
            View view = context.getView();
            if (view instanceof Pinnable) {
                ideAction.setEnabled(true);
                Pinnable pinnable = (Pinnable)((Object)view);
                ideAction.setState(pinnable.getPinState() != 0);
            } else {
                ideAction.setEnabled(false);
                ideAction.setState(false);
            }
            return true;
        }
        return super.update(ideAction, context);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n;
        int n2 = n = ideAction != null ? ideAction.getCommandId() : -1;
        if (n == 68) {
            View view = context.getView();
            if (view instanceof Pinnable) {
                Pinnable pinnable = (Pinnable)((Object)view);
                int n3 = pinnable.getPinState() == 2 ? 0 : 2;
                pinnable.setPinState(n3);
            }
            return true;
        }
        return super.handleEvent(ideAction, context);
    }
}

