/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.view;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.Timer;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.util.CopyOnWriteList;

public abstract class View
implements Helpable,
ControllerProvider {
    public static final String VISIBLE_PROP = ".visible";
    public static final String PROJECT_PROP = ".project";
    public static final String WORKSPACE_PROP = ".workspace";
    public static final Element[] EMPTY_SELECTION = new Element[0];
    private static int COUNTER = 0;
    private View _owner;
    private String _viewId;
    private Element[] _selection;
    private final CopyOnWriteList _viewListeners;
    private final CopyOnWriteList _viewSelectionListeners;
    private Timer _timer;

    void $init$() {
        this._selection = EMPTY_SELECTION;
        this._viewListeners = new CopyOnWriteList(ViewListener.class);
        this._viewSelectionListeners = new CopyOnWriteList(ViewSelectionListener.class);
    }

    protected View() {
        this(null);
    }

    protected View(String string) {
        this.$init$();
        this._viewId = string;
    }

    public Controller getController() {
        return null;
    }

    public HelpInfo getHelpInfo() {
        return HelpInfo.getDefaultHelpInfo();
    }

    public final View owner() {
        return this._owner;
    }

    public void close() {
        this.fireViewClosed();
    }

    public void show() {
        this.getGUI().setVisible(true);
        this.updateSelection();
    }

    public boolean isVisible() {
        return this.getGUI().isVisible();
    }

    public abstract Component getGUI();

    public final Context getContext() {
        return this.getContext(null);
    }

    public Context getContext(EventObject eventObject) {
        return Context.newIdeContext(this, eventObject);
    }

    public ContextMenu getContextMenu() {
        return null;
    }

    public void activate() {
        this.fireViewActivated();
    }

    public void deactivate() {
        this.fireViewDeactivated();
    }

    public final Element[] getSelection() {
        return this._selection;
    }

    public final String getId() {
        if (this._viewId == null) {
            this._viewId = this.newId();
        }
        return this._viewId;
    }

    public void updateTitle(Object object) {
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        View.updateToolbarActions(this.getToolbar());
    }

    public Toolbar getToolbar() {
        return null;
    }

    public void setToolbarVisible(boolean bl) {
    }

    public final void addViewListener(ViewListener viewListener) {
        this._viewListeners.addIfAbsent((Object)viewListener);
    }

    public final void removeViewListener(ViewListener viewListener) {
        this._viewListeners.remove((Object)viewListener);
    }

    public final void addViewSelectionListener(ViewSelectionListener viewSelectionListener) {
        this._viewSelectionListeners.addIfAbsent((Object)viewSelectionListener);
    }

    public final void removeViewSelectionListener(ViewSelectionListener viewSelectionListener) {
        this._viewSelectionListeners.remove((Object)viewSelectionListener);
    }

    public final void updateSelection() {
        this.updateSelectionImpl(false);
    }

    public final void scheduleUpdateSelection() {
        if (EventQueue.isDispatchThread()) {
            Element[] elementArray = this.getSelectionFromUI();
            if (this.setSelection(elementArray)) {
                if (this._timer == null) {
                    this._timer = new Timer(250, new 4());
                    this._timer.setRepeats(false);
                }
                this._timer.restart();
            }
        } else {
            EventQueue.invokeLater(new 3());
        }
    }

    public final void updateVisibleActions() {
        this.updateVisibleActions(new UpdateMessage(Controller.UPDATE_FROM_USER_EXTENSION, null));
    }

    public static final void updateToolbarActions(Toolbar toolbar) {
        Action[] actionArray;
        if (toolbar != null && toolbar.isShowing() && (actionArray = toolbar.getActions()) != null) {
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                if (action instanceof IdeAction) {
                    ((IdeAction)action).updateAction();
                }
                ++n2;
            }
        }
    }

    public static final void loadManifestToolbar(String string, Toolbar toolbar, View view) {
        ToolbarManager.getToolbarManager().installToolbar(string, toolbar, view);
    }

    public static final void loadManifestToolbar(String string, Toolbar toolbar) {
        View.loadManifestToolbar(string, toolbar, null);
    }

    protected Element[] getSelectionFromUI() {
        return EMPTY_SELECTION;
    }

    protected final void updateSelectionImpl(boolean bl) {
        if (EventQueue.isDispatchThread()) {
            Element[] elementArray = this.getSelectionFromUI();
            if (this.setSelection(elementArray)) {
                ViewSelectionEvent viewSelectionEvent = new ViewSelectionEvent(this);
                if (bl) {
                    EventQueue.invokeLater(new 2(this, viewSelectionEvent));
                } else {
                    this.fireViewSelectionChanged(viewSelectionEvent);
                }
            }
        } else {
            EventQueue.invokeLater(new 1(this, bl));
        }
    }

    protected final void setId(String string) {
        this._viewId = string;
    }

    protected String newId() {
        return "UnknownView" + ++COUNTER;
    }

    protected void setOwner(View view) {
        this._owner = view;
    }

    protected void fireViewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        ViewSelectionListener[] viewSelectionListenerArray = (ViewSelectionListener[])this._viewSelectionListeners.getItems();
        int n = viewSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            viewSelectionListenerArray[n2].viewSelectionChanged(viewSelectionEvent);
            ++n2;
        }
    }

    protected final void fireViewClosed() {
        ViewListener[] viewListenerArray = (ViewListener[])this._viewListeners.getItems();
        int n = viewListenerArray.length;
        if (n > 0) {
            ViewEvent viewEvent = this.newViewEvent(3);
            int n2 = 0;
            while (n2 < n) {
                viewListenerArray[n2].viewClosed(viewEvent);
                ++n2;
            }
        }
    }

    private ViewEvent newViewEvent(int n) {
        return new ViewEvent(this, n);
    }

    private void fireViewActivated() {
        ViewListener[] viewListenerArray = (ViewListener[])this._viewListeners.getItems();
        int n = viewListenerArray.length;
        if (n > 0) {
            ViewEvent viewEvent = this.newViewEvent(1);
            int n2 = 0;
            while (n2 < n) {
                viewListenerArray[n2].viewActivated(viewEvent);
                ++n2;
            }
        }
    }

    private void fireViewDeactivated() {
        ViewListener[] viewListenerArray = (ViewListener[])this._viewListeners.getItems();
        int n = viewListenerArray.length;
        if (n > 0) {
            ViewEvent viewEvent = this.newViewEvent(2);
            int n2 = 0;
            while (n2 < n) {
                viewListenerArray[n2].viewDeactivated(viewEvent);
                ++n2;
            }
        }
    }

    private boolean setSelection(Element[] elementArray) {
        if (elementArray == null) {
            elementArray = EMPTY_SELECTION;
        }
        if (elementArray != this._selection) {
            if (elementArray.length == this._selection.length) {
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (elementArray[n2] != this._selection[n2]) {
                        this._selection = elementArray;
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            this._selection = elementArray;
            return true;
        }
        return false;
    }

    static void wa$_timer(View view, Timer timer) {
        view._timer = timer;
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            View.wa$_timer(View.this, null);
            ViewSelectionEvent viewSelectionEvent = new ViewSelectionEvent(View.this);
            View.this.fireViewSelectionChanged(viewSelectionEvent);
        }
    }

    public final class 3
    implements Runnable {
        public void run() {
            View.this.scheduleUpdateSelection();
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ ViewSelectionEvent v$event;
        final /* synthetic */ View this$0;

        public void run() {
            this.this$0.fireViewSelectionChanged(this.v$event);
        }

        public 2(View view, ViewSelectionEvent viewSelectionEvent) {
            this.v$event = viewSelectionEvent;
            this.this$0 = view;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$doNotifyOnInvokeLater;
        final /* synthetic */ View this$0;

        public void run() {
            this.this$0.updateSelectionImpl(this.v$doNotifyOnInvokeLater);
        }

        public 1(View view, boolean bl) {
            this.v$doNotifyOnInvokeLater = bl;
            this.this$0 = view;
        }
    }
}

