/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.BrowserArb;
import oracle.ide.webbrowser.URLHyperlinkButton;
import oracle.ide.webbrowser.WOCAuthenticator;
import oracle.javatools.dialogs.MessageDialog;

public final class OTNAuthPanel
extends JPanel {
    private final GridBagLayout _layout;
    private final MultiLineLabel _hint;
    private final JLabel _lbUserName;
    private final JTextField _tfUserName;
    private final JLabel _lbPassword;
    private final JPasswordField _pfPassword;
    private final URLHyperlinkButton _hlSignUp;
    private final URLHyperlinkButton _hlLostPassword;
    private static final String COMPLETE = "complete";

    void $init$() {
        this._layout = new GridBagLayout();
        this._hint = new MultiLineLabel();
        this._lbUserName = new JLabel();
        this._tfUserName = new JTextField();
        this._lbPassword = new JLabel();
        this._pfPassword = new JPasswordField();
        this._hlSignUp = new URLHyperlinkButton();
        this._hlLostPassword = new URLHyperlinkButton();
    }

    public OTNAuthPanel() {
        this.$init$();
        this._hint.setTextWrapper(WordWrapper.getTextWrapper());
        this._hint.setMinimumRows(1);
        this._hint.setPreferredAspectRatio(10.0f);
        this._hint.setVerticalShrinking(false);
        this._hlSignUp.setURL(URLFactory.newURL("https://profile.oracle.com/jsp/reg/createUser.jsp?act=5&src=1180588&nexturl=http://www.oracle.com/technology/index.html&language=en"));
        this._hlLostPassword.setURL(URLFactory.newURL("http://profile.oracle.com/jsp/reg/LostPassword.jsp"));
        this.resControls();
        this.layoutControls();
        this.installListeners();
    }

    private void resControls() {
        this._hint.setText(BrowserArb.getString(0));
        ResourceUtils.resLabel(this._lbUserName, this._tfUserName, BrowserArb.getString(1));
        ResourceUtils.resLabel(this._lbPassword, this._pfPassword, BrowserArb.getString(2));
        ResourceUtils.resButton((AbstractButton)((Object)this._hlSignUp), BrowserArb.getString(3));
        ResourceUtils.resButton((AbstractButton)((Object)this._hlLostPassword), BrowserArb.getString(4));
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this._hint, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this._lbUserName, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._tfUserName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this._lbPassword, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._pfPassword, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)((Object)this._hlSignUp), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)((Object)this._hlLostPassword), gridBagConstraints);
    }

    private void installListeners() {
        2 var1_1 = new 2();
        this._tfUserName.getDocument().addDocumentListener(var1_1);
        this._pfPassword.getDocument().addDocumentListener(var1_1);
    }

    private boolean isComplete() {
        return this._tfUserName.getText().trim().length() > 0 && this._pfPassword.getPassword().length > 0;
    }

    public void setLostPasswordUrl(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("lostPasswordUrl is null");
        }
        this._hlLostPassword.setURL(uRL);
    }

    public void setSignUpUrl(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("signUpUrl is null");
        }
        this._hlSignUp.setURL(uRL);
    }

    public void setHintText(String string) {
        if (string == null) {
            throw new NullPointerException("hintText is null");
        }
        this._hint.setText(string);
    }

    public PasswordAuthentication runDialog(Component component, String string) {
        if (string == null) {
            throw new NullPointerException("title is null");
        }
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)string, (int)7);
        jEWTDialog.setContent((Component)this);
        if (this._tfUserName.getText().length() > 0) {
            jEWTDialog.setInitialFocus((Component)this._pfPassword);
        } else {
            jEWTDialog.setInitialFocus((Component)this._tfUserName);
        }
        jEWTDialog.setOKButtonEnabled(this.isComplete());
        1 var4_4 = new 1(this, jEWTDialog);
        try {
            this.addPropertyChangeListener(COMPLETE, var4_4);
            if (jEWTDialog.runDialog()) {
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this._tfUserName.getText().trim(), this._pfPassword.getPassword());
                this._pfPassword.setText("");
                this._pfPassword.setCaretPosition(0);
                this.removePropertyChangeListener(COMPLETE, var4_4);
                return passwordAuthentication;
            }
        }
        finally {
            this._pfPassword.setText("");
            this._pfPassword.setCaretPosition(0);
            this.removePropertyChangeListener(COMPLETE, var4_4);
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        WOCAuthenticator wOCAuthenticator;
        WOCAuthenticator.AuthenticationToken authenticationToken;
        OTNAuthPanel oTNAuthPanel = new OTNAuthPanel();
        PasswordAuthentication passwordAuthentication = oTNAuthPanel.runDialog(null, "Test");
        if (passwordAuthentication == null) {
            MessageDialog.error(null, (Object)"Auth Canceled!", (String)"Canceled", null);
            System.exit(0);
        }
        if ((authenticationToken = (wOCAuthenticator = new WOCAuthenticator()).logIn(passwordAuthentication)) == null) {
            MessageDialog.error(null, (Object)"Auth Failed!", (String)"Failed", null);
            System.exit(0);
        }
        MessageDialog.information(null, (Object)"Auth Success!", (String)"Success", null);
        System.exit(0);
    }

    static boolean mav$isComplete(OTNAuthPanel oTNAuthPanel) {
        return oTNAuthPanel.isComplete();
    }

    public final class 2
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            boolean bl = OTNAuthPanel.mav$isComplete(OTNAuthPanel.this);
            OTNAuthPanel.this.firePropertyChange(OTNAuthPanel.COMPLETE, bl ^ true, bl);
        }
    }

    public final class 1
    implements PropertyChangeListener {
        private final /* synthetic */ JEWTDialog v$jd;
        final /* synthetic */ OTNAuthPanel this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.v$jd.setOKButtonEnabled(OTNAuthPanel.mav$isComplete(this.this$0));
        }

        public 1(OTNAuthPanel oTNAuthPanel, JEWTDialog jEWTDialog) {
            this.v$jd = jEWTDialog;
            this.this$0 = oTNAuthPanel;
        }
    }
}

